/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import java.util.List;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.dialogs.VariablesEditDialog;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ParametersEditDialog
extends VariablesEditDialog {
    private Combo queryCombo;
    private String query;

    public ParametersEditDialog(Shell shell, PatternParameter selectItem, TransactionalEditingDomain editingDomain) {
        super(shell, selectItem, editingDomain);
        this.setDefaultQuery(selectItem);
    }

    private void setDefaultQuery(PatternParameter selectItem) {
        Query itemQuery = selectItem.getQuery();
        this.query = itemQuery == null ? "" : itemQuery.getExtensionId();
        QueryKind queryKind = IQuery.INSTANCE.getQueryKind(this.query);
        if (queryKind != null) {
            this.query = queryKind.getName();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        ParametersEditDialog.createLabel(dialogArea, Messages.ParametersEditDialog_Query);
        this.queryCombo = new Combo(dialogArea, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.queryCombo.setLayoutData((Object)gd);
        this.queryCombo.add(this.query);
        this.setQueryComboList(this.queryCombo, this.query);
        this.queryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParametersEditDialog.this.query = ParametersEditDialog.this.queryCombo.getText();
            }
        });
        this.queryCombo.select(0);
        return dialogArea;
    }

    private void setQueryComboList(Combo combo, String query) {
        List availableQueries = IQuery.INSTANCE.getAvailableQueries();
        for (QueryKind kind : availableQueries) {
            String name = kind.getName();
            if (name.equals(query)) continue;
            combo.add(name);
        }
    }

    public String getQuery() {
        return this.query;
    }
}

