/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.domain;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.ObjectHolder;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ResourceLoadedListener
implements WorkspaceSynchronizer.Delegate {
    public static final ResourceEventManager RESOURCE_MANAGER = new ResourceEventManager();

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        resource.unload();
        for (ResourceListener l : ResourceLoadedListener.RESOURCE_MANAGER.listeners) {
            l.resourceMoved(resource, newURI);
        }
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        resource.unload();
        for (ResourceListener l : ResourceLoadedListener.RESOURCE_MANAGER.listeners) {
            l.resourceDeleted(resource);
        }
        return true;
    }

    public boolean handleResourceChanged(Resource resource) {
        if (this.need2reload(resource)) {
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.egf.pattern.ui.editors.PatternEditingDomain");
            editingDomain.getCommandStack().flush();
            try {
                resource.unload();
                resource.load(resource.getResourceSet().getLoadOptions());
            }
            catch (IOException e) {
                Activator.getDefault().logError(e);
            }
        }
        for (ResourceListener l : ResourceLoadedListener.RESOURCE_MANAGER.listeners) {
            l.resourceChanged(resource);
        }
        return true;
    }

    private boolean need2reload(Resource resource) {
        List<ResourceUser> users = ResourceLoadedListener.RESOURCE_MANAGER.observers.get(resource);
        if (users == null) {
            return true;
        }
        final ObjectHolder reload = new ObjectHolder();
        boolean dirty = false;
        for (ResourceUser user : users) {
            dirty |= user.isDirty();
        }
        if (!dirty) {
            return true;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null) {
                    reload.object = MessageDialog.openQuestion((Shell)activeWorkbenchWindow.getShell(), (String)Messages.ResourceListener_reloadDialog_title, (String)Messages.ResourceListener_reloadDialog_message);
                }
            }
        });
        return (Boolean)reload.object;
    }

    public void dispose() {
    }

    public static class ResourceEventManager {
        final List<ResourceListener> listeners = new ArrayList<ResourceListener>();
        final Map<Resource, List<ResourceUser>> observers = new HashMap<Resource, List<ResourceUser>>();

        public void addObserver(ResourceUser u) {
            Resource resource = u.getResource();
            List<ResourceUser> list = this.observers.get(resource);
            if (list == null) {
                list = new ArrayList<ResourceUser>();
                this.observers.put(resource, list);
            }
            list.add(u);
            this.listeners.add(u.getListener());
        }

        public void removeObserver(ResourceUser u) {
            Resource resource = u.getResource();
            List<ResourceUser> list = this.observers.get(resource);
            if (list == null) {
                return;
            }
            list.remove(u);
            this.listeners.remove(u.getListener());
            if (this.noMoreObserver()) {
                this.clearResourceSet();
            }
        }

        private void clearResourceSet() {
            final TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.egf.pattern.ui.editors.PatternEditingDomain");
            try {
                editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        for (Resource res : editingDomain.getResourceSet().getResources()) {
                            res.unload();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e);
            }
        }

        private boolean noMoreObserver() {
            for (List<ResourceUser> users : this.observers.values()) {
                if (users.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public WorkspaceModifyOperation createSaveOperation(ResourceUser u, final TransactionalEditingDomain editingDomain) {
            if (u == null) {
                throw new IllegalArgumentException();
            }
            if (u.getResource() == null) {
                throw new IllegalArgumentException();
            }
            final Resource resource = u.getResource();
            final ObjectHolder holder = new ObjectHolder();
            return new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    editingDomain.runExclusive(new Runnable(){

                        public void run() {
                            try {
                                resource.save(Collections.EMPTY_MAP);
                            }
                            catch (Exception exception) {
                                holder.object = exception;
                            }
                        }
                    });
                    if (holder.object != null) {
                        throw new InvocationTargetException((Throwable)holder.object);
                    }
                }
            };
        }
    }

    public static interface ResourceListener {
        public void resourceDeleted(Resource var1);

        public void resourceMoved(Resource var1, URI var2);

        public void resourceChanged(Resource var1);
    }

    public static interface ResourceUser {
        public Resource getResource();

        public boolean isDirty();

        public ResourceListener getListener();
    }
}

