/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.pages;

import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.SuperPatternCall;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.ImageShop;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.PatternTemplateEditor;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.adapter.RefresherAdapter;
import org.eclipse.egf.pattern.ui.editors.dialogs.MethodAddOrEditDialog;
import org.eclipse.egf.pattern.ui.editors.dialogs.VariablesEditDialog;
import org.eclipse.egf.pattern.ui.editors.editor.MethodsComboBoxViewerCellEditor;
import org.eclipse.egf.pattern.ui.editors.modifiers.MethodTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.modifiers.VariablesTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.MethodLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.OrchestrationTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.TableObservableListContentProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OpenTypeWizard;
import org.eclipse.egf.pattern.ui.editors.wizards.OrchestrationWizard;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.CallTypeEnum;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationPage
extends PatternEditorPage {
    public static final String ID = "ImplementationPage";
    private TableViewer methodsTableViewer;
    private TableViewer variablesTableViewer;
    private TableViewer orchestrationTableViewer;
    public static final String NAME_COLUMN_ID = "Name";
    public static final String TYPE_COLUMN_ID = "Type";
    private Button methodsAdd;
    private Button methodsEdit;
    private Button methodsRemove;
    private Button methodsOpenTemplate;
    private Button orchestrationAdd;
    private Button orchestrationEdit;
    private Button orchestrationRemove;
    private Button orchestrationUp;
    private Button orchestrationDown;
    private Button variablesAdd;
    private Button variablesEdit;
    private Button variablesRemove;
    private MethodsComboBoxViewerCellEditor nameEditor;
    private PatternMethod dropEntry;
    private int dragIndex = -1;
    private boolean isChangeOder;
    private boolean isReadOnly;
    private static final String VARIABLE_NAME_DEFAULT_VALUE = "variable";
    private static final String VARIABLE_TYPE_DEFAULT_VALUE = "http://www.eclipse.org/emf/2002/Ecore#//EClass";
    private LiveValidationContentAdapter liveValidationContentAdapter;

    public ImplementationPage(FormEditor editor) {
        super(editor, ID, Messages.ImplementationPage_title);
    }

    @Override
    protected void doCreateFormContent(IManagedForm managedForm) {
        PatternEditorInput editorInput = (PatternEditorInput)this.getEditorInput();
        this.isReadOnly = editorInput.isReadOnly();
        IMessageManager mmng = managedForm.getMessageManager();
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        GridLayout layout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)layout);
        form.setImage(ImageShop.get("/icons/plugin_mf_obj.gif"));
        form.setText(Messages.ImplementationPage_title);
        Composite containerLeft = this.createComposite(toolkit, form);
        this.createMethodsSection(toolkit, containerLeft);
        this.createVariablesSection(toolkit, containerLeft);
        Composite containerRight = this.createComposite(toolkit, form);
        this.createOrchestrationSection(toolkit, containerRight);
        this.checkReadOnlyModel();
        this.liveValidationContentAdapter = PatternUIHelper.addEMFValidation(mmng, this.getPattern(), Messages.PatternUIHelper_key_NonPatternVariableEmptyName, (Control)this.variablesTableViewer.getTable(), this.liveValidationContentAdapter);
        form.reflow(true);
    }

    private void checkReadOnlyModel() {
        if (!this.isReadOnly) {
            return;
        }
        this.methodsAdd.setEnabled(false);
        this.methodsEdit.setEnabled(false);
        this.methodsRemove.setEnabled(false);
        this.methodsOpenTemplate.setEnabled(false);
        this.orchestrationAdd.setEnabled(false);
        this.orchestrationEdit.setEnabled(false);
        this.orchestrationUp.setEnabled(false);
        this.orchestrationDown.setEnabled(false);
        this.variablesAdd.setEnabled(false);
        this.variablesEdit.setEnabled(false);
        this.variablesRemove.setEnabled(false);
    }

    private Composite createComposite(FormToolkit toolkit, ScrolledForm form) {
        Composite composite = toolkit.createComposite(form.getBody(), 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1810);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    private void createMethodsSection(FormToolkit toolkit, Composite composite) {
        Section methSection = toolkit.createSection(composite, 256);
        methSection.setText(Messages.ImplementationPage_Methods);
        GridData gd = new GridData(1810);
        methSection.setLayoutData((Object)gd);
        String label = Messages.ImplementationPage_methSection_label;
        Composite methods = this.createComposite(toolkit, methSection, label);
        this.createMethodsTable(toolkit, methods);
        this.createMethodsButtons(toolkit, methods);
        methSection.setClient((Control)methods);
    }

    private void createMethodsTable(FormToolkit toolkit, Composite methods) {
        Table table = toolkit.createTable(methods, 2816);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.methodsTableViewer = new TableViewer(table);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(300);
        this.methodsTableViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.methodsTableViewer));
        this.initMethodsTableEditor();
        this.methodsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ImplementationPage.this.isReadOnly) {
                    return;
                }
                ImplementationPage.this.openPatternTemplate();
            }
        });
        this.methodsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ImplementationPage.this.isReadOnly) {
                    return;
                }
                ImplementationPage.this.setMethodsButtonsStatus();
                CCombo control = (CCombo)ImplementationPage.this.nameEditor.getControl();
                if (control != null && !control.isDisposed()) {
                    PatternMethod selectItem = ImplementationPage.this.getmethodsSelectItem();
                    control.setText(selectItem == null ? "" : selectItem.getName());
                }
            }
        });
        if (!this.isReadOnly) {
            this.methodsTableViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

                public void dragStart(DragSourceEvent event) {
                    ImplementationPage.this.isChangeOder = false;
                    if (ImplementationPage.this.methodsTableViewer.getSelection() == null) {
                        event.doit = false;
                    }
                }

                public void dragSetData(DragSourceEvent event) {
                    if (ImplementationPage.this.methodsTableViewer.getSelection() != null) {
                        ImplementationPage.this.dropEntry = ImplementationPage.this.getmethodsSelectItem();
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                }
            });
        }
    }

    private void initMethodsTableEditor() {
        if (this.isReadOnly) {
            return;
        }
        this.methodsTableViewer.setColumnProperties(new String[]{NAME_COLUMN_ID});
        this.nameEditor = new MethodsComboBoxViewerCellEditor((Composite)this.methodsTableViewer.getTable(), this.getEditingDomain(), this.methodsTableViewer, this);
        this.nameEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.nameEditor.setContenProvider(new CommonListContentProvider());
        this.methodsTableViewer.setCellEditors(new CellEditor[]{this.nameEditor});
        this.methodsTableViewer.setCellModifier((ICellModifier)new MethodTableCellModifier(this.getEditingDomain(), this.methodsTableViewer));
    }

    private void createMethodsButtons(FormToolkit toolkit, final Composite methods) {
        Composite buttons = toolkit.createComposite(methods, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.methodsAdd = toolkit.createButton(buttons, "", 8);
        this.methodsAdd.setLayoutData((Object)gd);
        this.methodsAdd.setImage(ImageShop.get("/icons/add.gif"));
        this.methodsAdd.setToolTipText(Messages.ImplementationPage_button_add);
        this.methodsAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Pattern parent = ImplementationPage.this.getPatternParent();
                MethodAddOrEditDialog dialog = new MethodAddOrEditDialog(new Shell(), PatternUIHelper.getUseablePatternMethodsNameList(parent), "");
                dialog.setTitle(Messages.ImplementationPage_methAdd_dialog_title);
                if (dialog.open() == 0) {
                    ImplementationPage.this.executeMethodsAdd(dialog.getName());
                    ImplementationPage.this.setMethodsButtonsStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsEdit = toolkit.createButton(buttons, "", 8);
        this.methodsEdit.setLayoutData((Object)gd);
        this.methodsEdit.setEnabled(false);
        this.methodsEdit.setImage(ImageShop.get("/icons/edit.gif"));
        this.methodsEdit.setToolTipText(Messages.ImplementationPage_button_edit);
        this.methodsEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object entry;
                int index = ImplementationPage.this.methodsTableViewer.getTable().getSelectionIndex();
                String selectName = "";
                if (index >= 0 && (entry = ImplementationPage.this.methodsTableViewer.getElementAt(index)) instanceof PatternMethod) {
                    selectName = ((PatternMethod)entry).getName();
                }
                Pattern parent = ImplementationPage.this.getPatternParent();
                MethodAddOrEditDialog dialog = new MethodAddOrEditDialog(new Shell(), PatternUIHelper.getUseablePatternMethodsNameList(parent), selectName);
                dialog.setTitle(Messages.ImplementationPage_methEdit_dialog_title);
                if (dialog.open() == 0) {
                    ImplementationPage.this.executeMethodsEdit(dialog.getName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsRemove = toolkit.createButton(buttons, "", 8);
        this.methodsRemove.setLayoutData((Object)gd);
        this.methodsRemove.setEnabled(false);
        this.methodsRemove.setImage(ImageShop.get("/icons/delete.gif"));
        this.methodsRemove.setToolTipText(Messages.ImplementationPage_button_remove);
        this.methodsRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeMethodsRemove(methods);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsOpenTemplate = toolkit.createButton(buttons, "", 8);
        this.methodsOpenTemplate.setLayoutData((Object)gd);
        this.methodsOpenTemplate.setEnabled(false);
        this.methodsOpenTemplate.setImage(ImageShop.get("/icons/method_content_edit.gif"));
        this.methodsOpenTemplate.setToolTipText(Messages.ImplementationPage_button_methodsOpenTemplate);
        this.methodsOpenTemplate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.openPatternTemplate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setMethodsButtonsStatus() {
        int selectIndex = this.methodsTableViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.methodsRemove.setEnabled(false);
            this.methodsEdit.setEnabled(false);
            this.methodsOpenTemplate.setEnabled(false);
            return;
        }
        PatternMethod selectMethod = (PatternMethod)this.methodsTableViewer.getElementAt(selectIndex);
        if (PatternUIHelper.isRenameDisable(selectMethod)) {
            this.methodsEdit.setEnabled(false);
            this.methodsRemove.setEnabled(false);
        } else {
            this.methodsEdit.setEnabled(true);
            this.methodsRemove.setEnabled(true);
        }
        this.methodsOpenTemplate.setEnabled(true);
    }

    private void executeMethodsRemove(Composite methods) {
        Object selectItem;
        int index = this.methodsTableViewer.getTable().getSelectionIndex();
        if (index >= 0 && (selectItem = this.methodsTableViewer.getElementAt(index)) instanceof PatternMethod) {
            if (this.isMethodDeleteDisable((PatternMethod)selectItem)) {
                String message = Messages.ImplementationPage_method_cannot_delete_message;
                this.showErrorMessage(methods, message);
                return;
            }
            final Pattern pattern = this.getPattern();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    pattern.getMethods().remove(selectItem);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            EList allVariables = pattern.getMethods();
            this.setDefaultSelection(allVariables, this.methodsTableViewer, index);
        }
        this.setMethodsButtonsStatus();
    }

    private void executeMethodsAdd(final String name) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                PatternMethod newMethod = PatternFactory.eINSTANCE.createPatternMethod();
                newMethod.setName(name);
                newMethod.setPattern(ImplementationPage.this.getPattern());
                ImplementationPage.this.getPattern().getMethods().add((Object)newMethod);
                newMethod.setPatternFilePath(PatternHelper.Filename.computeFileURI((PatternMethod)newMethod));
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        this.methodsTableViewer.getTable().setSelection(this.methodsTableViewer.getTable().getItemCount() - 1);
    }

    protected void executeMethodsEdit(final String name) {
        int index = this.methodsTableViewer.getTable().getSelectionIndex();
        final PatternMethod editPatternMethod = (PatternMethod)this.methodsTableViewer.getElementAt(index);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                editPatternMethod.setName(name);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    private void openPatternTemplate() {
        Pattern pattern = this.getPattern();
        ISelection selection = this.methodsTableViewer.getSelection();
        String methodId = null;
        if (selection != null && !selection.isEmpty()) {
            PatternMethod method = (PatternMethod)((IStructuredSelection)selection).getFirstElement();
            methodId = method.getID();
        }
        PatternTemplateEditor.openEditor(this.getEditorSite().getPage(), pattern, methodId);
    }

    private void createOrchestrationSection(FormToolkit toolkit, Composite composite) {
        Section orchSection = toolkit.createSection(composite, 256);
        orchSection.setText(Messages.ImplementationPage_orchSection_title);
        GridData gd = new GridData(1810);
        orchSection.setLayoutData((Object)gd);
        String label = Messages.ImplementationPage_orchSection_label;
        Composite orchestration = this.createComposite(toolkit, orchSection, label);
        this.createOrchestrationTable(toolkit, orchestration);
        this.createOrchestrationButtons(toolkit, orchestration);
        orchSection.setClient((Control)orchestration);
    }

    private void createOrchestrationTable(FormToolkit toolkit, Composite orchestration) {
        Composite tableComp = new Composite(orchestration, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        Table table = toolkit.createTable(tableComp, 2816);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.orchestrationTableViewer = new TableViewer(table);
        TableColumn tableColumn = new TableColumn(table, 0);
        layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(230, true));
        this.orchestrationTableViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.orchestrationTableViewer));
        this.orchestrationTableViewer.setLabelProvider((IBaseLabelProvider)new OrchestrationTableLabelProvider());
        this.orchestrationTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ImplementationPage.this.isReadOnly) {
                    return;
                }
                ImplementationPage.this.setOrchestrationButtonsStatus();
            }
        });
        this.orchestrationTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ImplementationPage.this.isReadOnly) {
                    return;
                }
                ImplementationPage.this.openOrchestrationWizard();
            }
        });
        this.addDragDrop();
    }

    private void addDragDrop() {
        if (this.isReadOnly) {
            return;
        }
        this.orchestrationTableViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ImplementationPage.this.isChangeOder = true;
                if (ImplementationPage.this.orchestrationTableViewer.getSelection() == null) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (ImplementationPage.this.orchestrationTableViewer.getSelection() != null) {
                    ImplementationPage.this.dragIndex = ImplementationPage.this.orchestrationTableViewer.getTable().getSelectionIndex();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.orchestrationTableViewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.orchestrationTableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (!ImplementationPage.this.isChangeOder) {
                    return ImplementationPage.this.checkDropSupport();
                }
                return true;
            }

            public boolean performDrop(Object data) {
                if (ImplementationPage.this.isChangeOder) {
                    Object currentTarget = this.getCurrentTarget();
                    ImplementationPage.this.executeChangeOrder(currentTarget);
                } else {
                    ImplementationPage.this.executeDrop();
                }
                return false;
            }
        });
    }

    protected void executeChangeOrder(Object currentTarget) {
        EList orchestration = this.getPattern().getOrchestration();
        int targetIndex = 0;
        int index = 0;
        if (currentTarget == null) {
            targetIndex = this.orchestrationTableViewer.getTable().getItemCount() - 1;
            currentTarget = this.orchestrationTableViewer.getElementAt(targetIndex);
        } else {
            for (Object enty : orchestration) {
                if (currentTarget.equals(enty)) {
                    targetIndex = index;
                    break;
                }
                ++index;
            }
        }
        this.updateOrchestration((EList<Call>)orchestration, targetIndex);
        this.orchestrationTableViewer.getTable().setSelection(targetIndex);
        this.setOrchestrationButtonsStatus();
    }

    private void updateOrchestration(final EList<Call> orchestration, final int targetIndex) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                orchestration.move(targetIndex, ImplementationPage.this.dragIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected boolean checkDropSupport() {
        int index = this.methodsTableViewer.getTable().getSelectionIndex();
        PatternMethod drag = (PatternMethod)this.methodsTableViewer.getElementAt(index);
        String name = drag.getName();
        return !Messages.ImplementationPage_header.equals(name) && !Messages.ImplementationPage_init.equals(name) && !Messages.ImplementationPage_footer.equals(name);
    }

    protected void executeDrop() {
        if (this.dropEntry != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    MethodCall methodCallNew = PatternFactory.eINSTANCE.createMethodCall();
                    methodCallNew.setCalled(ImplementationPage.this.dropEntry);
                    methodCallNew.setPattern(ImplementationPage.this.getPattern());
                    ImplementationPage.this.getPattern().getOrchestration().add((Object)methodCallNew);
                    ImplementationPage.this.addAdapterForNewItem(ImplementationPage.this.orchestrationTableViewer, methodCallNew);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            this.setOrchestrationButtonsStatus();
        }
    }

    private void createOrchestrationButtons(FormToolkit toolkit, Composite orchestration) {
        Composite buttons = toolkit.createComposite(orchestration, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.orchestrationAdd = toolkit.createButton(buttons, "", 8);
        this.orchestrationAdd.setLayoutData((Object)gd);
        this.orchestrationAdd.setImage(ImageShop.get("/icons/add.gif"));
        this.orchestrationAdd.setToolTipText(Messages.ImplementationPage_button_add);
        this.orchestrationAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OrchestrationWizard wizard = new OrchestrationWizard(ImplementationPage.this.getPattern(), CallTypeEnum.Add, null, ImplementationPage.this.getEditingDomain());
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int returnValue = dialog.open();
                if (returnValue == 0) {
                    ImplementationPage.this.exectuteOrchestrationAdd(wizard);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationEdit = toolkit.createButton(buttons, "", 8);
        this.orchestrationEdit.setLayoutData((Object)gd);
        this.orchestrationEdit.setEnabled(false);
        this.orchestrationEdit.setImage(ImageShop.get("/icons/edit.gif"));
        this.orchestrationEdit.setToolTipText(Messages.ImplementationPage_button_edit);
        this.orchestrationEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.openOrchestrationWizard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationRemove = toolkit.createButton(buttons, "", 8);
        this.orchestrationRemove.setLayoutData((Object)gd);
        this.orchestrationRemove.setEnabled(false);
        this.orchestrationRemove.setImage(ImageShop.get("/icons/delete.gif"));
        this.orchestrationRemove.setToolTipText(Messages.ImplementationPage_button_remove);
        this.orchestrationRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.exectueOrchestrationRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationUp = toolkit.createButton(buttons, "", 8);
        this.orchestrationUp.setLayoutData((Object)gd);
        this.orchestrationUp.setEnabled(false);
        this.orchestrationUp.setImage(ImageShop.get("/icons/upward.gif"));
        this.orchestrationUp.setToolTipText(Messages.ImplementationPage_button_up);
        this.orchestrationUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeOrchestrationUpOrDown(-1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationDown = toolkit.createButton(buttons, "", 8);
        this.orchestrationDown.setLayoutData((Object)gd);
        this.orchestrationDown.setEnabled(false);
        this.orchestrationDown.setImage(ImageShop.get("/icons/downward.gif"));
        this.orchestrationDown.setToolTipText(Messages.ImplementationPage_button_down);
        this.orchestrationDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeOrchestrationUpOrDown(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void openOrchestrationWizard() {
        int index = this.orchestrationTableViewer.getTable().getSelectionIndex();
        Object selectItem = this.orchestrationTableViewer.getElementAt(index);
        CallTypeEnum kind = CallTypeEnum.Add;
        if (selectItem instanceof MethodCall) {
            kind = CallTypeEnum.METHOD_CALL;
        } else if (selectItem instanceof PatternCall) {
            kind = CallTypeEnum.PATTERN_CALL;
        } else if (selectItem instanceof PatternInjectedCall) {
            kind = CallTypeEnum.PATTERNINJECTED_CALL;
        } else if (selectItem instanceof SuperPatternCall) {
            kind = CallTypeEnum.SUPERPATTERN_CALL;
        }
        OrchestrationWizard wizard = new OrchestrationWizard(this.getPattern(), kind, selectItem, this.getEditingDomain());
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int returnValue = dialog.open();
        if (returnValue == 0) {
            Call selectCall = wizard.getSelectCall();
            this.exectuteOrchestrationEdit(selectCall, selectItem);
        }
    }

    protected void exectuteOrchestrationAdd(OrchestrationWizard wizard) {
        final Call selectCall = wizard.getSelectCall();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                selectCall.setPattern(ImplementationPage.this.getPattern());
                ImplementationPage.this.getPattern().getOrchestration().add((Object)selectCall);
                ImplementationPage.this.addAdapterForNewItem(ImplementationPage.this.orchestrationTableViewer, selectCall);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        int len = this.getPattern().getOrchestration().size();
        this.orchestrationTableViewer.getTable().setSelection(len - 1);
        this.setOrchestrationButtonsStatus();
    }

    protected void exectuteOrchestrationEdit(final Call selectCall, final Object selectItem) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                if (selectItem instanceof Call) {
                    int modifyIndex = ImplementationPage.this.getPattern().getOrchestration().indexOf(selectItem);
                    if (modifyIndex >= 0) {
                        ImplementationPage.this.getPattern().getOrchestration().set(modifyIndex, (Object)selectCall);
                        ImplementationPage.this.orchestrationTableViewer.getTable().setSelection(modifyIndex);
                    }
                    ImplementationPage.this.setOrchestrationButtonsStatus();
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected void executeOrchestrationUpOrDown(int num) {
        final int oldIndex = this.orchestrationTableViewer.getTable().getSelectionIndex();
        final int newIndex = oldIndex + num;
        final EList orchestration = this.getPattern().getOrchestration();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                orchestration.move(newIndex, oldIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        this.orchestrationTableViewer.getTable().setSelection(newIndex);
        this.setOrchestrationButtonsStatus();
    }

    protected void exectueOrchestrationRemove() {
        int index = this.orchestrationTableViewer.getTable().getSelectionIndex();
        if (index >= 0) {
            final Object selectItem = this.orchestrationTableViewer.getElementAt(index);
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    if (selectItem instanceof Call) {
                        ImplementationPage.this.getPattern().getOrchestration().remove(selectItem);
                    }
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            EList orchestration = this.getPattern().getOrchestration();
            this.setDefaultSelection(orchestration, this.orchestrationTableViewer, index);
        }
        this.setOrchestrationButtonsStatus();
    }

    private void setOrchestrationButtonsStatus() {
        int selectIndex = this.orchestrationTableViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.orchestrationRemove.setEnabled(false);
            this.orchestrationEdit.setEnabled(false);
            this.orchestrationUp.setEnabled(false);
            this.orchestrationDown.setEnabled(false);
            return;
        }
        int length = this.orchestrationTableViewer.getTable().getItemCount();
        if (length > 0) {
            this.orchestrationRemove.setEnabled(true);
            this.orchestrationEdit.setEnabled(true);
        } else {
            this.orchestrationRemove.setEnabled(false);
            this.orchestrationEdit.setEnabled(false);
        }
        if (selectIndex <= 0) {
            this.orchestrationUp.setEnabled(false);
        } else {
            this.orchestrationUp.setEnabled(true);
        }
        if (selectIndex + 1 == length) {
            this.orchestrationDown.setEnabled(false);
        } else {
            this.orchestrationDown.setEnabled(true);
        }
    }

    private void createVariablesSection(FormToolkit toolkit, Composite composite) {
        Section varSection = toolkit.createSection(composite, 256);
        varSection.setText(Messages.ImplementationPage_varSection_title);
        GridData gd = new GridData(1810);
        varSection.setLayoutData((Object)gd);
        String label = Messages.ImplementationPage_varSection_label;
        Composite variables = this.createComposite(toolkit, varSection, label);
        this.createVariablesTable(toolkit, variables);
        this.createVariablesButtons(toolkit, variables);
        varSection.setClient((Control)variables);
    }

    private void createVariablesTable(FormToolkit toolkit, Composite variables) {
        Table table = toolkit.createTable(variables, 68352);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.variablesTableViewer = new TableViewer(table);
        String[] colNames = new String[]{Messages.ImplementationPage_column_title_name, Messages.ImplementationPage_column_title_type};
        int[] colWidths = new int[]{130, 135};
        int i = 0;
        while (i < colNames.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setWidth(colWidths[i]);
            tableColumn.setText(colNames[i]);
            ++i;
        }
        this.initVariablesTableEditor();
        this.variablesTableViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.variablesTableViewer));
        this.variablesTableViewer.setLabelProvider((IBaseLabelProvider)new ParametersTableLabelProvider());
    }

    private void initVariablesTableEditor() {
        if (this.isReadOnly) {
            return;
        }
        this.variablesTableViewer.setColumnProperties(new String[]{NAME_COLUMN_ID, TYPE_COLUMN_ID});
        TextCellEditor nameEditor = new TextCellEditor((Composite)this.variablesTableViewer.getTable());
        DialogCellEditor typeEditor = new DialogCellEditor((Composite)this.variablesTableViewer.getTable()){

            protected Object openDialogBox(Control cellEditorWindow) {
                OpenTypeWizard wizard = new OpenTypeWizard(ImplementationPage.this.getEditingDomain(), ImplementationPage.this.getSelectItemType());
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int returnValue = dialog.open();
                if (returnValue == 0) {
                    if (wizard.getSelectType() instanceof String) {
                        String selectType = (String)wizard.getSelectType();
                        ImplementationPage.this.updateType(selectType);
                    } else if (wizard.getSelectType() instanceof BinaryType) {
                        String selectType = ((BinaryType)wizard.getSelectType()).getFullyQualifiedName();
                        ImplementationPage.this.updateType(selectType);
                    }
                }
                return null;
            }
        };
        this.variablesTableViewer.setCellEditors(new CellEditor[]{nameEditor, typeEditor});
        this.variablesTableViewer.setCellModifier((ICellModifier)new VariablesTableCellModifier(this.getEditingDomain(), this.variablesTableViewer));
        this.variablesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImplementationPage.this.setVariablesButtonsStatus();
            }
        });
    }

    protected void updateType(final String selectType) {
        ISelection selection;
        Object selectItem;
        if (selectType != null && !"".equals(selectType) && (selectItem = ((IStructuredSelection)(selection = this.variablesTableViewer.getSelection())).getFirstElement()) instanceof PatternVariable) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    ((PatternVariable)selectItem).setType(selectType);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            this.variablesTableViewer.refresh();
        }
    }

    protected String getSelectItemType() {
        int selectionIndex = this.variablesTableViewer.getTable().getSelectionIndex();
        Object selectItem = this.variablesTableViewer.getElementAt(selectionIndex);
        if (selectItem instanceof PatternVariable) {
            return ((PatternVariable)selectItem).getType();
        }
        return "";
    }

    protected PatternMethod getmethodsSelectItem() {
        int selectionIndex = this.methodsTableViewer.getTable().getSelectionIndex();
        Object selectItem = this.methodsTableViewer.getElementAt(selectionIndex);
        if (selectItem instanceof PatternMethod) {
            return (PatternMethod)selectItem;
        }
        return null;
    }

    private void createVariablesButtons(FormToolkit toolkit, final Composite variables) {
        Composite buttons = toolkit.createComposite(variables, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.variablesAdd = toolkit.createButton(buttons, "", 8);
        this.variablesAdd.setLayoutData((Object)gd);
        this.variablesAdd.setImage(ImageShop.get("/icons/add.gif"));
        this.variablesAdd.setToolTipText(Messages.ImplementationPage_button_add);
        this.variablesAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeVariablesAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.variablesEdit = toolkit.createButton(buttons, "", 8);
        this.variablesEdit.setLayoutData((Object)gd);
        this.variablesEdit.setEnabled(false);
        this.variablesEdit.setImage(ImageShop.get("/icons/edit.gif"));
        this.variablesEdit.setToolTipText(Messages.ImplementationPage_button_edit);
        this.variablesEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ImplementationPage.this.variablesTableViewer.getSelection();
                final Object selectItem = ((IStructuredSelection)selection).getFirstElement();
                final VariablesEditDialog dialog = new VariablesEditDialog(new Shell(), selectItem, ImplementationPage.this.getEditingDomain());
                dialog.setTitle(Messages.ImplementationPage_variablesEditDialog_title);
                if (dialog.open() == 0) {
                    TransactionalEditingDomain editingDomain = ImplementationPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            ImplementationPage.this.executeVariableEdit(dialog, selectItem);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                    ImplementationPage.this.variablesTableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.variablesRemove = toolkit.createButton(buttons, "", 8);
        this.variablesRemove.setLayoutData((Object)gd);
        this.variablesRemove.setEnabled(false);
        this.variablesRemove.setImage(ImageShop.get("/icons/delete.gif"));
        this.variablesRemove.setToolTipText(Messages.ImplementationPage_button_remove);
        this.variablesRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeVariablesRemove(variables);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setVariablesButtonsStatus() {
        int selectIndex = this.variablesTableViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.variablesRemove.setEnabled(false);
            this.variablesEdit.setEnabled(false);
            return;
        }
        int length = this.variablesTableViewer.getTable().getItemCount();
        if (length > 0) {
            this.variablesRemove.setEnabled(true);
            this.variablesEdit.setEnabled(true);
        } else {
            this.variablesRemove.setEnabled(false);
            this.variablesEdit.setEnabled(false);
        }
    }

    protected void executeVariablesAdd() {
        final Pattern pattern = this.getPattern();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                PatternVariable patternVariableNew = PatternFactory.eINSTANCE.createPatternVariable();
                patternVariableNew.setName(ImplementationPage.VARIABLE_NAME_DEFAULT_VALUE);
                patternVariableNew.setType(ImplementationPage.VARIABLE_TYPE_DEFAULT_VALUE);
                pattern.getVariables().add((Object)patternVariableNew);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        EList allVariables = pattern.getAllVariables();
        int len = allVariables.size();
        this.variablesTableViewer.getTable().setSelection(len - 1);
        this.setVariablesButtonsStatus();
    }

    private void executeVariableEdit(VariablesEditDialog dialog, Object selectItem) {
        String newName = dialog.getName();
        String newType = dialog.getType();
        if (selectItem instanceof PatternVariable) {
            PatternVariable item = (PatternVariable)selectItem;
            item.setName(newName);
            item.setType(newType);
        }
    }

    protected void executeVariablesRemove(Composite variables) {
        ISelection selection;
        Object removeit;
        int index = this.variablesTableViewer.getTable().getSelectionIndex();
        if (index >= 0 && (removeit = ((IStructuredSelection)(selection = this.variablesTableViewer.getSelection())).getFirstElement()) instanceof PatternVariable) {
            if (this.isVariableDeleteDisable((PatternVariable)removeit)) {
                String message = Messages.ImplementationPage_variable_cannot_delete_message;
                this.showErrorMessage(variables, message);
                return;
            }
            final Pattern pattern = this.getPattern();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    pattern.getVariables().remove(removeit);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            EList allParameters = pattern.getAllVariables();
            this.setDefaultSelection(allParameters, this.variablesTableViewer, index);
        }
        this.setVariablesButtonsStatus();
    }

    private Composite createComposite(FormToolkit toolkit, Section section, String label) {
        Composite container = toolkit.createComposite((Composite)section, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label discrip = toolkit.createLabel(container, label, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 4;
        discrip.setLayoutData((Object)gd);
        return container;
    }

    private void setDefaultSelection(EList<?> model, TableViewer tableViewer, int index) {
        int len = model.size();
        if (index < len) {
            tableViewer.getTable().setSelection(index);
        } else if (index >= len) {
            tableViewer.getTable().setSelection(index - 1);
        }
    }

    private void showErrorMessage(Composite composite, String message) {
        MessageDialog.openError((Shell)composite.getShell(), (String)Messages.ImplementationPage_Error, (String)message);
    }

    private boolean isMethodDeleteDisable(PatternMethod deleteItem) {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            EList orchestration = pattern.getOrchestration();
            for (Call call : orchestration) {
                PatternMethod currentCalled;
                if (!(call instanceof MethodCall) || !deleteItem.equals(currentCalled = ((MethodCall)call).getCalled())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableDeleteDisable(PatternVariable deleteItem) {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            EList orchestration = pattern.getOrchestration();
            for (Call call : orchestration) {
                PatternVariable currentVariable;
                if (!(call instanceof PatternInjectedCall) || !deleteItem.equals(currentVariable = ((PatternInjectedCall)call).getContext())) continue;
                return true;
            }
        }
        return false;
    }

    private void addAdapterForNewItem(TableViewer tableViewer, Object newItem) {
        RefresherAdapter refresher = new RefresherAdapter(tableViewer);
        PatternUIHelper.addAdapter(newItem, refresher);
    }

    @Override
    protected void bind() {
        this.addBinding(null);
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            this.bindMethodsTable(pattern);
            this.bindOrchestrationTable(pattern);
            this.bindVariablesTableViewer(pattern);
        }
    }

    void bindMethodsTable(Pattern pattern) {
        if (this.nameEditor != null) {
            List<String> useablePatternMethods = PatternUIHelper.getUseablePatternMethodsNameList(this.getPatternParent());
            this.nameEditor.setInput(useablePatternMethods);
        }
        if (this.methodsTableViewer != null) {
            this.methodsTableViewer.setInput(null);
            this.methodsTableViewer.setLabelProvider((IBaseLabelProvider)new MethodLabelProvider(PatternUIHelper.getPatternParentMethodsNameList(this.getPattern())));
            IEMFListProperty input = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__METHODS);
            IObservableList observe = input.observe((Object)pattern);
            this.methodsTableViewer.setInput((Object)observe);
        }
    }

    void bindOrchestrationTable(Pattern pattern) {
        if (this.orchestrationTableViewer != null) {
            IEMFListProperty modelProperty = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__ORCHESTRATION);
            IObservableList observe = modelProperty.observe((Object)pattern);
            this.orchestrationTableViewer.setInput((Object)observe);
        }
    }

    void bindVariablesTableViewer(Pattern pattern) {
        if (this.variablesTableViewer != null) {
            IEMFListProperty input = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__VARIABLES);
            IObservableList observe = input.observe((Object)pattern);
            this.variablesTableViewer.setInput((Object)observe);
        }
    }

    public Button getEditButton() {
        return this.methodsEdit;
    }

    private Pattern getPatternParent() {
        Pattern pattern = this.getPattern();
        return pattern == null ? null : pattern.getSuperPattern();
    }

    public void dispose() {
        PatternUIHelper.removeAdapterForPattern(this.getPattern(), (AdapterImpl)this.liveValidationContentAdapter);
        super.dispose();
    }
}

