/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal.resource;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.StatusHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IResourceFcoreDelta;
import org.eclipse.egf.core.fcore.IResourceFcoreListener;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.internal.resource.ResourceFcoreDelta;
import org.eclipse.egf.core.pde.l10n.EGFPDEMessages;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommand;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommandRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreResourceListener
implements IResourceChangeListener {
    public int _overridenEventType = -1;
    private List<IResourceFcoreListener> _listeners;

    public FcoreResourceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    private void fireResourceFcore(IResourceFcoreDelta delta) {
        if (this._listeners != null) {
            for (IResourceFcoreListener listener : this._listeners) {
                listener.fcoreChanged(delta);
            }
        }
    }

    public void addResourceFcoreListener(IResourceFcoreListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<IResourceFcoreListener>();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeResourceFcoreListener(IResourceFcoreListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        int eventType = this._overridenEventType == -1 ? event.getType() : this._overridenEventType;
        try {
            switch (eventType) {
                case 1: {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class ResourceDeltaVisitor
                    implements IResourceDeltaVisitor {
                        protected ResourceFcoreDelta deltaFcores = new ResourceFcoreDelta();
                        protected Collection<IResource> addedFcores = new ArrayList<IResource>();
                        protected Collection<IPlatformFcore> removedFcores = new ArrayList<IPlatformFcore>();

                        ResourceDeltaVisitor() {
                        }

                        public boolean visit(IResourceDelta innerDelta) throws CoreException {
                            block17: {
                                if (innerDelta.getFlags() == 131072) {
                                    return true;
                                }
                                IResource resource = innerDelta.getResource();
                                if (resource.getType() == 4) {
                                    if (innerDelta.getKind() == 1 || innerDelta.getKind() == 2) {
                                        return false;
                                    }
                                    return innerDelta.getKind() != 4 || (innerDelta.getFlags() & 0x4000) == 0;
                                }
                                if (resource.getType() != 1) {
                                    return true;
                                }
                                if ((innerDelta.getKind() == 2 || innerDelta.getKind() == 4 || innerDelta.getKind() == 1) && "fcore".equals(resource.getFileExtension())) {
                                    try {
                                        URI uri = URIHelper.getPlatformURI((IResource)resource);
                                        if (uri == null) break block17;
                                        if (innerDelta.getKind() == 2) {
                                            IPlatformFcore[] iPlatformFcoreArray = EGFCorePlugin.getWorkspacePlatformFcores();
                                            int n = iPlatformFcoreArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IPlatformFcore fc = iPlatformFcoreArray[n2];
                                                if (fc.getURI().equals((Object)uri)) {
                                                    this.removedFcores.add(fc);
                                                    break block17;
                                                }
                                                ++n2;
                                            }
                                            break block17;
                                        }
                                        if (innerDelta.getKind() == 1) {
                                            boolean found = false;
                                            IPlatformFcore[] iPlatformFcoreArray = EGFCorePlugin.getWorkspacePlatformFcores();
                                            int n = iPlatformFcoreArray.length;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                IPlatformFcore fc = iPlatformFcoreArray[n3];
                                                if (fc.getURI().equals((Object)uri)) {
                                                    found = true;
                                                    break;
                                                }
                                                ++n3;
                                            }
                                            if (!found) {
                                                URI fromURI;
                                                this.addedFcores.add(resource);
                                                if ((innerDelta.getFlags() & 0x1000) != 0 && (fromURI = URIHelper.getPlatformURI((IPath)innerDelta.getMovedFromPath())) != null) {
                                                    this.deltaFcores.storeMovedResourceFcore(uri, fromURI);
                                                }
                                            }
                                        } else if (innerDelta.getKind() == 4 && (innerDelta.getFlags() & 0x100) != 0) {
                                            this.deltaFcores.storeChangedResourceFcore(uri);
                                        }
                                    }
                                    catch (Throwable t) {
                                        EGFPDEPlugin.getDefault().logError(new String("FcoreResourceListener.resourceChanged(..) _ "), t);
                                    }
                                }
                            }
                            return true;
                        }

                        public Collection<IPlatformFcore> getRemovedFcores() {
                            return this.removedFcores;
                        }

                        public Collection<IResource> getAddedFcores() {
                            return this.addedFcores;
                        }

                        public ResourceFcoreDelta getFcoresDelta() {
                            return this.deltaFcores;
                        }
                    }
                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)visitor);
                    if (!visitor.getRemovedFcores().isEmpty() || !visitor.getAddedFcores().isEmpty()) {
                        final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
                        final IRunnableWithProgress op = this.createFcoreOperation(errorStatus, visitor.getRemovedFcores(), visitor.getAddedFcores());
                        WorkspaceJob job = new WorkspaceJob("update"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                try {
                                    op.run(monitor);
                                }
                                catch (InvocationTargetException e) {
                                    String msg = NLS.bind((String)EGFPDEMessages.PluginModelUpdate_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)e.getTargetException());
                                    throw new CoreException(StatusHelper.newStatus((int)4, (String)msg, (Throwable)e.getTargetException()));
                                }
                                catch (InterruptedException interruptedException) {
                                    return Status.CANCEL_STATUS;
                                }
                                return errorStatus[0];
                            }
                        };
                        job.setUser(true);
                        job.schedule();
                    }
                    if (visitor.getFcoresDelta().isEmpty()) return;
                    if (EGFPDEPlugin.getDefault().isDebugging()) {
                        this.trace(visitor.getFcoresDelta());
                    }
                    this.fireResourceFcore(visitor.getFcoresDelta());
                }
                default: {
                    return;
                }
            }
        }
        catch (CoreException ce) {
            EGFPDEPlugin.getDefault().logError(new String("FcoreResourceListener.resourceChanged(..) _"), ce);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this._listeners = null;
    }

    protected final IRunnableWithProgress createFcoreOperation(final IStatus[] errorStatus, final Collection<IPlatformFcore> removedFcores, final Collection<IResource> addedFcores) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", (removedFcores.size() + addedFcores.size()) * 1000);
                monitor.setTaskName(EGFPDEMessages.PluginModelUpdate_progressMessage);
                try {
                    IPluginChangesCommandRunner runner;
                    for (IPlatformFcore fcore : removedFcores) {
                        IPluginChangesCommand unsetCommand = EGFPDEPlugin.getFcoreExtensionHelper().unsetFcoreExtension(fcore.getURI());
                        runner = EGFPDEPlugin.getPluginChangesCommandRunner();
                        runner.performChangesOnPlugin(fcore.getPlatformBundle().getBundleId(), Collections.singletonList(unsetCommand));
                        monitor.worked(1000);
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                    for (IResource resource : addedFcores) {
                        IPluginChangesCommand createCommand = EGFPDEPlugin.getFcoreExtensionHelper().setFcoreExtension(URI.createURI((String)resource.getFullPath().removeFirstSegments(1).makeRelative().toString()));
                        runner = EGFPDEPlugin.getPluginChangesCommandRunner();
                        String bundleId = BundleHelper.getBundleId((IResource)resource);
                        if (bundleId != null) {
                            runner.performChangesOnPlugin(bundleId, Collections.singletonList(createCommand));
                        }
                        monitor.worked(1000);
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                    errorStatus[0] = Status.OK_STATUS;
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private void trace(IResourceFcoreDelta delta) {
        if (delta.getChangedResourceFcores().length > 0) {
            EGFPDEPlugin.getDefault().logInfo(NLS.bind((String)"FcoreResourceListener Changed {0} Fcore{1}.", (Object)delta.getChangedResourceFcores().length, (Object)(delta.getChangedResourceFcores().length < 2 ? "" : "s")));
            this.trace(delta.getChangedResourceFcores(), null);
        }
        if (delta.getMovedResourceFcores().length > 0) {
            EGFPDEPlugin.getDefault().logInfo(NLS.bind((String)"FcoreResourceListener Moved {0} Fcore{1}.", (Object)delta.getMovedResourceFcores().length, (Object)(delta.getMovedResourceFcores().length < 2 ? "" : "s")));
            this.trace(delta.getMovedResourceFcores(), delta);
        }
    }

    private void trace(URI[] uris, IResourceFcoreDelta delta) {
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            EGFPDEPlugin.getDefault().logWarning(uri.toString(), 1);
            if (delta != null) {
                EGFPDEPlugin.getDefault().logInfo("From: " + delta.getMovedFromResourceFcore(uri), 2);
            }
            ++n2;
        }
    }
}

