/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.producer.context.IActivityProductionContext;
import org.eclipse.egf.producer.context.IInvocationProductionContext;
import org.eclipse.egf.producer.internal.context.ModelElementProductionContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityProductionContext
extends ModelElementProductionContext<ActivityContract>
implements IActivityProductionContext {
    public ActivityProductionContext(Activity element, ProjectBundleSession projectBundleSession) {
        super((ModelElement)element, projectBundleSession);
    }

    public ActivityProductionContext(IInvocationProductionContext parent, Activity element, ProjectBundleSession projectBundleSession) {
        super(parent, (ModelElement)element, projectBundleSession);
    }

    @Override
    public Activity getElement() {
        return (Activity)super.getElement();
    }

    @Override
    public IInvocationProductionContext getParent() {
        return (IInvocationProductionContext)super.getParent();
    }

    public Class<?> getInputValueType(Object key) throws InvocationException {
        ActivityContract activityContract = this.getActivityContract(key, this.getInputValueKeys());
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return super.getInputValueType((Object)activityContract);
    }

    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        ActivityContract activityContract = this.getActivityContract(key, this.getInputValueKeys());
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return (R)super.getInputValue((Object)activityContract, clazz);
    }

    public Class<?> getOutputValueType(Object key) throws InvocationException {
        ActivityContract activityContract = this.getActivityContract(key, this.getOutputValueKeys());
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return super.getOutputValueType((Object)activityContract);
    }

    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        ActivityContract activityContract = this.getActivityContract(key, this.getOutputValueKeys());
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        return (R)super.getOutputValue((Object)activityContract, clazz);
    }

    public void setOutputValue(Object key, Object value) throws InvocationException {
        ActivityContract activityContract = this.getActivityContract(key, this.getOutputValueKeys());
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)((String)key).trim(), (Object)this.getName()));
        }
        super.setOutputValue((Object)activityContract, value);
    }

    private ActivityContract getActivityContract(Object key, Collection<ActivityContract> keys) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_name, (Object)this.getName()));
        }
        if (!(key instanceof String)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{String.class.getName(), EMFHelper.getText((Object)key), key.getClass().getName(), this.getName()}));
        }
        String innerName = ((String)key).trim();
        if (innerName.length() == 0) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_emtpy_name, (Object)this.getName()));
        }
        ActivityContract activityContract = null;
        for (ActivityContract innerActivityContract : keys) {
            if (!innerName.equals(innerActivityContract.getName())) continue;
            activityContract = innerActivityContract;
            break;
        }
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_name, (Object)innerName, (Object)this.getName()));
        }
        return activityContract;
    }
}

