/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PatternMethodEditorInput
implements IFileEditorInput {
    public static final String PATTERN_METHOD_ID = "methodId";
    public static final String RESSOURCE_URI = "uri";
    private final PatternPersistableElement persistable = new PatternPersistableElement();
    private final String fragment;
    private final Resource resource;

    public PatternMethodEditorInput(Resource resource, String fragment) {
        this.resource = resource;
        this.fragment = fragment;
    }

    public boolean exists() {
        return true;
    }

    public PatternMethod getPatternMethod() {
        return (PatternMethod)this.resource.getEObject(this.fragment);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.getPatternMethod().getName();
    }

    public IPersistableElement getPersistable() {
        return this.persistable;
    }

    public String getToolTipText() {
        return Messages.input_tooltip;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IFile getFile() {
        IPlatformFcore platformFcore = EGFCorePlugin.getPlatformFcore((Resource)this.getResource());
        IProject project = platformFcore.getPlatformBundle().getProject();
        IFile file = project.getFile(this.getPatternMethod().getPatternFilePath().path());
        if (!file.exists()) {
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e);
            }
        }
        return file;
    }

    public IStorage getStorage() throws CoreException {
        return this.getFile();
    }

    private class PatternPersistableElement
    implements IPersistableElement {
        private PatternPersistableElement() {
        }

        public void saveState(IMemento memento) {
            memento.putString(PatternMethodEditorInput.PATTERN_METHOD_ID, PatternMethodEditorInput.this.getPatternMethod().getID());
            memento.putString(PatternMethodEditorInput.RESSOURCE_URI, PatternMethodEditorInput.this.resource.getURI().toString());
        }

        public String getFactoryId() {
            return "org.eclipse.egf.pattern.ui.pattern.factory.id";
        }
    }
}

