/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.strategy.modeldriven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.egf.model.pattern.DomainVisitor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.utils.NsURIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultDomainVisitor
implements DomainVisitor {
    private final Map<String, List<Pattern>> type2patterns = new HashMap<String, List<Pattern>>(100);
    private final Set<Object> visited = new HashSet<Object>();

    public void setPatterns(List<Pattern> patterns) throws PatternException {
        for (Pattern p : patterns) {
            EList parameters = p.getAllParameters();
            if (parameters.size() != 1) {
                throw new PatternException(Messages.bind((String)Messages.strategy_error4, (Object)p.getName()));
            }
            this.registerPattern(p, (PatternParameter)parameters.get(0));
        }
    }

    private void registerPattern(Pattern p, PatternParameter patternParameter) {
        String type = patternParameter.getType();
        List<Pattern> patterns = this.type2patterns.get(type);
        if (patterns == null) {
            patterns = new ArrayList<Pattern>();
            this.type2patterns.put(type, patterns);
        }
        patterns.add(p);
    }

    protected List<Pattern> findPatterns(Object model) {
        List<Pattern> result = null;
        if (!(model instanceof EObject)) {
            throw new UnsupportedOperationException();
        }
        String fullName = NsURIHelper.getFullName((EObject)model);
        result = this.type2patterns.get(fullName);
        return result;
    }

    public void visit(PatternContext context, Object model) throws PatternException {
        for (Object obj : this.getChildren(model)) {
            if (!this.visited.contains(obj)) {
                this.doProcess(context, obj);
            }
            this.visit(context, obj);
        }
    }

    protected void doProcess(PatternContext context, Object model) throws PatternException {
        this.visited.add(model);
        List<Pattern> foundPattern = this.findPatterns(model);
        if (foundPattern == null || foundPattern.isEmpty()) {
            return;
        }
        this.executeWithInjection(foundPattern, context, model);
    }

    protected void executeWithInjection(Collection<Pattern> patterns, PatternContext context, Object model) throws PatternException {
        for (Pattern pattern : patterns) {
            try {
                HashMap<PatternParameter, Object> parameters = new HashMap<PatternParameter, Object>();
                parameters.put((PatternParameter)pattern.getAllParameters().get(0), model);
                PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
                String canExecute = extension.canExecute(pattern);
                if (canExecute != null) {
                    throw new PatternException(canExecute);
                }
                extension.createEngine(pattern).executeWithInjection(context, parameters);
            }
            catch (ExtensionHelper.MissingExtensionException e) {
                throw new PatternException((Throwable)e);
            }
        }
    }

    public void dispose() {
        this.visited.clear();
        for (String key : this.type2patterns.keySet()) {
            this.type2patterns.get(key).clear();
        }
        this.type2patterns.clear();
    }
}

