/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package comrel.provider;

import comrel.util.ComrelAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ComrelItemProviderAdapterFactory extends ComrelAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComrelItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.CompositeRefactoring} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeRefactoringItemProvider compositeRefactoringItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.CompositeRefactoring}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositeRefactoringAdapter() {
		if (compositeRefactoringItemProvider == null) {
			compositeRefactoringItemProvider = new CompositeRefactoringItemProvider(this);
		}

		return compositeRefactoringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.ModelRefactoring} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelRefactoringItemProvider modelRefactoringItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.ModelRefactoring}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelRefactoringAdapter() {
		if (modelRefactoringItemProvider == null) {
			modelRefactoringItemProvider = new ModelRefactoringItemProvider(this);
		}

		return modelRefactoringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.AtomicUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AtomicUnitItemProvider atomicUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.AtomicUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAtomicUnitAdapter() {
		if (atomicUnitItemProvider == null) {
			atomicUnitItemProvider = new AtomicUnitItemProvider(this);
		}

		return atomicUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SequentialUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequentialUnitItemProvider sequentialUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SequentialUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequentialUnitAdapter() {
		if (sequentialUnitItemProvider == null) {
			sequentialUnitItemProvider = new SequentialUnitItemProvider(this);
		}

		return sequentialUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.ConditionCheck} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionCheckItemProvider conditionCheckItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.ConditionCheck}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionCheckAdapter() {
		if (conditionCheckItemProvider == null) {
			conditionCheckItemProvider = new ConditionCheckItemProvider(this);
		}

		return conditionCheckItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.ConditionalUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalUnitItemProvider conditionalUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.ConditionalUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalUnitAdapter() {
		if (conditionalUnitItemProvider == null) {
			conditionalUnitItemProvider = new ConditionalUnitItemProvider(this);
		}

		return conditionalUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleQueuedUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleQueuedUnitItemProvider singleQueuedUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleQueuedUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleQueuedUnitAdapter() {
		if (singleQueuedUnitItemProvider == null) {
			singleQueuedUnitItemProvider = new SingleQueuedUnitItemProvider(this);
		}

		return singleQueuedUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.CartesianQueuedUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CartesianQueuedUnitItemProvider cartesianQueuedUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.CartesianQueuedUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCartesianQueuedUnitAdapter() {
		if (cartesianQueuedUnitItemProvider == null) {
			cartesianQueuedUnitItemProvider = new CartesianQueuedUnitItemProvider(this);
		}

		return cartesianQueuedUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.ParallelQueuedUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParallelQueuedUnitItemProvider parallelQueuedUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.ParallelQueuedUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParallelQueuedUnitAdapter() {
		if (parallelQueuedUnitItemProvider == null) {
			parallelQueuedUnitItemProvider = new ParallelQueuedUnitItemProvider(this);
		}

		return parallelQueuedUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleFeatureUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleFeatureUnitItemProvider singleFeatureUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleFeatureUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleFeatureUnitAdapter() {
		if (singleFeatureUnitItemProvider == null) {
			singleFeatureUnitItemProvider = new SingleFeatureUnitItemProvider(this);
		}

		return singleFeatureUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiFeatureUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiFeatureUnitItemProvider multiFeatureUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiFeatureUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiFeatureUnitAdapter() {
		if (multiFeatureUnitItemProvider == null) {
			multiFeatureUnitItemProvider = new MultiFeatureUnitItemProvider(this);
		}

		return multiFeatureUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleFilterUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleFilterUnitItemProvider singleFilterUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleFilterUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleFilterUnitAdapter() {
		if (singleFilterUnitItemProvider == null) {
			singleFilterUnitItemProvider = new SingleFilterUnitItemProvider(this);
		}

		return singleFilterUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiFilterUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiFilterUnitItemProvider multiFilterUnitItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiFilterUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiFilterUnitAdapter() {
		if (multiFilterUnitItemProvider == null) {
			multiFilterUnitItemProvider = new MultiFilterUnitItemProvider(this);
		}

		return multiFilterUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleFeatureHelper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleFeatureHelperItemProvider singleFeatureHelperItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleFeatureHelper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleFeatureHelperAdapter() {
		if (singleFeatureHelperItemProvider == null) {
			singleFeatureHelperItemProvider = new SingleFeatureHelperItemProvider(this);
		}

		return singleFeatureHelperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiFeatureHelper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiFeatureHelperItemProvider multiFeatureHelperItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiFeatureHelper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiFeatureHelperAdapter() {
		if (multiFeatureHelperItemProvider == null) {
			multiFeatureHelperItemProvider = new MultiFeatureHelperItemProvider(this);
		}

		return multiFeatureHelperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleFilterHelper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleFilterHelperItemProvider singleFilterHelperItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleFilterHelper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleFilterHelperAdapter() {
		if (singleFilterHelperItemProvider == null) {
			singleFilterHelperItemProvider = new SingleFilterHelperItemProvider(this);
		}

		return singleFilterHelperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiFilterHelper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiFilterHelperItemProvider multiFilterHelperItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiFilterHelper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiFilterHelperAdapter() {
		if (multiFilterHelperItemProvider == null) {
			multiFilterHelperItemProvider = new MultiFilterHelperItemProvider(this);
		}

		return multiFilterHelperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleInputPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleInputPortItemProvider singleInputPortItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleInputPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleInputPortAdapter() {
		if (singleInputPortItemProvider == null) {
			singleInputPortItemProvider = new SingleInputPortItemProvider(this);
		}

		return singleInputPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiInputPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiInputPortItemProvider multiInputPortItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiInputPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiInputPortAdapter() {
		if (multiInputPortItemProvider == null) {
			multiInputPortItemProvider = new MultiInputPortItemProvider(this);
		}

		return multiInputPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SingleOutputPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleOutputPortItemProvider singleOutputPortItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SingleOutputPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleOutputPortAdapter() {
		if (singleOutputPortItemProvider == null) {
			singleOutputPortItemProvider = new SingleOutputPortItemProvider(this);
		}

		return singleOutputPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiOutputPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiOutputPortItemProvider multiOutputPortItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiOutputPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiOutputPortAdapter() {
		if (multiOutputPortItemProvider == null) {
			multiOutputPortItemProvider = new MultiOutputPortItemProvider(this);
		}

		return multiOutputPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.SinglePortMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SinglePortMappingItemProvider singlePortMappingItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.SinglePortMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSinglePortMappingAdapter() {
		if (singlePortMappingItemProvider == null) {
			singlePortMappingItemProvider = new SinglePortMappingItemProvider(this);
		}

		return singlePortMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiPortMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiPortMappingItemProvider multiPortMappingItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiPortMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiPortMappingAdapter() {
		if (multiPortMappingItemProvider == null) {
			multiPortMappingItemProvider = new MultiPortMappingItemProvider(this);
		}

		return multiPortMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link comrel.MultiSinglePortMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiSinglePortMappingItemProvider multiSinglePortMappingItemProvider;

	/**
	 * This creates an adapter for a {@link comrel.MultiSinglePortMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiSinglePortMappingAdapter() {
		if (multiSinglePortMappingItemProvider == null) {
			multiSinglePortMappingItemProvider = new MultiSinglePortMappingItemProvider(this);
		}

		return multiSinglePortMappingItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (compositeRefactoringItemProvider != null) compositeRefactoringItemProvider.dispose();
		if (modelRefactoringItemProvider != null) modelRefactoringItemProvider.dispose();
		if (atomicUnitItemProvider != null) atomicUnitItemProvider.dispose();
		if (sequentialUnitItemProvider != null) sequentialUnitItemProvider.dispose();
		if (conditionCheckItemProvider != null) conditionCheckItemProvider.dispose();
		if (conditionalUnitItemProvider != null) conditionalUnitItemProvider.dispose();
		if (singleQueuedUnitItemProvider != null) singleQueuedUnitItemProvider.dispose();
		if (cartesianQueuedUnitItemProvider != null) cartesianQueuedUnitItemProvider.dispose();
		if (parallelQueuedUnitItemProvider != null) parallelQueuedUnitItemProvider.dispose();
		if (singleFeatureUnitItemProvider != null) singleFeatureUnitItemProvider.dispose();
		if (multiFeatureUnitItemProvider != null) multiFeatureUnitItemProvider.dispose();
		if (singleFilterUnitItemProvider != null) singleFilterUnitItemProvider.dispose();
		if (multiFilterUnitItemProvider != null) multiFilterUnitItemProvider.dispose();
		if (singleFeatureHelperItemProvider != null) singleFeatureHelperItemProvider.dispose();
		if (multiFeatureHelperItemProvider != null) multiFeatureHelperItemProvider.dispose();
		if (singleFilterHelperItemProvider != null) singleFilterHelperItemProvider.dispose();
		if (multiFilterHelperItemProvider != null) multiFilterHelperItemProvider.dispose();
		if (singleInputPortItemProvider != null) singleInputPortItemProvider.dispose();
		if (multiInputPortItemProvider != null) multiInputPortItemProvider.dispose();
		if (singleOutputPortItemProvider != null) singleOutputPortItemProvider.dispose();
		if (multiOutputPortItemProvider != null) multiOutputPortItemProvider.dispose();
		if (singlePortMappingItemProvider != null) singlePortMappingItemProvider.dispose();
		if (multiPortMappingItemProvider != null) multiPortMappingItemProvider.dispose();
		if (multiSinglePortMappingItemProvider != null) multiSinglePortMappingItemProvider.dispose();
	}

}
