/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.conversion;

import com.github.javabdd.BDD;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.BddToCif;
import org.eclipse.escet.cif.bdd.conversion.CifToBddConverter;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.RemoveRequirements;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisResult;
import org.eclipse.escet.cif.datasynth.settings.BddOutputMode;
import org.eclipse.escet.cif.datasynth.settings.BddSimplify;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SynthesisToCifConverter {
    private CifBddSpec cifBddSpec;
    private Specification spec;
    private Automaton supervisor;
    private BddOutputMode outputMode;
    private String bddNamePrefix;
    private Map<BDD, Integer> bddNodeMap;
    private Map<Integer, Integer> bddVarIdxMap;
    private ListType bddNodesType;
    private Constant bddNodesConst;
    private AlgVariable bddValuesVar;
    private InternalFunction bddEvalFunc;

    public Specification convert(CifDataSynthesisResult synthResult, Specification spec) {
        this.cifBddSpec = synthResult.cifBddSpec;
        this.spec = spec;
        this.supervisor = null;
        this.outputMode = synthResult.settings.getBddOutputMode();
        this.bddNamePrefix = synthResult.settings.getBddOutputNamePrefix();
        this.bddNodeMap = null;
        this.bddVarIdxMap = null;
        this.bddNodesConst = null;
        this.bddValuesVar = null;
        this.bddEvalFunc = null;
        for (Event event : this.cifBddSpec.inputVarEvents) {
            EMFHelper.removeFromParentContainment((EObject)event);
            this.cifBddSpec.alphabet.remove(event);
        }
        SynthesisToCifConverter.relabelRequirementAutomata((ComplexComponent)spec);
        try {
            EnumSet<BddSimplify> simplifications = synthResult.settings.getBddSimplifications();
            RemoveRequirements remover = new RemoveRequirements();
            remover.removeReqAuts = true;
            remover.removeStateEvtExclReqInvs = !simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_REQ_INVS);
            remover.removeStateReqInvs = !simplifications.contains((Object)BddSimplify.GUARDS_STATE_REQ_INVS);
            remover.transform(spec);
        }
        catch (CifToCifPreconditionException ex) {
            throw new RuntimeException("Unexpected error.", ex);
        }
        SynthesisToCifConverter.relabelRequirementInvariants((ComplexComponent)spec);
        this.supervisor = this.createSupervisorAutomaton(synthResult.settings.getSupervisorName());
        Alphabet alphabet = CifConstructors.newAlphabet();
        for (Event event : this.cifBddSpec.alphabet) {
            if (!event.getControllable().booleanValue()) continue;
            EventExpression eventRef = CifConstructors.newEventExpression((Event)event, null, (CifType)CifConstructors.newBoolType());
            alphabet.getEvents().add((Object)eventRef);
        }
        this.supervisor.setAlphabet(alphabet);
        Location cifLoc = CifConstructors.newLocation();
        cifLoc.getInitials().add((Object)CifValueUtils.makeTrue());
        cifLoc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        this.supervisor.getLocations().add((Object)cifLoc);
        Set controllables = Sets.setc((int)alphabet.getEvents().size());
        for (Event event : this.cifBddSpec.alphabet) {
            if (!event.getControllable().booleanValue()) continue;
            controllables.add(event);
        }
        this.prepareBddToCif();
        List edges = Lists.listc((int)controllables.size());
        for (Map.Entry<Event, BDD> entry : synthResult.outputGuards.entrySet()) {
            Event event = entry.getKey();
            BDD guard = entry.getValue();
            Expression cifGuard = this.convertPred(guard);
            edges.add(SynthesisToCifConverter.createSelfLoop(event, Lists.list((Object)cifGuard)));
        }
        Collections.sort(edges, new EdgeSorter());
        cifLoc.getEdges().addAll((Collection)edges);
        if (synthResult.initialOutput != null) {
            Expression initialPred = this.convertPred(synthResult.initialOutput);
            this.supervisor.getInitials().add((Object)initialPred);
        }
        this.finalizeBddToCif();
        if (synthResult.settings.getSupervisorNamespace() != null) {
            this.spec = spec = this.addNamespace(synthResult.settings.getSupervisorNamespace());
        }
        CifControllerPropertiesAnnotationUtils.remove((Specification)spec);
        return spec;
    }

    private void prepareBddToCif() {
        switch (this.outputMode) {
            case NORMAL: 
            case CNF: 
            case DNF: {
                return;
            }
            case NODES: {
                Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)this.spec, null);
                for (String name : names) {
                    if (!name.startsWith(this.bddNamePrefix)) continue;
                    String msg = Strings.fmt((String)"Can't create BDD output using BDD output name prefix \"%s\", as a declaration named \"%s\" already exists in the specification. Configure a different name prefix.", (Object[])new Object[]{this.bddNamePrefix, name});
                    throw new InvalidOptionException(msg);
                }
                this.bddNodeMap = Maps.map();
                IntType nodeType0 = CifConstructors.newIntType();
                IntType nodeType1 = CifConstructors.newIntType();
                IntType nodeType2 = CifConstructors.newIntType();
                Field nodeField0 = CifConstructors.newField((String)"var", null, (CifType)nodeType0);
                Field nodeField1 = CifConstructors.newField((String)"low", null, (CifType)nodeType1);
                Field nodeField2 = CifConstructors.newField((String)"high", null, (CifType)nodeType2);
                List nodeFields = Lists.list((Object[])new Field[]{nodeField0, nodeField1, nodeField2});
                TupleType nodeType = CifConstructors.newTupleType((List)nodeFields, null);
                TypeDecl nodeTypeDecl = CifConstructors.newTypeDecl();
                nodeTypeDecl.setName(this.bddNamePrefix + "_node_type");
                nodeTypeDecl.setType((CifType)nodeType);
                this.spec.getDeclarations().add((Object)nodeTypeDecl);
                this.bddNodesType = CifConstructors.newListType();
                this.bddNodesType.setElementType((CifType)CifConstructors.newTypeRef(null, (TypeDecl)nodeTypeDecl));
                TypeDecl nodesTypeDecl = CifConstructors.newTypeDecl();
                nodesTypeDecl.setName(this.bddNamePrefix + "_nodes_type");
                nodesTypeDecl.setType((CifType)this.bddNodesType);
                this.spec.getDeclarations().add((Object)nodesTypeDecl);
                ListExpression nodesListExpr = CifConstructors.newListExpression();
                nodesListExpr.setType((CifType)EMFHelper.deepclone((EObject)this.bddNodesType));
                this.bddNodesConst = CifConstructors.newConstant();
                this.bddNodesConst.setName(this.bddNamePrefix + "_nodes");
                this.bddNodesConst.setValue((Expression)nodesListExpr);
                this.bddNodesConst.setType((CifType)CifConstructors.newTypeRef(null, (TypeDecl)nodesTypeDecl));
                this.spec.getDeclarations().add((Object)this.bddNodesConst);
                CifBddVariable[] sortedVars = (CifBddVariable[])this.cifBddSpec.variables.clone();
                Arrays.sort(sortedVars, (v, w) -> Strings.SORTER.compare(v.rawName, w.rawName));
                Assert.areEqual((Object)this.cifBddSpec.settings.getBddExtraVarDomainNames().size(), (Object)0);
                int bddVarCnt = this.cifBddSpec.factory.varNum();
                Assert.check((bddVarCnt % 2 == 0 ? 1 : 0) != 0);
                this.bddVarIdxMap = Maps.mapc((int)(bddVarCnt / 2));
                List valueVars = Lists.listc((int)this.cifBddSpec.factory.varNum());
                int cifVarIdx = 0;
                CifBddVariable[] cifBddVariableArray = sortedVars;
                int n = sortedVars.length;
                int n2 = 0;
                while (n2 < n) {
                    CifBddVariable cifBddVar = cifBddVariableArray[n2];
                    int[] varIdxs = cifBddVar.domain.vars();
                    int i = 0;
                    while (i < varIdxs.length) {
                        AlgVariable var = CifConstructors.newAlgVariable();
                        int bddVarIdx = varIdxs[i];
                        Assert.check((bddVarIdx % 2 == 0 ? 1 : 0) != 0);
                        var.setName(this.bddNamePrefix + "_value" + Strings.str((Object)cifVarIdx));
                        var.setType((CifType)CifConstructors.newBoolType());
                        var.setValue(BddToCif.getBddVarPred((CifBddVariable)cifBddVar, (int)i));
                        this.spec.getDeclarations().add((Object)var);
                        valueVars.add(var);
                        this.bddVarIdxMap.put(bddVarIdx, cifVarIdx);
                        ++cifVarIdx;
                        ++i;
                    }
                    ++n2;
                }
                ListType valuesType = CifConstructors.newListType();
                valuesType.setLower(Integer.valueOf(bddVarCnt /= 2));
                valuesType.setUpper(Integer.valueOf(bddVarCnt));
                valuesType.setElementType((CifType)CifConstructors.newBoolType());
                ListExpression valuesExpr = CifConstructors.newListExpression();
                valuesExpr.setType((CifType)valuesType);
                for (AlgVariable valueVar : valueVars) {
                    AlgVariableExpression valueVarRef = CifConstructors.newAlgVariableExpression();
                    valueVarRef.setVariable(valueVar);
                    valueVarRef.setType((CifType)CifConstructors.newBoolType());
                    valuesExpr.getElements().add((Object)valueVarRef);
                }
                this.bddValuesVar = CifConstructors.newAlgVariable();
                this.bddValuesVar.setName(this.bddNamePrefix + "_values");
                this.bddValuesVar.setType((CifType)EMFHelper.deepclone((EObject)valuesType));
                this.bddValuesVar.setValue((Expression)valuesExpr);
                this.spec.getDeclarations().add((Object)this.bddValuesVar);
                this.bddEvalFunc = CifConstructors.newInternalFunction();
                this.bddEvalFunc.setName(this.bddNamePrefix + "_eval");
                this.spec.getDeclarations().add((Object)this.bddEvalFunc);
                this.bddEvalFunc.getReturnTypes().add((Object)CifConstructors.newBoolType());
                DiscVariable pvar1 = CifConstructors.newDiscVariable();
                DiscVariable pvar2 = CifConstructors.newDiscVariable();
                pvar1.setName("idx");
                pvar2.setName("values");
                pvar1.setType((CifType)CifConstructors.newIntType());
                pvar2.setType((CifType)EMFHelper.deepclone((EObject)valuesType));
                FunctionParameter param1 = CifConstructors.newFunctionParameter((DiscVariable)pvar1, null);
                FunctionParameter param2 = CifConstructors.newFunctionParameter((DiscVariable)pvar2, null);
                this.bddEvalFunc.getParameters().add((Object)param1);
                this.bddEvalFunc.getParameters().add((Object)param2);
                DiscVariable varNode = CifConstructors.newDiscVariable();
                DiscVariable varVal = CifConstructors.newDiscVariable();
                varNode.setName("node");
                varVal.setName("val");
                varNode.setType((CifType)CifConstructors.newTypeRef(null, (TypeDecl)nodeTypeDecl));
                varVal.setType((CifType)CifConstructors.newBoolType());
                this.bddEvalFunc.getVariables().add((Object)varNode);
                this.bddEvalFunc.getVariables().add((Object)varVal);
                DiscVariableExpression idxRef = CifConstructors.newDiscVariableExpression();
                idxRef.setVariable(pvar1);
                idxRef.setType((CifType)EMFHelper.deepclone((EObject)pvar1.getType()));
                BinaryExpression whileCond = CifConstructors.newBinaryExpression();
                whileCond.setOperator(BinaryOperator.GREATER_EQUAL);
                whileCond.setLeft((Expression)idxRef);
                whileCond.setRight(CifValueUtils.makeInt((int)0));
                whileCond.setType((CifType)CifConstructors.newBoolType());
                WhileFuncStatement whileStat = CifConstructors.newWhileFuncStatement();
                this.bddEvalFunc.getStatements().add((Object)whileStat);
                whileStat.getGuards().add((Object)whileCond);
                DiscVariableExpression nodeRef = CifConstructors.newDiscVariableExpression();
                nodeRef.setVariable(varNode);
                nodeRef.setType((CifType)EMFHelper.deepclone((EObject)varNode.getType()));
                ConstantExpression nodesRef = CifConstructors.newConstantExpression();
                nodesRef.setConstant(this.bddNodesConst);
                nodesRef.setType((CifType)EMFHelper.deepclone((EObject)this.bddNodesConst.getType()));
                ProjectionExpression nodeIdxProj = CifConstructors.newProjectionExpression();
                nodeIdxProj.setChild((Expression)nodesRef);
                nodeIdxProj.setIndex((Expression)EMFHelper.deepclone((EObject)idxRef));
                nodeIdxProj.setType((CifType)CifConstructors.newTypeRef(null, (TypeDecl)nodeTypeDecl));
                AssignmentFuncStatement asgn1 = CifConstructors.newAssignmentFuncStatement();
                asgn1.setAddressable((Expression)nodeRef);
                asgn1.setValue((Expression)nodeIdxProj);
                whileStat.getStatements().add((Object)asgn1);
                DiscVariableExpression valRef = CifConstructors.newDiscVariableExpression();
                valRef.setVariable(varVal);
                valRef.setType((CifType)EMFHelper.deepclone((EObject)varVal.getType()));
                FieldExpression varFieldRef = CifConstructors.newFieldExpression();
                varFieldRef.setField(nodeField0);
                varFieldRef.setType((CifType)CifConstructors.newIntType((Integer)0, null, (Integer)0));
                ProjectionExpression nodeVarProj = CifConstructors.newProjectionExpression();
                nodeVarProj.setChild((Expression)EMFHelper.deepclone((EObject)nodeRef));
                nodeVarProj.setIndex((Expression)varFieldRef);
                nodeVarProj.setType((CifType)EMFHelper.deepclone((EObject)nodeType0));
                DiscVariableExpression valuesRef = CifConstructors.newDiscVariableExpression();
                valuesRef.setVariable(pvar2);
                valuesRef.setType((CifType)EMFHelper.deepclone((EObject)pvar2.getType()));
                ProjectionExpression valuesNodeVarProj = CifConstructors.newProjectionExpression();
                valuesNodeVarProj.setChild((Expression)valuesRef);
                valuesNodeVarProj.setIndex((Expression)nodeVarProj);
                valuesNodeVarProj.setType((CifType)CifConstructors.newBoolType());
                AssignmentFuncStatement asgn2 = CifConstructors.newAssignmentFuncStatement();
                asgn2.setAddressable((Expression)valRef);
                asgn2.setValue((Expression)valuesNodeVarProj);
                whileStat.getStatements().add((Object)asgn2);
                FieldExpression lowFieldRef = CifConstructors.newFieldExpression();
                lowFieldRef.setField(nodeField1);
                lowFieldRef.setType((CifType)CifConstructors.newIntType((Integer)1, null, (Integer)1));
                ProjectionExpression nodeLowProj = CifConstructors.newProjectionExpression();
                nodeLowProj.setChild((Expression)EMFHelper.deepclone((EObject)nodeRef));
                nodeLowProj.setIndex((Expression)lowFieldRef);
                nodeLowProj.setType((CifType)EMFHelper.deepclone((EObject)nodeType1));
                FieldExpression highFieldRef = CifConstructors.newFieldExpression();
                highFieldRef.setField(nodeField2);
                highFieldRef.setType((CifType)CifConstructors.newIntType((Integer)2, null, (Integer)2));
                ProjectionExpression nodeHighProj = CifConstructors.newProjectionExpression();
                nodeHighProj.setChild((Expression)EMFHelper.deepclone((EObject)nodeRef));
                nodeHighProj.setIndex((Expression)highFieldRef);
                nodeHighProj.setType((CifType)EMFHelper.deepclone((EObject)nodeType2));
                IfExpression ifExpr = CifConstructors.newIfExpression();
                ifExpr.getGuards().add((Object)((Expression)EMFHelper.deepclone((EObject)valRef)));
                ifExpr.setThen((Expression)nodeHighProj);
                ifExpr.setElse((Expression)nodeLowProj);
                ifExpr.setType((CifType)CifConstructors.newIntType());
                AssignmentFuncStatement asgn3 = CifConstructors.newAssignmentFuncStatement();
                asgn3.setAddressable((Expression)EMFHelper.deepclone((EObject)idxRef));
                asgn3.setValue((Expression)ifExpr);
                whileStat.getStatements().add((Object)asgn3);
                BinaryExpression returnValue = CifConstructors.newBinaryExpression();
                returnValue.setOperator(BinaryOperator.EQUAL);
                returnValue.setLeft((Expression)EMFHelper.deepclone((EObject)idxRef));
                returnValue.setRight(CifValueUtils.makeInt((int)-1));
                returnValue.setType((CifType)CifConstructors.newBoolType());
                ReturnFuncStatement returnStat = CifConstructors.newReturnFuncStatement();
                this.bddEvalFunc.getStatements().add((Object)returnStat);
                returnStat.getValues().add((Object)returnValue);
                return;
            }
        }
        throw new RuntimeException("Unknown output mode: " + String.valueOf((Object)this.outputMode));
    }

    private void finalizeBddToCif() {
        switch (this.outputMode) {
            case NORMAL: 
            case CNF: 
            case DNF: {
                return;
            }
            case NODES: {
                this.bddNodesType.setLower(Integer.valueOf(this.bddNodeMap.size()));
                this.bddNodesType.setUpper(Integer.valueOf(this.bddNodeMap.size()));
                return;
            }
        }
        throw new RuntimeException("Unknown output mode: " + String.valueOf((Object)this.outputMode));
    }

    private Expression convertPred(BDD bdd) {
        switch (this.outputMode) {
            case NORMAL: {
                return BddToCif.bddToCifPred((BDD)bdd, (CifBddSpec)this.cifBddSpec);
            }
            case CNF: {
                return BddToCif.bddToCifPred((BDD)bdd, (CifBddSpec)this.cifBddSpec, (boolean)false);
            }
            case DNF: {
                return BddToCif.bddToCifPred((BDD)bdd, (CifBddSpec)this.cifBddSpec, (boolean)true);
            }
            case NODES: {
                int idx = this.bddToNodeMap(bdd);
                if (idx == -1) {
                    return CifValueUtils.makeTrue();
                }
                if (idx == -2) {
                    return CifValueUtils.makeFalse();
                }
                Assert.check((idx >= 0 ? 1 : 0) != 0);
                FunctionExpression funcRef = CifConstructors.newFunctionExpression();
                funcRef.setFunction((Function)this.bddEvalFunc);
                funcRef.setType((CifType)CifTypeUtils.makeFunctionType((Function)this.bddEvalFunc, null));
                Expression arg0 = CifValueUtils.makeInt((int)idx);
                AlgVariableExpression arg1 = CifConstructors.newAlgVariableExpression();
                arg1.setVariable(this.bddValuesVar);
                arg1.setType((CifType)EMFHelper.deepclone((EObject)this.bddValuesVar.getType()));
                FunctionCallExpression callExpr = CifConstructors.newFunctionCallExpression();
                callExpr.setFunction((Expression)funcRef);
                callExpr.getArguments().add((Object)arg0);
                callExpr.getArguments().add((Object)arg1);
                callExpr.setType((CifType)CifConstructors.newBoolType());
                return callExpr;
            }
        }
        throw new RuntimeException("Unknown output mode: " + String.valueOf((Object)this.outputMode));
    }

    private int bddToNodeMap(BDD bdd) {
        if (bdd.isOne()) {
            return -1;
        }
        if (bdd.isZero()) {
            return -2;
        }
        Integer idx = this.bddNodeMap.get(bdd);
        if (idx != null) {
            return idx;
        }
        idx = this.bddNodeMap.size();
        this.bddNodeMap.put(bdd, idx);
        ListExpression nodesExpr = (ListExpression)this.bddNodesConst.getValue();
        TupleExpression tupleExpr = CifConstructors.newTupleExpression();
        nodesExpr.getElements().add((Object)tupleExpr);
        int lowIdx = this.bddToNodeMap(bdd.low());
        int highIdx = this.bddToNodeMap(bdd.high());
        int bddVarIdx = bdd.var();
        Assert.check((bddVarIdx % 2 == 0 ? 1 : 0) != 0);
        Integer cifVarIdx = this.bddVarIdxMap.get(bddVarIdx);
        Assert.notNull((Object)cifVarIdx);
        tupleExpr.getFields().add((Object)CifValueUtils.makeInt((int)cifVarIdx));
        tupleExpr.getFields().add((Object)CifValueUtils.makeInt((int)lowIdx));
        tupleExpr.getFields().add((Object)CifValueUtils.makeInt((int)highIdx));
        CifType fieldType0 = ((Expression)tupleExpr.getFields().get(0)).getType();
        CifType fieldType1 = ((Expression)tupleExpr.getFields().get(1)).getType();
        CifType fieldType2 = ((Expression)tupleExpr.getFields().get(2)).getType();
        List fieldTypes = Lists.list((Object[])new CifType[]{fieldType0, fieldType1, fieldType2});
        CifType tupleType = CifTypeUtils.makeTupleType((List)fieldTypes, null);
        tupleExpr.setType(tupleType);
        return idx;
    }

    private static void relabelRequirementAutomata(ComplexComponent component) {
        if (component instanceof Automaton) {
            Automaton aut = (Automaton)component;
            if (aut.getKind() == SupKind.REQUIREMENT) {
                aut.setKind(SupKind.SUPERVISOR);
            }
            return;
        }
        Group group = (Group)component;
        for (Component child : group.getComponents()) {
            SynthesisToCifConverter.relabelRequirementAutomata((ComplexComponent)child);
        }
    }

    private static void relabelRequirementInvariants(ComplexComponent component) {
        if (component instanceof Automaton) {
            Automaton aut = (Automaton)component;
            SynthesisToCifConverter.relabelRequirementInvariants((List<Invariant>)aut.getInvariants());
            for (Location loc : aut.getLocations()) {
                SynthesisToCifConverter.relabelRequirementInvariants((List<Invariant>)loc.getInvariants());
            }
            return;
        }
        Group group = (Group)component;
        SynthesisToCifConverter.relabelRequirementInvariants((List<Invariant>)group.getInvariants());
        for (Component child : group.getComponents()) {
            SynthesisToCifConverter.relabelRequirementInvariants((ComplexComponent)child);
        }
    }

    private static void relabelRequirementInvariants(List<Invariant> invs) {
        for (Invariant inv : invs) {
            if (inv.getSupKind() != SupKind.REQUIREMENT) continue;
            inv.setSupKind(SupKind.SUPERVISOR);
        }
    }

    private Automaton createSupervisorAutomaton(String supName) {
        Automaton aut = CifConstructors.newAutomaton();
        aut.setKind(SupKind.SUPERVISOR);
        String name = supName;
        Set curNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)this.spec, null);
        if (curNames.contains(supName)) {
            name = CifScopeUtils.getUniqueName((String)name, (Set)curNames, Collections.emptySet());
            this.cifBddSpec.settings.getWarnOutput().line("Supervisor automaton is named \"%s\" instead of \"%s\" to avoid a naming conflict.", new Object[]{name, supName});
        }
        aut.setName(name);
        this.spec.getComponents().add((Object)aut);
        return aut;
    }

    private static Edge createSelfLoop(Event event, List<Expression> guards) {
        EventExpression eventRef = CifConstructors.newEventExpression();
        eventRef.setEvent(event);
        eventRef.setType((CifType)CifConstructors.newBoolType());
        EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
        edgeEvent.setEvent((Expression)eventRef);
        Edge edge = CifConstructors.newEdge();
        edge.getGuards().addAll(guards);
        edge.getEvents().add((Object)edgeEvent);
        return edge;
    }

    private Specification addNamespace(String namespace) {
        Group namespaceGroup;
        Specification newSpec = CifConstructors.newSpecification();
        newSpec.getAnnotations().addAll((Collection)this.spec.getAnnotations());
        List events = Lists.list();
        CifToBddConverter.collectEvents((ComplexComponent)this.spec, (List)events);
        for (Event event : events) {
            SynthesisToCifConverter.addEvent(newSpec, event);
        }
        String[] namespaceParts = namespace.split("\\.");
        try {
            namespaceGroup = SynthesisToCifConverter.getGroup(newSpec, namespaceParts, 0);
        }
        catch (DuplicateNameException ex) {
            PositionObject obj = CifScopeUtils.getObject((PositionObject)ex.group, (String)ex.name);
            Assert.check((boolean)(obj instanceof Event));
            String msg = Strings.fmt((String)"Can't create supervisor namespace \"%s\": an event named \"%s\" already exists in %s.", (Object[])new Object[]{namespace, ex.name, CifTextUtils.getComponentText2((ComplexComponent)ex.group)});
            throw new InvalidOptionException(msg);
        }
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)namespaceGroup, null);
        if (!names.isEmpty()) {
            List sortedNames = Sets.sortedstrings((Set)names);
            int i = 0;
            while (i < sortedNames.size()) {
                sortedNames.set(i, Strings.fmt((String)"\"%s\"", (Object[])new Object[]{sortedNames.get(i)}));
                ++i;
            }
            String msg1 = Strings.fmt((String)"Can't put supervisor in namespace \"%s\".", (Object[])new Object[]{namespace});
            String msg2 = Strings.fmt((String)"The namespace is not empty, as it contains the following declarations: %s.", (Object[])new Object[]{String.join((CharSequence)", ", sortedNames)});
            InvalidOptionException ex = new InvalidOptionException(msg2);
            throw new InvalidOptionException(msg1, (Throwable)ex);
        }
        namespaceGroup.getComponents().addAll((Collection)this.spec.getComponents());
        namespaceGroup.getDefinitions().addAll((Collection)this.spec.getDefinitions());
        namespaceGroup.getDeclarations().addAll((Collection)this.spec.getDeclarations());
        namespaceGroup.getInitials().addAll((Collection)this.spec.getInitials());
        namespaceGroup.getInvariants().addAll((Collection)this.spec.getInvariants());
        namespaceGroup.getMarkeds().addAll((Collection)this.spec.getMarkeds());
        namespaceGroup.getEquations().addAll((Collection)this.spec.getEquations());
        namespaceGroup.getIoDecls().addAll((Collection)this.spec.getIoDecls());
        return newSpec;
    }

    private static void addEvent(Specification spec, Event event) {
        Group group;
        String[] names = CifTextUtils.getAbsName((PositionObject)event, (boolean)false).split("\\.");
        try {
            group = SynthesisToCifConverter.getGroup(spec, names, 1);
        }
        catch (DuplicateNameException ex) {
            throw new RuntimeException("Can't occur.", ex);
        }
        group.getDeclarations().add((Object)event);
    }

    private static Group getGroup(Specification spec, String[] names, int cnt) throws DuplicateNameException {
        Specification current = spec;
        int i = 0;
        while (i < names.length - cnt) {
            block3: {
                String name = names[i];
                for (Component comp : current.getComponents()) {
                    if (!comp.getName().equals(name)) continue;
                    current = (Group)comp;
                    break block3;
                }
                Set curNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)current, null);
                if (curNames.contains(name)) {
                    throw new DuplicateNameException((Group)current, name);
                }
                Group group = CifConstructors.newGroup();
                group.setName(name);
                current.getComponents().add((Object)group);
                current = group;
            }
            ++i;
        }
        return current;
    }

    private static class DuplicateNameException
    extends Exception {
        public final Group group;
        public final String name;

        public DuplicateNameException(Group group, String name) {
            this.group = group;
            this.name = name;
        }
    }

    private static class EdgeSorter
    implements Comparator<Edge> {
        private EdgeSorter() {
        }

        @Override
        public int compare(Edge edge1, Edge edge2) {
            Expression eventRef1 = ((EdgeEvent)Lists.first((List)edge1.getEvents())).getEvent();
            Expression eventRef2 = ((EdgeEvent)Lists.first((List)edge2.getEvents())).getEvent();
            Event event1 = ((EventExpression)eventRef1).getEvent();
            Event event2 = ((EventExpression)eventRef2).getEvent();
            String name1 = CifTextUtils.getAbsName((PositionObject)event1, (boolean)false);
            String name2 = CifTextUtils.getAbsName((PositionObject)event2, (boolean)false);
            return Strings.SORTER.compare(name1, name2);
        }
    }
}

