/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.JFactory;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.CifBddLocationPointerManager;
import org.eclipse.escet.cif.bdd.conversion.PlantsRefsReqsChecker;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.CifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.CifBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.TwosComplementCifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.TwosComplementCifBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedCifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedCifBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.preconditions.CifToBddConverterPreChecker;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.settings.EdgeGranularity;
import org.eclipse.escet.cif.bdd.settings.EdgeOrderDuplicateEventAllowance;
import org.eclipse.escet.cif.bdd.settings.ExplorationStrategy;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddInputVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddTypedVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrder;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrderHelper;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.cif.bdd.varorder.parser.VarOrdererParser;
import org.eclipse.escet.cif.bdd.varorder.parser.VarOrdererTypeChecker;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifExecSchemeUtils;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class CifToBddConverter {
    private final String appName;
    private Map<Automaton, Monitors> originalMonitors;

    public CifToBddConverter(String appName) {
        this.appName = appName;
    }

    public void preprocess(Specification spec, String specAbsPath, WarnOutput warnOutput, boolean doPlantsRefReqsWarn, Termination termination) {
        CifToBddConverterPreChecker checker = CifToBddConverter.preparePreChecker(spec, warnOutput, doPlantsRefReqsWarn, termination);
        checker.reportPreconditionViolations(spec, specAbsPath, this.appName);
    }

    public static CifToBddConverterPreChecker preparePreChecker(Specification spec, WarnOutput warnOutput, boolean doPlantsRefReqsWarn, Termination termination) {
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        removeIoDecls.warnAboutIgnoredSvgInputDecsIfRemoved(warnOutput);
        new ElimComponentDefInst().transform(spec);
        if (doPlantsRefReqsWarn) {
            new PlantsRefsReqsChecker(warnOutput).checkPlantRefToRequirement(spec);
        }
        return new CifToBddConverterPreChecker(termination);
    }

    public static BDDFactory createFactory(CifBddSettings settings, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes) {
        double bddOpCacheRatio = settings.getBddOpCacheRatio();
        Integer bddOpCacheSize = settings.getBddOpCacheSize();
        if (bddOpCacheSize == null) {
            bddOpCacheSize = (int)((double)settings.getBddInitNodeTableSize() * bddOpCacheRatio);
            if (bddOpCacheSize < 2) {
                bddOpCacheSize = 2;
            }
        } else {
            bddOpCacheRatio = -1.0;
        }
        BDDFactory factory = JFactory.init((int)settings.getBddInitNodeTableSize(), (int)bddOpCacheSize);
        if (bddOpCacheRatio != -1.0) {
            factory.setCacheRatio(bddOpCacheRatio);
        }
        boolean doGcStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_GC_COLLECT);
        boolean doResizeStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_GC_RESIZE);
        boolean doContinuousPerformanceStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CONT);
        BddUtils.registerBddCallbacks(factory, doGcStats, doResizeStats, doContinuousPerformanceStats, settings.getNormalOutput(), continuousOpMisses, continuousUsedBddNodes);
        boolean doCacheStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CACHE);
        boolean doMaxBddNodesStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_MAX_NODES);
        boolean doMaxMemoryStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.MAX_MEMORY);
        if (doCacheStats || doContinuousPerformanceStats) {
            factory.getCacheStats().enableMeasurements();
        }
        if (doMaxBddNodesStats) {
            factory.getMaxUsedBddNodesStats().enableMeasurements();
        }
        if (doMaxMemoryStats) {
            factory.getMaxMemoryStats().enableMeasurements();
        }
        return factory;
    }

    public CifBddSpec convert(Specification spec, CifBddSettings settings, BDDFactory factory) {
        CifEventUtils.Alphabets alphabets;
        CifBddSpec cifBddSpec = new CifBddSpec(settings);
        cifBddSpec.factory = factory;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        List events = Lists.list();
        CifToBddConverter.collectEvents((ComplexComponent)spec, events);
        if (cifBddSpec.settings.getAdhereToExecScheme()) {
            CifExecSchemeUtils.orderEvents((List)events);
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        List automata = Lists.list();
        CifToBddConverter.collectAutomata((ComplexComponent)spec, automata);
        if (cifBddSpec.settings.getAdhereToExecScheme()) {
            CifExecSchemeUtils.orderAutomata((List)automata);
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        List<Automaton> plants = automata.stream().filter(a -> a.getKind() == SupKind.PLANT).toList();
        List<Automaton> requirements = automata.stream().filter(a -> a.getKind() == SupKind.REQUIREMENT).toList();
        Assert.areEqual((Object)automata.size(), (Object)(plants.size() + requirements.size()));
        automata = null;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        List plantAlphabets = Lists.listc((int)plants.size());
        List reqAlphabets = Lists.listc((int)requirements.size());
        Set plantAlphabet = Sets.set();
        Set reqAlphabet = Sets.set();
        for (Automaton plant : plants) {
            alphabets = CifEventUtils.getAllAlphabets((Automaton)plant, null);
            plantAlphabets.add(alphabets);
            plantAlphabet.addAll(alphabets.syncAlphabet);
            plantAlphabet.addAll(alphabets.sendAlphabet);
            plantAlphabet.addAll(alphabets.recvAlphabet);
        }
        for (Automaton req : requirements) {
            alphabets = CifEventUtils.getAllAlphabets((Automaton)req, null);
            reqAlphabets.add(alphabets);
            reqAlphabet.addAll(alphabets.syncAlphabet);
            reqAlphabet.addAll(alphabets.sendAlphabet);
            reqAlphabet.addAll(alphabets.recvAlphabet);
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.alphabet = Sets.union((Set)plantAlphabet, (Set)reqAlphabet);
        if (cifBddSpec.settings.getAdhereToExecScheme()) {
            List orderedAlphabet = Lists.set2list(cifBddSpec.alphabet);
            CifExecSchemeUtils.orderEvents((List)orderedAlphabet);
            cifBddSpec.alphabet = Sets.list2set((List)orderedAlphabet);
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.controllables = (Set)cifBddSpec.alphabet.stream().filter(Event::getControllable).collect(Sets.toSet());
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        List cifVarObjs = Lists.list();
        CifToBddConverter.collectVariableObjects((ComplexComponent)spec, cifVarObjs);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        List lpAuts = Lists.filter((List)cifVarObjs, Automaton.class);
        CifBddLocationPointerManager locPtrManager = new CifBddLocationPointerManager(lpAuts);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.variables = new CifBddVariable[cifVarObjs.size()];
        int i = 0;
        while (i < cifBddSpec.variables.length) {
            PositionObject positionObject = (PositionObject)cifVarObjs.get(i);
            if (positionObject instanceof Automaton) {
                Automaton lpAut = (Automaton)positionObject;
                DiscVariable lpVar = locPtrManager.getLocationPointer(lpAut);
                cifBddSpec.variables[i] = this.createLpVar(lpAut, lpVar);
            } else {
                cifBddSpec.variables[i] = this.convertTypedVar((Declaration)positionObject);
            }
            ++i;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.orderVars(cifBddSpec, spec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.createVarDomains(cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.createUpdateAuxiliaries(cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.initialsVars = Lists.listc((int)cifBddSpec.variables.length);
        i = 0;
        while (i < cifBddSpec.variables.length) {
            cifBddSpec.initialsVars.add(null);
            ++i;
        }
        cifBddSpec.initialsComps = Lists.list();
        cifBddSpec.initialsLocs = Lists.list();
        cifBddSpec.initialVars = cifBddSpec.factory.one();
        cifBddSpec.initialComps = cifBddSpec.factory.one();
        cifBddSpec.initialLocs = cifBddSpec.factory.one();
        this.convertInit((ComplexComponent)spec, cifBddSpec, locPtrManager);
        BDD initialCompsAndLocs = cifBddSpec.initialComps.and(cifBddSpec.initialLocs);
        cifBddSpec.initial = cifBddSpec.initialVars.and(initialCompsAndLocs);
        initialCompsAndLocs.free();
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.markedsComps = Lists.list();
        cifBddSpec.markedsLocs = Lists.list();
        cifBddSpec.markedComps = cifBddSpec.factory.one();
        cifBddSpec.markedLocs = cifBddSpec.factory.one();
        this.convertMarked((ComplexComponent)spec, cifBddSpec, locPtrManager);
        cifBddSpec.marked = cifBddSpec.markedComps.and(cifBddSpec.markedLocs);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.plantInvsComps = Lists.list();
        cifBddSpec.plantInvsLocs = Lists.list();
        cifBddSpec.plantInvComps = cifBddSpec.factory.one();
        cifBddSpec.plantInvLocs = cifBddSpec.factory.one();
        cifBddSpec.reqInvsComps = Lists.list();
        cifBddSpec.reqInvsLocs = Lists.list();
        cifBddSpec.reqInvComps = cifBddSpec.factory.one();
        cifBddSpec.reqInvLocs = cifBddSpec.factory.one();
        this.convertStateInvs((ComplexComponent)spec, cifBddSpec, locPtrManager);
        cifBddSpec.plantInv = cifBddSpec.plantInvComps.and(cifBddSpec.plantInvLocs);
        cifBddSpec.reqInv = cifBddSpec.reqInvComps.and(cifBddSpec.reqInvLocs);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.initialPlantInv = cifBddSpec.initial.and(cifBddSpec.plantInv);
        cifBddSpec.initialInv = cifBddSpec.initialPlantInv.and(cifBddSpec.reqInv);
        cifBddSpec.markedPlantInv = cifBddSpec.marked.and(cifBddSpec.plantInv);
        cifBddSpec.markedInv = cifBddSpec.markedPlantInv.and(cifBddSpec.reqInv);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        cifBddSpec.stateEvtExclPlants = Maps.mapc((int)cifBddSpec.alphabet.size());
        cifBddSpec.stateEvtExclPlantLists = Maps.mapc((int)cifBddSpec.alphabet.size());
        for (Event event : cifBddSpec.alphabet) {
            cifBddSpec.stateEvtExclPlants.put(event, cifBddSpec.factory.one());
            cifBddSpec.stateEvtExclPlantLists.put(event, Lists.list());
        }
        cifBddSpec.stateEvtExclsReqAuts = Maps.mapc((int)cifBddSpec.controllables.size());
        cifBddSpec.stateEvtExclsReqInvs = Maps.mapc((int)cifBddSpec.controllables.size());
        for (Event event : cifBddSpec.controllables) {
            cifBddSpec.stateEvtExclsReqAuts.put(event, cifBddSpec.factory.one());
            cifBddSpec.stateEvtExclsReqInvs.put(event, cifBddSpec.factory.one());
        }
        cifBddSpec.stateEvtExclReqs = Maps.mapc((int)cifBddSpec.alphabet.size());
        cifBddSpec.stateEvtExclReqLists = Maps.mapc((int)cifBddSpec.alphabet.size());
        for (Event event : cifBddSpec.alphabet) {
            cifBddSpec.stateEvtExclReqs.put(event, cifBddSpec.factory.one());
            cifBddSpec.stateEvtExclReqLists.put(event, Lists.list());
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.convertStateEvtExclInvs((ComplexComponent)spec, cifBddSpec, locPtrManager);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.preconvertReqAuts(requirements, reqAlphabets, cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.convertPlantReqAuts(plants, requirements, plantAlphabets, reqAlphabets, locPtrManager, cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        for (Map.Entry entry : this.originalMonitors.entrySet()) {
            ((Automaton)entry.getKey()).setMonitors((Monitors)entry.getValue());
        }
        this.originalMonitors = null;
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.addInputVariableEdges(cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.mergeEdges(cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.orderEdges(cifBddSpec);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.checkEdgeWorksetAlgorithmSettings(cifBddSpec.settings);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        this.checkSaturationSettings(cifBddSpec.settings);
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return cifBddSpec;
        }
        return cifBddSpec;
    }

    private CifBddVariable convertTypedVar(Declaration var) {
        int upper;
        int lower;
        int count;
        CifType type;
        if (var instanceof DiscVariable) {
            type = ((DiscVariable)var).getType();
        } else if (var instanceof InputVariable) {
            type = ((InputVariable)var).getType();
        } else {
            throw new RuntimeException("Unexpected variable: " + String.valueOf(var));
        }
        type = CifTypeUtils.normalizeType((CifType)type);
        if (type instanceof BoolType) {
            count = 2;
            lower = 0;
            upper = 1;
        } else if (type instanceof IntType) {
            IntType intType = (IntType)type;
            Assert.check((!CifTypeUtils.isRangeless((IntType)intType) ? 1 : 0) != 0);
            lower = intType.getLower();
            upper = intType.getUpper();
            Assert.check((lower >= 0 ? 1 : 0) != 0);
            count = upper - lower + 1;
        } else if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            count = enumDecl.getLiterals().size();
            lower = 0;
            upper = count - 1;
        } else {
            throw new RuntimeException("Unexpected type: " + String.valueOf(type));
        }
        if (var instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)var;
            return new CifBddDiscVariable(discVar, type, count, lower, upper);
        }
        if (var instanceof InputVariable) {
            InputVariable inputVar = (InputVariable)var;
            return new CifBddInputVariable(inputVar, type, count, lower, upper);
        }
        throw new RuntimeException("Unexpected variable: " + String.valueOf(var));
    }

    private CifBddVariable createLpVar(Automaton aut, DiscVariable var) {
        int count = aut.getLocations().size();
        Assert.check((count > 1 ? 1 : 0) != 0);
        return new CifBddLocPtrVariable(aut, var);
    }

    private void orderVars(CifBddSpec cifBddSpec, Specification spec) {
        List parseResult;
        String varOrderTxt = cifBddSpec.settings.getBddVarOrderAdvanced();
        try {
            parseResult = (List)new VarOrdererParser().parseString(varOrderTxt, "/in-memory.varorder", null, DebugMode.NONE);
        }
        catch (SyntaxException ex) {
            throw new InvalidOptionException("Invalid BDD variable ordering configuration.", (Throwable)ex);
        }
        VarOrdererTypeChecker typeChecker = new VarOrdererTypeChecker(Arrays.asList(cifBddSpec.variables), cifBddSpec.settings);
        VarOrderer varOrderer = (VarOrderer)typeChecker.typeCheck(parseResult);
        Assert.check((!typeChecker.hasWarning() ? 1 : 0) != 0);
        if (varOrderer == null) {
            Assert.check((boolean)typeChecker.hasError());
            Assert.check((typeChecker.getProblems().size() == 1 ? 1 : 0) != 0);
            InvalidOptionException ex = new InvalidOptionException(((SemanticProblem)typeChecker.getProblems().get(0)).toString());
            throw new InvalidOptionException("Invalid BDD variable ordering configuration.", (Throwable)ex);
        }
        int varCnt = cifBddSpec.variables.length;
        if (varCnt == 0) {
            cifBddSpec.settings.getDebugOutput().line("The specification has no BDD variables.");
            return;
        }
        int i = 0;
        while (i < cifBddSpec.variables.length) {
            cifBddSpec.variables[i].group = i;
            ++i;
        }
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        if (dbgEnabled) {
            CifToBddConverter.debugCifVars(cifBddSpec);
        }
        if (cifBddSpec.variables.length < 2) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Skipping variable ordering: only one variable present.");
            }
            return;
        }
        List<CifBddVariable> varsInModelOrder = Collections.unmodifiableList(Arrays.asList(cifBddSpec.variables));
        VarOrderHelper helper = new VarOrderHelper(spec, varsInModelOrder, cifBddSpec.settings.getDebugOutput(), cifBddSpec.settings.getIndentAmount());
        VarOrder curOrder = VarOrder.createFromOrderedVars(varsInModelOrder);
        List<CifBddVariable> varsInCurOrder = curOrder.getOrderedVars();
        VarOrdererData data = new VarOrdererData(varsInModelOrder, curOrder, helper);
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Applying variable ordering:");
        }
        VarOrdererData orderingResult = varOrderer.order(data, dbgEnabled, 1);
        VarOrder newOrder = orderingResult.varOrder;
        List<CifBddVariable> varsInNewOrder = newOrder.getOrderedVars();
        Assert.check((boolean)curOrder.getVarOrder().stream().allMatch(grp -> !grp.isEmpty()));
        Assert.check((boolean)newOrder.getVarOrder().stream().allMatch(grp -> !grp.isEmpty()));
        Assert.areEqual((Object)varsInCurOrder.size(), (Object)Sets.list2set(varsInCurOrder).size());
        Assert.areEqual((Object)varsInNewOrder.size(), (Object)Sets.list2set(varsInNewOrder).size());
        Assert.areEqual((Object)varsInCurOrder.size(), (Object)varsInNewOrder.size());
        Assert.areEqual((Object)Sets.list2set(varsInCurOrder), (Object)Sets.list2set(varsInNewOrder));
        cifBddSpec.variables = (CifBddVariable[])varsInNewOrder.toArray(CifBddVariable[]::new);
        int i2 = 0;
        while (i2 < newOrder.getVarOrder().size()) {
            List<CifBddVariable> group = newOrder.getVarOrder().get(i2);
            for (CifBddVariable var : group) {
                var.group = i2;
            }
            ++i2;
        }
        if (dbgEnabled) {
            boolean orderChanged = !curOrder.equals(newOrder);
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Variable order %schanged.", new Object[]{orderChanged ? "" : "un"});
            if (orderChanged) {
                cifBddSpec.settings.getDebugOutput().line();
                CifToBddConverter.debugCifVars(cifBddSpec);
            }
        }
    }

    private static void debugCifVars(CifBddSpec cifBddSpec) {
        int cifVarCnt = cifBddSpec.variables.length;
        int nrOfExtraDomains = cifBddSpec.settings.getBddExtraVarDomainNames().size();
        int nrOfDomainsPerVar = 2 + nrOfExtraDomains;
        String nrOfDomainsPerVarTxt = Strings.fmt((String)"%,d", (Object[])new Object[]{nrOfDomainsPerVar});
        GridBox grid = new GridBox(cifVarCnt + 4, 10, 0, 2);
        grid.set(0, 0, "Nr");
        grid.set(0, 1, "Kind");
        grid.set(0, 2, "Type");
        grid.set(0, 3, "Name");
        grid.set(0, 4, "Group");
        grid.set(0, 5, "BDD vars");
        grid.set(0, 6, "CIF values");
        grid.set(0, 7, "BDD values");
        grid.set(0, 8, "Values used");
        grid.set(0, 9, "BDD var indices");
        Set groups = Sets.set();
        int totalBddVarCnt = 0;
        BigInteger totalUsedCnt = BigInteger.ZERO;
        BigInteger totalReprCnt = BigInteger.ZERO;
        int i = 0;
        while (i < cifVarCnt) {
            CifBddVariable var = cifBddSpec.variables[i];
            String typeTxt = var.getTypeText();
            if (typeTxt == null) {
                typeTxt = "n/a";
            }
            int bddCnt = var.getBddVarCount();
            int usedCnt = var.count;
            BigInteger reprCnt = var.getBddDomainSize();
            int currentBddVarCnt = bddCnt * nrOfDomainsPerVar;
            int previousBddVarCnt = totalBddVarCnt;
            totalBddVarCnt += currentBddVarCnt;
            grid.set(i + 2, 0, Strings.fmt((String)"%,d", (Object[])new Object[]{i + 1}));
            grid.set(i + 2, 1, var.getKindText());
            grid.set(i + 2, 2, typeTxt);
            grid.set(i + 2, 3, var.name);
            grid.set(i + 2, 4, Strings.fmt((String)"%,d", (Object[])new Object[]{var.group}));
            grid.set(i + 2, 5, Strings.fmt((String)"%,d", (Object[])new Object[]{bddCnt}) + " * " + nrOfDomainsPerVarTxt);
            grid.set(i + 2, 6, Strings.fmt((String)"%,d", (Object[])new Object[]{usedCnt}) + " * " + nrOfDomainsPerVarTxt);
            grid.set(i + 2, 7, Strings.fmt((String)"%,d", (Object[])new Object[]{reprCnt}) + " * " + nrOfDomainsPerVarTxt);
            grid.set(i + 2, 8, CifToBddConverter.getPercentageText(BigInteger.valueOf(usedCnt), reprCnt));
            grid.set(i + 2, 9, Strings.fmt((String)"%,d", (Object[])new Object[]{previousBddVarCnt}) + ".." + Strings.fmt((String)"%,d", (Object[])new Object[]{totalBddVarCnt - 1}));
            groups.add(var.group);
            totalUsedCnt = totalUsedCnt.add(BigInteger.valueOf(usedCnt).multiply(BigInteger.valueOf(nrOfDomainsPerVar)));
            totalReprCnt = totalReprCnt.add(reprCnt.multiply(BigInteger.valueOf(nrOfDomainsPerVar)));
            Assert.check((totalBddVarCnt >= 0 ? 1 : 0) != 0, (Object)totalBddVarCnt);
            ++i;
        }
        grid.set(cifVarCnt + 3, 0, "Total");
        grid.set(cifVarCnt + 3, 1, "");
        grid.set(cifVarCnt + 3, 2, "");
        grid.set(cifVarCnt + 3, 3, "");
        grid.set(cifVarCnt + 3, 4, Strings.fmt((String)"%,d", (Object[])new Object[]{groups.size()}));
        grid.set(cifVarCnt + 3, 5, Strings.fmt((String)"%,d", (Object[])new Object[]{totalBddVarCnt}));
        grid.set(cifVarCnt + 3, 6, Strings.fmt((String)"%,d", (Object[])new Object[]{totalUsedCnt}));
        grid.set(cifVarCnt + 3, 7, Strings.fmt((String)"%,d", (Object[])new Object[]{totalReprCnt}));
        grid.set(cifVarCnt + 3, 8, CifToBddConverter.getPercentageText(totalUsedCnt, totalReprCnt));
        grid.set(cifVarCnt + 3, 9, "0.." + (totalBddVarCnt - 1));
        GridBox.GridBoxLayout layout = grid.computeLayout();
        int i2 = 0;
        while (i2 < layout.numCols) {
            String bar = Strings.duplicate((String)"-", (int)layout.widths[i2]);
            grid.set(1, i2, bar);
            grid.set(cifVarCnt + 2, i2, bar);
            ++i2;
        }
        cifBddSpec.settings.getDebugOutput().line("CIF variables and location pointers:");
        cifBddSpec.settings.getDebugOutput().inc();
        for (String line : grid.getLines()) {
            cifBddSpec.settings.getDebugOutput().line(line);
        }
        cifBddSpec.settings.getDebugOutput().dec();
    }

    private static String getPercentageText(BigInteger part, BigInteger total) {
        if (total.compareTo(BigInteger.ZERO) == 0) {
            return "n/a";
        }
        BigDecimal left = BigDecimal.valueOf(100.0).multiply(new BigDecimal(part));
        BigInteger percentage = left.divide(new BigDecimal(total), 0, RoundingMode.HALF_UP).toBigIntegerExact();
        BigInteger remainder = left.remainder(new BigDecimal(total)).toBigIntegerExact();
        Object txt = Strings.fmt((String)"%d%%", (Object[])new Object[]{percentage});
        if (remainder.compareTo(BigInteger.ZERO) != 0) {
            txt = "~" + (String)txt;
        }
        return txt;
    }

    private void createVarDomains(CifBddSpec cifBddSpec) {
        int varCnt = cifBddSpec.variables.length;
        if (varCnt == 0) {
            return;
        }
        int cur = 0;
        int i = 0;
        while (i < varCnt) {
            int group = cifBddSpec.variables[i].group;
            Assert.check((group >= 0 ? 1 : 0) != 0);
            if (group != cur) {
                if (group == cur + 1) {
                    cur = group;
                } else {
                    Assert.fail((Object)Strings.fmt((String)"Invalid cur/group: %d/%d.", (Object[])new Object[]{cur, group}));
                }
            }
            ++i;
        }
        CifBddVariable lastVar = cifBddSpec.variables[varCnt - 1];
        int[] counts = new int[lastVar.group + 1];
        int i2 = 0;
        while (i2 < varCnt) {
            int n = cifBddSpec.variables[i2].group;
            counts[n] = counts[n] + 1;
            ++i2;
        }
        int nrOfExtraDomains = cifBddSpec.settings.getBddExtraVarDomainNames().size();
        int nrOfDomainsPerVar = 2 + nrOfExtraDomains;
        int offset = 0;
        int grpIdx = 0;
        while (grpIdx < counts.length) {
            int grpVarCnt = counts[grpIdx];
            BigInteger[] sizes = new BigInteger[grpVarCnt * nrOfDomainsPerVar];
            int varIdx = 0;
            while (varIdx < grpVarCnt) {
                BigInteger size = cifBddSpec.variables[offset + varIdx].getBddDomainSize();
                int domainIdx = 0;
                while (domainIdx < nrOfDomainsPerVar) {
                    sizes[nrOfDomainsPerVar * varIdx + domainIdx] = size;
                    ++domainIdx;
                }
                ++varIdx;
            }
            BDDDomain[] domains = cifBddSpec.factory.extDomain(sizes);
            int varIdx2 = 0;
            while (varIdx2 < grpVarCnt) {
                CifBddVariable cifBddVar = cifBddSpec.variables[offset + varIdx2];
                cifBddVar.domain = domains[nrOfDomainsPerVar * varIdx2 + 0];
                cifBddVar.domainNew = domains[nrOfDomainsPerVar * varIdx2 + 1];
                cifBddVar.domainsExtra = new BDDDomain[nrOfExtraDomains];
                int extraDomainIdx = 0;
                while (extraDomainIdx < nrOfExtraDomains) {
                    cifBddVar.domainsExtra[extraDomainIdx] = domains[nrOfDomainsPerVar * varIdx2 + 2 + extraDomainIdx];
                    ++extraDomainIdx;
                }
                ++varIdx2;
            }
            offset += grpVarCnt;
            ++grpIdx;
        }
    }

    private void createUpdateAuxiliaries(CifBddSpec cifBddSpec) {
        int domainCnt = cifBddSpec.factory.numberOfDomains();
        int cifVarCnt = cifBddSpec.variables.length;
        int nrOfExtraDomains = cifBddSpec.settings.getBddExtraVarDomainNames().size();
        int nrOfDomainsPerVar = 2 + nrOfExtraDomains;
        Assert.areEqual((Object)(cifVarCnt * nrOfDomainsPerVar), (Object)domainCnt);
        BDDDomain[] oldDomains = new BDDDomain[cifVarCnt];
        BDDDomain[] newDomains = new BDDDomain[cifVarCnt];
        int i = 0;
        while (i < cifVarCnt) {
            oldDomains[i] = cifBddSpec.variables[i].domain;
            newDomains[i] = cifBddSpec.variables[i].domainNew;
            ++i;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        int bddVarCnt = cifBddSpec.factory.varNum();
        Assert.check((bddVarCnt % nrOfDomainsPerVar == 0 ? 1 : 0) != 0);
        int bddVarCntPerDomain = bddVarCnt / nrOfDomainsPerVar;
        int[] varIdxsOld = new int[bddVarCntPerDomain];
        int[] varIdxsNew = new int[bddVarCntPerDomain];
        int[][] varIdxsExtra = new int[nrOfExtraDomains][bddVarCntPerDomain];
        int varIdx = 0;
        int i2 = 0;
        while (i2 < cifVarCnt) {
            BDDDomain oldDomain = oldDomains[i2];
            BDDDomain newDomain = newDomains[i2];
            int[] domainVarIdxsOld = oldDomain.vars();
            int[] domainVarIdxsNew = newDomain.vars();
            System.arraycopy(domainVarIdxsOld, 0, varIdxsOld, varIdx, domainVarIdxsOld.length);
            System.arraycopy(domainVarIdxsNew, 0, varIdxsNew, varIdx, domainVarIdxsNew.length);
            BDDDomain[] extraDomains = cifBddSpec.variables[i2].domainsExtra;
            int j = 0;
            while (j < extraDomains.length) {
                BDDDomain extraDomain = extraDomains[j];
                int[] domainVarIdxsExtra = extraDomain.vars();
                System.arraycopy(domainVarIdxsExtra, 0, varIdxsExtra[j], varIdx, domainVarIdxsExtra.length);
                ++j;
            }
            varIdx += domainVarIdxsOld.length;
            ++i2;
        }
        cifBddSpec.varSetOld = cifBddSpec.factory.makeSet(varIdxsOld);
        cifBddSpec.varSetNew = cifBddSpec.factory.makeSet(varIdxsNew);
        cifBddSpec.varSetsExtra = Collections.unmodifiableList((List)Arrays.stream(varIdxsExtra).map(idxs -> cifBddSpec.factory.makeSet(idxs)).collect(Lists.toList()));
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
    }

    private void convertInit(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Expression pred : comp.getInitials()) {
            BDD initial = CifToBddConverter.convertPred(pred, true, cifBddSpec);
            cifBddSpec.initialsComps.add(initial);
            cifBddSpec.initialComps = cifBddSpec.initialComps.andWith(initial.id());
        }
        if (comp instanceof Automaton) {
            for (Declaration cifDecl : comp.getDeclarations()) {
                BDD pred;
                List values;
                if (!(cifDecl instanceof DiscVariable)) continue;
                DiscVariable cifVar = (DiscVariable)cifDecl;
                int varIdx = CifToBddConverter.getDiscVarIdx(cifBddSpec.variables, cifVar);
                Assert.check((varIdx >= 0 ? 1 : 0) != 0);
                CifBddVariable cifBddVar = cifBddSpec.variables[varIdx];
                Assert.check((boolean)(cifBddVar instanceof CifBddDiscVariable));
                CifBddDiscVariable var = (CifBddDiscVariable)cifBddVar;
                if (cifVar.getValue() == null) {
                    CifType type = cifVar.getType();
                    values = Lists.list((Object)CifValueUtils.getDefaultValue((CifType)type, null));
                } else {
                    values = cifVar.getValue().getValues().isEmpty() ? null : cifVar.getValue().getValues();
                }
                if (values == null) {
                    pred = BddUtils.getVarDomain(var, false, cifBddSpec.factory);
                } else {
                    pred = cifBddSpec.factory.zero();
                    for (Expression value : values) {
                        BDD relation;
                        if (var.type instanceof BoolType) {
                            BDD valueBdd = CifToBddConverter.convertPred(value, true, cifBddSpec);
                            Assert.check((var.domain.varNum() == 1 ? 1 : 0) != 0);
                            int varVar = var.domain.vars()[0];
                            BDD varBdd = cifBddSpec.factory.ithVar(varVar);
                            relation = varBdd.biimpWith(valueBdd);
                            pred = pred.orWith(relation);
                            continue;
                        }
                        CifBddBitVector varVector = UnsignedCifBddBitVector.createFromDomain(var.domain);
                        CifBddBitVector valueVector = CifToBddConverter.convertExpr(value, true, cifBddSpec);
                        Pair<CifBddBitVector<UnsignedCifBddBitVectorAndCarry, UnsignedCifBddBitVectorAndCarry>, CifBddBitVector<UnsignedCifBddBitVectorAndCarry, UnsignedCifBddBitVectorAndCarry>> vectors = CifBddBitVector.ensureCompatible(varVector, valueVector);
                        varVector = (CifBddBitVector)vectors.left;
                        valueVector = (CifBddBitVector)vectors.right;
                        CifBddBitVector.ensureSameLength(varVector, valueVector);
                        relation = varVector.equalToAny(valueVector);
                        varVector.free();
                        valueVector.free();
                        pred = pred.orWith(relation);
                    }
                }
                cifBddSpec.initialsVars.set(varIdx, pred);
                cifBddSpec.initialVars = cifBddSpec.initialVars.andWith(pred.id());
            }
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            BDD autInit = cifBddSpec.factory.zero();
            for (Location loc : aut.getLocations()) {
                if (loc.getInitials().isEmpty()) continue;
                EList locInits = loc.getInitials();
                BDD locInit = CifToBddConverter.convertPreds((List<Expression>)locInits, true, cifBddSpec);
                Expression srcLocRef = locPtrManager.createLocRef(loc);
                BDD srcLocPred = CifToBddConverter.convertPred(srcLocRef, true, cifBddSpec);
                locInit = locInit.and(srcLocPred);
                autInit = autInit.or(locInit);
            }
            cifBddSpec.initialsLocs.add(autInit);
            cifBddSpec.initialLocs = cifBddSpec.initialLocs.andWith(autInit.id());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertInit((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void convertMarked(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Expression pred : comp.getMarkeds()) {
            BDD marked = CifToBddConverter.convertPred(pred, false, cifBddSpec);
            cifBddSpec.markedsComps.add(marked);
            cifBddSpec.markedComps = cifBddSpec.markedComps.andWith(marked.id());
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            BDD autMarked = cifBddSpec.factory.zero();
            for (Location loc : aut.getLocations()) {
                if (loc.getMarkeds().isEmpty()) continue;
                EList locMarkeds = loc.getMarkeds();
                BDD locMarked = CifToBddConverter.convertPreds((List<Expression>)locMarkeds, false, cifBddSpec);
                Expression srcLocRef = locPtrManager.createLocRef(loc);
                BDD srcLocPred = CifToBddConverter.convertPred(srcLocRef, false, cifBddSpec);
                locMarked = locMarked.andWith(srcLocPred);
                autMarked = autMarked.orWith(locMarked);
            }
            cifBddSpec.markedsLocs.add(autMarked);
            cifBddSpec.markedLocs = cifBddSpec.markedLocs.andWith(autMarked.id());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertMarked((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void convertStateInvs(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Invariant inv : comp.getInvariants()) {
            if (inv.getInvKind() != InvKind.STATE) continue;
            Expression pred = inv.getPredicate();
            BDD invComp = CifToBddConverter.convertPred(pred, false, cifBddSpec);
            switch (inv.getSupKind()) {
                case PLANT: {
                    cifBddSpec.plantInvsComps.add(invComp);
                    cifBddSpec.plantInvComps = cifBddSpec.plantInvComps.andWith(invComp.id());
                    break;
                }
                case REQUIREMENT: {
                    cifBddSpec.reqInvsComps.add(invComp);
                    cifBddSpec.reqInvComps = cifBddSpec.reqInvComps.andWith(invComp.id());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                }
            }
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    if (inv.getInvKind() != InvKind.STATE) continue;
                    Expression pred = inv.getPredicate();
                    BDD invLoc = CifToBddConverter.convertPred(pred, false, cifBddSpec);
                    Expression srcLocRef = locPtrManager.createLocRef(loc);
                    BDD srcLocPred = CifToBddConverter.convertPred(srcLocRef, false, cifBddSpec);
                    invLoc = srcLocPred.not().orWith(invLoc);
                    srcLocPred.free();
                    switch (inv.getSupKind()) {
                        case PLANT: {
                            cifBddSpec.plantInvsLocs.add(invLoc);
                            cifBddSpec.plantInvLocs = cifBddSpec.plantInvLocs.andWith(invLoc.id());
                            break;
                        }
                        case REQUIREMENT: {
                            cifBddSpec.reqInvsLocs.add(invLoc);
                            cifBddSpec.reqInvLocs = cifBddSpec.reqInvLocs.andWith(invLoc.id());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                        }
                    }
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertStateInvs((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void convertStateEvtExclInvs(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Invariant inv : comp.getInvariants()) {
            Event event;
            if (inv.getInvKind() == InvKind.STATE || !cifBddSpec.alphabet.contains(event = ((EventExpression)inv.getEvent()).getEvent())) continue;
            Expression pred = inv.getPredicate();
            BDD compInv = CifToBddConverter.convertPred(pred, false, cifBddSpec);
            if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                BDD compInvNot = compInv.not();
                compInv.free();
                compInv = compInvNot;
            }
            switch (inv.getSupKind()) {
                case PLANT: {
                    this.storeStateEvtExclInv(cifBddSpec.stateEvtExclPlantLists, event, compInv.id());
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclPlants, event, compInv.id());
                    break;
                }
                case REQUIREMENT: {
                    this.storeStateEvtExclInv(cifBddSpec.stateEvtExclReqLists, event, compInv.id());
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclReqs, event, compInv.id());
                    if (!event.getControllable().booleanValue()) break;
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclsReqInvs, event, compInv.id());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                }
            }
            compInv.free();
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    Event event;
                    if (inv.getInvKind() == InvKind.STATE || !cifBddSpec.alphabet.contains(event = ((EventExpression)inv.getEvent()).getEvent())) continue;
                    Expression pred = inv.getPredicate();
                    BDD locInv = CifToBddConverter.convertPred(pred, false, cifBddSpec);
                    Expression srcLocRef = locPtrManager.createLocRef(loc);
                    BDD srcLocPred = CifToBddConverter.convertPred(srcLocRef, false, cifBddSpec);
                    locInv = srcLocPred.not().orWith(locInv);
                    srcLocPred.free();
                    if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                        BDD locInvNot = locInv.not();
                        locInv.free();
                        locInv = locInvNot;
                    }
                    switch (inv.getSupKind()) {
                        case PLANT: {
                            this.storeStateEvtExclInv(cifBddSpec.stateEvtExclPlantLists, event, locInv.id());
                            this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclPlants, event, locInv.id());
                            break;
                        }
                        case REQUIREMENT: {
                            this.storeStateEvtExclInv(cifBddSpec.stateEvtExclReqLists, event, locInv.id());
                            this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclReqs, event, locInv.id());
                            if (!event.getControllable().booleanValue()) break;
                            this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclsReqInvs, event, locInv.id());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                        }
                    }
                    locInv.free();
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertStateEvtExclInvs((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void storeStateEvtExclInv(Map<Event, List<BDD>> eventInvs, Event event, BDD inv) {
        List<BDD> invs = eventInvs.get(event);
        invs.add(inv);
    }

    private void conjunctAndStoreStateEvtExclInv(Map<Event, BDD> eventInvs, Event event, BDD inv) {
        BDD invs = eventInvs.get(event);
        invs = invs.andWith(inv);
        eventInvs.put(event, invs);
    }

    private void preconvertReqAuts(List<Automaton> requirements, List<CifEventUtils.Alphabets> alphabets, CifBddSpec cifBddSpec) {
        this.originalMonitors = Maps.mapc((int)requirements.size());
        int i = 0;
        while (i < requirements.size()) {
            Automaton requirement = requirements.get(i);
            CifEventUtils.Alphabets reqAlphabets = alphabets.get(i);
            for (Event event : reqAlphabets.syncAlphabet) {
                if (reqAlphabets.moniAlphabet.contains(event)) continue;
                Expression cifGuard = CifGuardUtils.mergeGuards((Automaton)requirement, (Event)event, EdgeEventImpl.class, (CifGuardUtils.LocRefExprCreator)CifGuardUtils.LocRefExprCreator.DEFAULT);
                BDD cifBddGuard = CifToBddConverter.convertPred(cifGuard, false, cifBddSpec);
                this.storeStateEvtExclInv(cifBddSpec.stateEvtExclReqLists, event, cifBddGuard.id());
                this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclReqs, event, cifBddGuard.id());
                if (event.getControllable().booleanValue()) {
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclsReqAuts, event, cifBddGuard.id());
                }
                cifBddGuard.free();
            }
            if (!reqAlphabets.syncAlphabet.isEmpty()) {
                this.originalMonitors.put(requirement, requirement.getMonitors());
                requirement.setMonitors(CifConstructors.newMonitors());
                reqAlphabets.moniAlphabet = Sets.copy((Set)reqAlphabets.syncAlphabet);
            }
            ++i;
        }
    }

    private void convertPlantReqAuts(List<Automaton> plants, List<Automaton> requirements, List<CifEventUtils.Alphabets> plantAlphabets, List<CifEventUtils.Alphabets> reqAlphabets, CifBddLocationPointerManager locPtrManager, CifBddSpec cifBddSpec) {
        List automata = Lists.concat(plants, requirements);
        List<CifEventUtils.Alphabets> alphabets = Lists.concat(plantAlphabets, reqAlphabets);
        List events = Lists.set2list(cifBddSpec.alphabet);
        if (cifBddSpec.settings.getAdhereToExecScheme()) {
            Assert.areEqual((Object)automata.size(), (Object)alphabets.size());
            Map alphabetsPerAut = Maps.mapc((int)alphabets.size());
            int i = 0;
            while (i < automata.size()) {
                alphabetsPerAut.put((Automaton)automata.get(i), (CifEventUtils.Alphabets)alphabets.get(i));
                ++i;
            }
            CifExecSchemeUtils.orderAutomata((List)automata);
            alphabets = automata.stream().map(aut -> (CifEventUtils.Alphabets)alphabetsPerAut.get(aut)).toList();
            CifExecSchemeUtils.orderEvents((List)events);
        }
        List cifEdges = Lists.list();
        LinearizeProduct.linearizeEdges((List)automata, (List)alphabets, (List)events, (LocationPointerManager)locPtrManager, (boolean)false, (boolean)true, (List)cifEdges);
        cifBddSpec.edges = Lists.listc((int)cifEdges.size());
        cifBddSpec.eventEdges = Maps.mapc((int)cifBddSpec.alphabet.size());
        for (Edge cifEdge : cifEdges) {
            BDD guard;
            Event event;
            if (cifBddSpec.settings.getTermination().isRequested()) break;
            CifBddEdge cifBddEdge = new CifBddEdge(cifBddSpec);
            cifBddEdge.edges = Lists.list((Object)cifEdge);
            Assert.check((cifEdge.getEvents().size() == 1 ? 1 : 0) != 0);
            EdgeEvent edgeEvent = (EdgeEvent)Lists.first((List)cifEdge.getEvents());
            cifBddEdge.event = event = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
            cifBddSpec.edges.add(cifBddEdge);
            List cifBddEdges = cifBddSpec.eventEdges.get(event);
            if (cifBddEdges == null) {
                cifBddEdges = Lists.list();
                cifBddSpec.eventEdges.put(event, cifBddEdges);
            }
            cifBddEdges.add(cifBddEdge);
            cifBddEdge.guard = guard = CifToBddConverter.convertPreds((List<Expression>)cifEdge.getGuards(), false, cifBddSpec);
            cifBddEdge.origGuard = guard.id();
            EList updates = cifEdge.getUpdates();
            CifToBddConverter.convertUpdates((List<Update>)updates, cifBddEdge, locPtrManager, cifBddSpec);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            cifBddEdge.guard = cifBddEdge.guard.andWith(cifBddEdge.error.not());
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            return;
        }
        this.checkNonDeterminism(cifBddSpec.edges, cifBddSpec.settings.getAllowNonDeterminism());
    }

    private void checkNonDeterminism(List<CifBddEdge> edges, AllowNonDeterminism allowNonDeterminism) {
        Map eventGuards = Maps.map();
        Set conflicts = Sets.setc((int)0);
        for (CifBddEdge edge : edges) {
            Event evt = edge.event;
            boolean controllable = evt.getControllable();
            if (allowNonDeterminism.allowFor(controllable) || conflicts.contains(evt)) continue;
            BDD curGuard = (BDD)eventGuards.get(evt);
            BDD newGuard = edge.guard;
            if (curGuard == null) {
                eventGuards.put(evt, newGuard.id());
                continue;
            }
            BDD overlap = curGuard.and(newGuard);
            if (overlap.isZero()) {
                eventGuards.put(evt, curGuard.orWith(newGuard.id()));
            } else {
                conflicts.add(evt);
            }
            overlap.free();
        }
        for (BDD guard : eventGuards.values()) {
            guard.free();
        }
        Set problems = Sets.setc((int)conflicts.size());
        for (Event conflict : conflicts) {
            Object groupsTxt;
            List eventEdges = Lists.list();
            for (CifBddEdge edge : edges) {
                if (edge.event != conflict) continue;
                eventEdges.add(edge);
            }
            List<List<CifBddEdge>> groups = CifToBddConverter.groupOnGuardOverlap(eventEdges);
            List guardsTxts = Lists.list();
            for (List<CifBddEdge> group : groups) {
                if (group.size() < 2) continue;
                List guardTxts = Lists.list();
                for (CifBddEdge edge : group) {
                    Assert.check((edge.edges.size() == 1 ? 1 : 0) != 0);
                    EList guards = ((Edge)Lists.first(edge.edges)).getGuards();
                    String guardsTxt = guards.isEmpty() ? "true" : CifTextUtils.exprsToStr((List)guards);
                    guardTxts.add("\"" + guardsTxt + "\"");
                }
                Assert.check((!guardTxts.isEmpty() ? 1 : 0) != 0);
                guardsTxts.add(String.join((CharSequence)", ", guardTxts));
            }
            Assert.check((!guardsTxts.isEmpty() ? 1 : 0) != 0);
            if (guardsTxts.size() == 1) {
                groupsTxt = " " + (String)guardsTxts.get(0) + ".";
            } else {
                int i = 0;
                while (i < guardsTxts.size()) {
                    String txt = (String)guardsTxts.get(i);
                    txt = Strings.fmt((String)"\n    Group %d: %s", (Object[])new Object[]{i + 1, txt});
                    guardsTxts.set(i, txt);
                    ++i;
                }
                groupsTxt = String.join((CharSequence)"", guardsTxts);
            }
            String eventKind = switch (allowNonDeterminism) {
                case AllowNonDeterminism.ALL -> throw new AssertionError((Object)"Should not get here, as non-determinism is allowed.");
                case AllowNonDeterminism.NONE -> "";
                case AllowNonDeterminism.CONTROLLABLE -> "uncontrollable ";
                case AllowNonDeterminism.UNCONTROLLABLE -> "controllable ";
                default -> throw new MatchException(null, null);
            };
            String msg = Strings.fmt((String)"Unsupported linearized edges with non-determinism detected for edges of %sevent \"%s\" with overlapping guards:%s", (Object[])new Object[]{eventKind, CifTextUtils.getAbsName((PositionObject)conflict), groupsTxt});
            problems.add(msg);
        }
        if (problems.isEmpty()) {
            return;
        }
        String msg = Strings.fmt((String)"%s failed due to unsatisfied preconditions:\n - ", (Object[])new Object[]{this.appName}) + String.join((CharSequence)"\n - ", Sets.sortedstrings((Set)problems));
        throw new UnsupportedException(msg);
    }

    private static List<List<CifBddEdge>> groupOnGuardOverlap(List<CifBddEdge> edges) {
        List groups = Lists.listc((int)edges.size());
        int i = 0;
        while (i < edges.size()) {
            groups.add(Lists.list((Object)edges.get(i)));
            ++i;
        }
        i = 0;
        while (i < groups.size()) {
            Assert.check((((List)groups.get(i)).size() == 1 ? 1 : 0) != 0);
            BDD curGuard = ((CifBddEdge)((List)groups.get((int)i)).get((int)0)).guard.id();
            boolean changed = true;
            while (changed) {
                changed = false;
                int j = i + 1;
                while (j < groups.size()) {
                    Assert.check((((List)groups.get(j)).size() == 1 ? 1 : 0) != 0);
                    BDD newGuard = ((CifBddEdge)((List)groups.get((int)j)).get((int)0)).guard;
                    BDD overlapPred = curGuard.and(newGuard);
                    boolean disjoint = overlapPred.isZero();
                    overlapPred.free();
                    if (!disjoint) {
                        changed = true;
                        ((List)groups.get(i)).add((CifBddEdge)((List)groups.get(j)).get(0));
                        groups.remove(j);
                        curGuard = curGuard.andWith(newGuard.id());
                    }
                    ++j;
                }
            }
            curGuard.free();
            ++i;
        }
        return groups;
    }

    public static void convertUpdates(List<Update> updates, CifBddEdge cifBddEdge, CifBddLocationPointerManager locPtrManager, CifBddSpec cifBddSpec) {
        List assignments = Lists.listc((int)updates.size());
        boolean[] assigned = new boolean[cifBddSpec.variables.length];
        BDD relation = cifBddSpec.factory.one();
        BDD error = cifBddSpec.factory.zero();
        for (Update update : updates) {
            Pair<BDD, BDD> rslt = CifToBddConverter.convertUpdate(update, assignments, assigned, locPtrManager, cifBddSpec);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            BDD updateRelation = (BDD)rslt.left;
            relation = relation.andWith(updateRelation);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                return;
            }
            BDD updateError = (BDD)rslt.right;
            error = error.orWith(updateError);
            if (!cifBddSpec.settings.getTermination().isRequested()) continue;
            return;
        }
        int i = 0;
        while (i < assigned.length) {
            if (assigned[i]) {
                cifBddEdge.assignedVariables.add(cifBddSpec.variables[i]);
            }
            ++i;
        }
        cifBddEdge.assignments = Lists.list((Object)assignments);
        cifBddEdge.update = relation;
        cifBddEdge.error = error;
    }

    public static Pair<BDD, BDD> convertUpdate(Update update, List<Assignment> assignments, boolean[] assigned, CifBddLocationPointerManager locPtrManager, CifBddSpec cifBddSpec) {
        Assert.check((boolean)(update instanceof Assignment));
        Assignment asgn = (Assignment)update;
        assignments.add(asgn);
        Expression addr = asgn.getAddressable();
        Assert.check((boolean)(addr instanceof DiscVariableExpression));
        DiscVariable cifVar = ((DiscVariableExpression)addr).getVariable();
        Automaton cifAut = locPtrManager.getAutomaton(cifVar);
        if (cifAut != null) {
            int varIdx = CifToBddConverter.getLpVarIdx(cifBddSpec.variables, cifAut);
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            Assert.check((boolean)(var instanceof CifBddLocPtrVariable));
            Assert.check((!assigned[varIdx] ? 1 : 0) != 0);
            assigned[varIdx] = true;
            Assert.check((boolean)(asgn.getValue() instanceof IntExpression));
            int locIdx = ((IntExpression)asgn.getValue()).getValue();
            UnsignedCifBddBitVector varVector = UnsignedCifBddBitVector.createFromDomain(var.domainNew);
            UnsignedCifBddBitVector locVector = UnsignedCifBddBitVector.createFromInt(cifBddSpec.factory, locIdx);
            Assert.check((locVector.length() <= varVector.length() ? 1 : 0) != 0);
            locVector.resize(varVector.length());
            BDD relation = varVector.equalTo(locVector);
            varVector.free();
            locVector.free();
            return Pair.pair((Object)relation, (Object)cifBddSpec.factory.zero());
        }
        int varIdx = CifToBddConverter.getTypedVarIdx(cifBddSpec.variables, (Declaration)cifVar);
        Assert.check((varIdx >= 0 ? 1 : 0) != 0);
        CifBddVariable cifBddVar = cifBddSpec.variables[varIdx];
        Assert.check((boolean)(cifBddVar instanceof CifBddTypedVariable));
        CifBddTypedVariable var = (CifBddTypedVariable)cifBddVar;
        Assert.check((!assigned[varIdx] ? 1 : 0) != 0);
        assigned[varIdx] = true;
        if (var.type instanceof BoolType) {
            Expression rhsExpr = asgn.getValue();
            BDD rhsBdd = CifToBddConverter.convertPred(rhsExpr, false, cifBddSpec);
            Assert.check((var.domainNew.varNum() == 1 ? 1 : 0) != 0);
            int lhsVar = var.domainNew.vars()[0];
            BDD lhsBdd = cifBddSpec.factory.ithVar(lhsVar);
            BDD relation = lhsBdd.biimpWith(rhsBdd);
            return Pair.pair((Object)relation, (Object)cifBddSpec.factory.zero());
        }
        CifBddBitVector varVector = UnsignedCifBddBitVector.createFromDomain(var.domainNew);
        CifBddBitVector valueVector = CifToBddConverter.convertExpr(asgn.getValue(), false, cifBddSpec);
        Pair<CifBddBitVector<UnsignedCifBddBitVectorAndCarry, UnsignedCifBddBitVectorAndCarry>, CifBddBitVector<UnsignedCifBddBitVectorAndCarry, UnsignedCifBddBitVectorAndCarry>> vectors = CifBddBitVector.ensureCompatible(varVector, valueVector);
        varVector = (CifBddBitVector)vectors.left;
        valueVector = (CifBddBitVector)vectors.right;
        int origVarVectorLength = varVector.length();
        CifBddBitVector.ensureSameLength(varVector, valueVector);
        BDD relation = varVector.equalToAny(valueVector);
        varVector.free();
        BDD error = cifBddSpec.factory.zero();
        int i = origVarVectorLength;
        while (i < valueVector.length()) {
            error = error.orWith(valueVector.getBit(i).id());
            ++i;
        }
        valueVector.free();
        return Pair.pair((Object)relation, (Object)error);
    }

    private void addInputVariableEdges(CifBddSpec cifBddSpec) {
        cifBddSpec.inputVarEvents = Sets.set();
        CifBddVariable[] cifBddVariableArray = cifBddSpec.variables;
        int n = cifBddSpec.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable var = cifBddVariableArray[n2];
            if (var instanceof CifBddInputVariable) {
                CifBddInputVariable cifBddInputVar = (CifBddInputVariable)var;
                Event event = CifConstructors.newEvent();
                event.setControllable(Boolean.valueOf(false));
                event.setName(cifBddInputVar.var.getName());
                cifBddSpec.alphabet.add(event);
                ComplexComponent comp = (ComplexComponent)cifBddInputVar.var.eContainer();
                comp.getDeclarations().add((Object)event);
                cifBddSpec.inputVarEvents.add(event);
                CifBddEdge edge = new CifBddEdge(cifBddSpec);
                edge.edges = Lists.list(null);
                edge.event = event;
                edge.origGuard = cifBddSpec.factory.one();
                edge.guard = cifBddSpec.factory.one();
                edge.error = cifBddSpec.factory.zero();
                cifBddSpec.edges.add(edge);
                cifBddSpec.eventEdges.put(event, Lists.list((Object)edge));
                InputVariableExpression addr = CifConstructors.newInputVariableExpression();
                addr.setVariable(cifBddInputVar.var);
                Assignment asgn = CifConstructors.newAssignment();
                asgn.setAddressable((Expression)addr);
                edge.assignments = Lists.list((Object)Lists.list((Object)asgn));
                UnsignedCifBddBitVector vectorOld = UnsignedCifBddBitVector.createFromDomain(var.domain);
                UnsignedCifBddBitVector vectorNew = UnsignedCifBddBitVector.createFromDomain(var.domainNew);
                edge.update = vectorOld.unequalTo(vectorNew);
                edge.update = edge.update.andWith(BddUtils.getVarDomain(var, true, cifBddSpec.factory));
                vectorOld.free();
                vectorNew.free();
                edge.assignedVariables.add(var);
            }
            ++n2;
        }
    }

    private void mergeEdges(CifBddSpec cifBddSpec) {
        Assert.notNull(cifBddSpec.eventEdges);
        EdgeGranularity granularity = cifBddSpec.settings.getEdgeGranularity();
        boolean adhereToExecScheme = cifBddSpec.settings.getAdhereToExecScheme();
        Assert.implies((boolean)adhereToExecScheme, (granularity == EdgeGranularity.PER_EDGE ? 1 : 0) != 0);
        switch (granularity) {
            case PER_EDGE: {
                return;
            }
            case PER_EVENT: {
                int eventCount = cifBddSpec.eventEdges.size();
                cifBddSpec.edges = Lists.listc((int)eventCount);
                for (Map.Entry<Event, List<CifBddEdge>> entry : cifBddSpec.eventEdges.entrySet()) {
                    CifBddEdge mergedEdge = (CifBddEdge)entry.getValue().stream().reduce(CifBddEdge::mergeEdges).get();
                    cifBddSpec.edges.add(mergedEdge);
                    entry.setValue(Lists.list((Object)mergedEdge));
                }
                return;
            }
        }
        throw new RuntimeException("Unknown granularity: " + String.valueOf((Object)granularity));
    }

    private void orderEdges(CifBddSpec cifBddSpec) {
        cifBddSpec.orderedEdgesBackward = CifToBddConverter.orderEdgesForDirection(cifBddSpec.edges, cifBddSpec.settings.getEdgeOrderBackward(), cifBddSpec.settings.getEdgeOrderAllowDuplicateEvents(), false);
        cifBddSpec.orderedEdgesForward = CifToBddConverter.orderEdgesForDirection(cifBddSpec.edges, cifBddSpec.settings.getEdgeOrderForward(), cifBddSpec.settings.getEdgeOrderAllowDuplicateEvents(), true);
    }

    private static List<CifBddEdge> orderEdgesForDirection(List<CifBddEdge> edges, String orderTxt, EdgeOrderDuplicateEventAllowance edgeOrderAllowDuplicateEvents, boolean forForwardReachability) {
        if (orderTxt.toLowerCase(Locale.US).equals("model")) {
            return edges;
        }
        if (orderTxt.toLowerCase(Locale.US).equals("reverse-model")) {
            return Lists.reverse(edges);
        }
        if (orderTxt.toLowerCase(Locale.US).equals("sorted")) {
            return edges.stream().sorted((v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false))).toList();
        }
        if (orderTxt.toLowerCase(Locale.US).equals("reverse-sorted")) {
            return Lists.reverse(edges.stream().sorted((v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false))).toList());
        }
        if (orderTxt.toLowerCase(Locale.US).equals("random") || orderTxt.toLowerCase(Locale.US).startsWith("random:")) {
            Long seed = null;
            if (orderTxt.contains(":")) {
                int idx = orderTxt.indexOf(":");
                String seedTxt = orderTxt.substring(idx + 1);
                try {
                    seed = Long.parseUnsignedLong(seedTxt);
                }
                catch (NumberFormatException ex) {
                    String msg = Strings.fmt((String)"Invalid random %s edge order seed number: \"%s\".", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", orderTxt});
                    throw new InvalidOptionException(msg, (Throwable)ex);
                }
            }
            List orderedEdges = Lists.copy(edges);
            if (seed == null) {
                Collections.shuffle(orderedEdges);
            } else {
                Collections.shuffle(orderedEdges, new Random(seed));
            }
            return orderedEdges;
        }
        List orderedEdges = Lists.listc((int)edges.size());
        Set processedEdges = Sets.set();
        String[] stringArray = StringUtils.split((String)orderTxt, (String)",");
        int msg = stringArray.length;
        int ex = 0;
        while (ex < msg) {
            String elemTxt = stringArray[ex];
            if (!(elemTxt = elemTxt.trim()).isEmpty()) {
                Pattern pattern;
                try {
                    pattern = CifTextUtils.getRegExForCifNamePattern((String)elemTxt);
                }
                catch (IllegalArgumentException ex2) {
                    throw new InvalidOptionException(Strings.fmt((String)"Invalid custom %s edge order: invalid name pattern \"%s\".", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", elemTxt}), (Throwable)new InvalidOptionException(ex2.getMessage()));
                }
                List matches = Lists.list();
                for (CifBddEdge edge : edges) {
                    String name = CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false);
                    if (!pattern.matcher(name).matches()) continue;
                    matches.add(edge);
                }
                if (matches.isEmpty()) {
                    String msg2 = Strings.fmt((String)"Invalid custom %s edge order: can't find a match for \"%s\". There is no supported event or input variable in the specification that matches the given name pattern.", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", elemTxt});
                    throw new InvalidOptionException(msg2);
                }
                Collections.sort(matches, (v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false)));
                if (edgeOrderAllowDuplicateEvents == EdgeOrderDuplicateEventAllowance.DISALLOWED) {
                    for (CifBddEdge edge : matches) {
                        if (!processedEdges.contains(edge)) continue;
                        String msg3 = Strings.fmt((String)"Invalid custom %s edge order: event \"%s\" is included more than once. If the duplicate event is intentional, enable allowing duplicate events in the custom event order.", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false)});
                        throw new InvalidOptionException(msg3);
                    }
                }
                processedEdges.addAll(matches);
                orderedEdges.addAll(matches);
            }
            ++ex;
        }
        Set missingEdges = Sets.difference(edges, (Collection)processedEdges);
        if (!missingEdges.isEmpty()) {
            Set names = Sets.set();
            for (CifBddEdge edge : missingEdges) {
                names.add("\"" + CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false) + "\"");
            }
            List sortedNames = Sets.sortedgeneric((Set)names, (Comparator)Strings.SORTER);
            String msg4 = Strings.fmt((String)"Invalid custom %s edge order: the following event(s) are missing from the specified order: %s.", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", String.join((CharSequence)", ", sortedNames)});
            throw new InvalidOptionException(msg4);
        }
        return orderedEdges;
    }

    private void checkEdgeWorksetAlgorithmSettings(CifBddSettings settings) {
        if (settings.getExplorationStrategy() != ExplorationStrategy.CHAINING_WORKSET) {
            return;
        }
        if (settings.getEdgeGranularity() != EdgeGranularity.PER_EVENT) {
            throw new InvalidOptionException("The edge workset algorithm can only be used with per-event edge granularity. Either disable the edge workset algorithm, or configure per-event edge granularity.");
        }
        if (settings.getEdgeOrderAllowDuplicateEvents() == EdgeOrderDuplicateEventAllowance.ALLOWED) {
            throw new InvalidOptionException("The edge workset algorithm can not be used with duplicate events in the edge order. Either disable the edge workset algorithm, or disable duplicates for custom edge orders.");
        }
    }

    private void checkSaturationSettings(CifBddSettings settings) {
        if (settings.getExplorationStrategy() != ExplorationStrategy.SATURATION) {
            return;
        }
        if (settings.getEdgeOrderAllowDuplicateEvents() == EdgeOrderDuplicateEventAllowance.ALLOWED) {
            throw new InvalidOptionException("Saturation can not be used with duplicate events in the edge order. Either disable saturation, or disable duplicates for custom edge orders.");
        }
    }

    public static BDD convertPreds(List<Expression> preds, boolean initial, CifBddSpec cifBddSpec) {
        BDD rslt = cifBddSpec.factory.one();
        for (Expression pred : preds) {
            rslt = rslt.andWith(CifToBddConverter.convertPred(pred, initial, cifBddSpec));
        }
        return rslt;
    }

    public static BDD convertPred(Expression pred, boolean initial, CifBddSpec cifBddSpec) {
        Object valueObj;
        if (pred instanceof BoolExpression) {
            boolean value = ((BoolExpression)pred).isValue();
            return value ? cifBddSpec.factory.one() : cifBddSpec.factory.zero();
        }
        if (pred instanceof DiscVariableExpression) {
            DiscVariable cifVar = ((DiscVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)cifVar.getType()) instanceof BoolType));
            int varIdx = CifToBddConverter.getDiscVarIdx(cifBddSpec.variables, cifVar);
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            return var.domain.ithVar(1L);
        }
        if (pred instanceof InputVariableExpression) {
            InputVariable cifVar = ((InputVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)cifVar.getType()) instanceof BoolType));
            int varIdx = CifToBddConverter.getInputVarIdx(cifBddSpec.variables, cifVar);
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            return var.domain.ithVar(1L);
        }
        if (pred instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)var.getType()) instanceof BoolType));
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return CifToBddConverter.convertPred(value, initial, cifBddSpec);
        }
        if (pred instanceof LocationExpression) {
            Location loc = ((LocationExpression)pred).getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            int varIdx = CifToBddConverter.getLpVarIdx(cifBddSpec.variables, aut);
            if (varIdx == -1) {
                Assert.areEqual((Object)aut.getLocations().size(), (Object)1);
                return cifBddSpec.factory.one();
            }
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            int locIdx = aut.getLocations().indexOf((Object)loc);
            Assert.check((locIdx >= 0 ? 1 : 0) != 0);
            return var.domain.ithVar((long)locIdx);
        }
        if (pred instanceof ConstantExpression) {
            Object valueObj2;
            Constant constant = ((ConstantExpression)pred).getConstant();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)constant.getType()) instanceof BoolType));
            try {
                valueObj2 = CifEvalUtils.eval((Expression)constant.getValue(), (boolean)initial);
            }
            catch (CifEvalException ex) {
                throw new AssertionError("Precondition violation.", ex);
            }
            return (Boolean)valueObj2 != false ? cifBddSpec.factory.one() : cifBddSpec.factory.zero();
        }
        if (pred instanceof UnaryExpression) {
            UnaryExpression upred = (UnaryExpression)pred;
            op = upred.getOperator();
            switch (op) {
                case INVERSE: {
                    BDD child = CifToBddConverter.convertPred(upred.getChild(), initial, cifBddSpec);
                    BDD rslt = child.not();
                    child.free();
                    return rslt;
                }
            }
        } else if (pred instanceof BinaryExpression) {
            BinaryExpression bpred = (BinaryExpression)pred;
            op = ((BinaryExpression)pred).getOperator();
            Expression lhs = bpred.getLeft();
            Expression rhs = bpred.getRight();
            switch (CifToBddConverter.$SWITCH_TABLE$org$eclipse$escet$cif$metamodel$cif$expressions$BinaryOperator()[op.ordinal()]) {
                case 4: {
                    CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                    CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                    Assert.check((boolean)(ltype instanceof BoolType));
                    Assert.check((boolean)(rtype instanceof BoolType));
                    BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                    BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                    return left.andWith(right);
                }
                case 1: {
                    CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                    CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                    Assert.check((boolean)(ltype instanceof BoolType));
                    Assert.check((boolean)(rtype instanceof BoolType));
                    BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                    BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                    return left.orWith(right);
                }
                case 2: {
                    BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                    BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                    return left.impWith(right);
                }
                case 3: {
                    BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                    BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                    return left.biimpWith(right);
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return CifToBddConverter.convertCmpPred(lhs, rhs, (BinaryOperator)op, initial, cifBddSpec);
                }
            }
        } else {
            if (pred instanceof IfExpression) {
                IfExpression ifPred = (IfExpression)pred;
                BDD rslt = CifToBddConverter.convertPred(ifPred.getElse(), initial, cifBddSpec);
                int i = ifPred.getElifs().size() - 1;
                while (i >= 0) {
                    ElifExpression elifPred = (ElifExpression)ifPred.getElifs().get(i);
                    BDD elifGuards = CifToBddConverter.convertPreds((List<Expression>)elifPred.getGuards(), initial, cifBddSpec);
                    BDD elifThen = CifToBddConverter.convertPred(elifPred.getThen(), initial, cifBddSpec);
                    BDD elifRslt = elifGuards.ite(elifThen, rslt);
                    elifGuards.free();
                    elifThen.free();
                    rslt.free();
                    rslt = elifRslt;
                    --i;
                }
                BDD ifGuards = CifToBddConverter.convertPreds((List<Expression>)ifPred.getGuards(), initial, cifBddSpec);
                BDD ifThen = CifToBddConverter.convertPred(ifPred.getThen(), initial, cifBddSpec);
                BDD elifRslt = ifGuards.ite(ifThen, rslt);
                ifGuards.free();
                ifThen.free();
                rslt.free();
                rslt = elifRslt;
                return rslt;
            }
            if (pred instanceof SwitchExpression) {
                SwitchExpression switchPred = (SwitchExpression)pred;
                Expression value = switchPred.getValue();
                EList cases = switchPred.getCases();
                BDD rslt = CifToBddConverter.convertPred(((SwitchCase)Lists.last((List)cases)).getValue(), initial, cifBddSpec);
                int i = cases.size() - 2;
                while (i >= 0) {
                    SwitchCase cse = (SwitchCase)cases.get(i);
                    Expression caseGuardExpr = CifTypeUtils.isAutRefExpr((Expression)value) ? cse.getKey() : CifConstructors.newBinaryExpression((Expression)((Expression)EMFHelper.deepclone((EObject)value)), (BinaryOperator)BinaryOperator.EQUAL, null, (Expression)((Expression)EMFHelper.deepclone((EObject)cse.getKey())), (CifType)CifConstructors.newBoolType());
                    BDD caseGuard = CifToBddConverter.convertPred(caseGuardExpr, initial, cifBddSpec);
                    BDD caseThen = CifToBddConverter.convertPred(cse.getValue(), initial, cifBddSpec);
                    BDD caseRslt = caseGuard.ite(caseThen, rslt);
                    caseGuard.free();
                    caseThen.free();
                    rslt.free();
                    rslt = caseRslt;
                    --i;
                }
                return rslt;
            }
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)pred, (boolean)initial);
        }
        catch (CifEvalException ex) {
            throw new AssertionError("Precondition violation.", ex);
        }
        Assert.check((boolean)(valueObj instanceof Boolean));
        boolean value = (Boolean)valueObj;
        return value ? cifBddSpec.factory.one() : cifBddSpec.factory.zero();
    }

    public static BDD convertCmpPred(Expression lhs, Expression rhs, BinaryOperator op, boolean initial, CifBddSpec cifBddSpec) {
        CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
        Assert.check((ltype instanceof BoolType && rtype instanceof BoolType || ltype instanceof EnumType && rtype instanceof EnumType || ltype instanceof IntType && rtype instanceof IntType ? 1 : 0) != 0);
        if (ltype instanceof BoolType && rtype instanceof BoolType) {
            BDD lbdd = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
            BDD rbdd = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
            switch (op) {
                case EQUAL: {
                    return lbdd.biimpWith(rbdd);
                }
                case UNEQUAL: {
                    BDD eq = lbdd.biimpWith(rbdd);
                    BDD rslt = eq.not();
                    eq.free();
                    return rslt;
                }
            }
            throw new RuntimeException("Unexpected op: " + String.valueOf(op));
        }
        CifBddBitVector leftVector = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec);
        CifBddBitVector rightVector = CifToBddConverter.convertExpr(rhs, initial, cifBddSpec);
        Pair<CifBddBitVector<?, ?>, CifBddBitVector<?, ?>> vectors = CifBddBitVector.ensureCompatible(leftVector, rightVector);
        leftVector = (CifBddBitVector)vectors.left;
        rightVector = (CifBddBitVector)vectors.right;
        CifBddBitVector.ensureSameLength(leftVector, rightVector);
        BDD result = switch (op) {
            case BinaryOperator.LESS_THAN -> leftVector.lessThanAny(rightVector);
            case BinaryOperator.LESS_EQUAL -> leftVector.lessOrEqualAny(rightVector);
            case BinaryOperator.GREATER_THAN -> leftVector.greaterThanAny(rightVector);
            case BinaryOperator.GREATER_EQUAL -> leftVector.greaterOrEqualAny(rightVector);
            case BinaryOperator.EQUAL -> leftVector.equalToAny(rightVector);
            case BinaryOperator.UNEQUAL -> leftVector.unequalToAny(rightVector);
            default -> throw new RuntimeException("Unexpected operator: " + String.valueOf(op));
        };
        leftVector.free();
        rightVector.free();
        return result;
    }

    public static CifBddBitVector<?, ?> convertExpr(Expression expr, boolean initial, CifBddSpec cifBddSpec) {
        Object valueObj;
        CifType type = CifTypeUtils.normalizeType((CifType)expr.getType());
        Assert.check((type instanceof IntType || type instanceof EnumType ? 1 : 0) != 0);
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression discExpr = (DiscVariableExpression)expr;
            DiscVariable cifVar = discExpr.getVariable();
            int varIdx = CifToBddConverter.getDiscVarIdx(cifBddSpec.variables, cifVar);
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            return UnsignedCifBddBitVector.createFromDomain(var.domain);
        }
        if (expr instanceof InputVariableExpression) {
            InputVariableExpression inputExpr = (InputVariableExpression)expr;
            InputVariable cifVar = inputExpr.getVariable();
            int varIdx = CifToBddConverter.getInputVarIdx(cifBddSpec.variables, cifVar);
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            return UnsignedCifBddBitVector.createFromDomain(var.domain);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression algExpr = (AlgVariableExpression)expr;
            AlgVariable var = algExpr.getVariable();
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return CifToBddConverter.convertExpr(value, initial, cifBddSpec);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unaryExpr = (UnaryExpression)expr;
            switch (unaryExpr.getOperator()) {
                case PLUS: {
                    return CifToBddConverter.convertExpr(unaryExpr.getChild(), initial, cifBddSpec);
                }
                case NEGATE: {
                    TwosComplementCifBddBitVector tcChildVector;
                    CifBddBitVector<?, ?> childVector = CifToBddConverter.convertExpr(unaryExpr.getChild(), initial, cifBddSpec);
                    if (childVector instanceof UnsignedCifBddBitVector) {
                        UnsignedCifBddBitVector uVector = (UnsignedCifBddBitVector)childVector;
                        tcChildVector = TwosComplementCifBddBitVector.createFromUnsignedBitVector(uVector);
                        uVector.free();
                    } else if (childVector instanceof TwosComplementCifBddBitVector) {
                        TwosComplementCifBddBitVector tcVector;
                        tcChildVector = tcVector = (TwosComplementCifBddBitVector)childVector;
                    } else {
                        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(childVector.getClass())));
                    }
                    tcChildVector.resize(tcChildVector.length() + 1);
                    TwosComplementCifBddBitVectorAndCarry negatedVectorAndCarry = tcChildVector.negate();
                    tcChildVector.free();
                    Assert.check((boolean)negatedVectorAndCarry.carry.isZero());
                    return negatedVectorAndCarry.vector;
                }
            }
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expr;
            Expression lhs = binExpr.getLeft();
            Expression rhs = binExpr.getRight();
            switch (binExpr.getOperator()) {
                case ADDITION: {
                    CifBddBitVector leftVector = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec);
                    CifBddBitVector rightVector = CifToBddConverter.convertExpr(rhs, initial, cifBddSpec);
                    Pair<CifBddBitVector<?, ?>, CifBddBitVector<?, ?>> vectors = CifBddBitVector.ensureCompatible(leftVector, rightVector);
                    leftVector = (CifBddBitVector)vectors.left;
                    rightVector = (CifBddBitVector)vectors.right;
                    CifBddBitVector.ensureSameLength(leftVector, rightVector, 1);
                    CifBddBitVectorAndCarry<?, ?> result = leftVector.addAny(rightVector);
                    leftVector.free();
                    rightVector.free();
                    Assert.check((boolean)result.carry.isZero());
                    return result.vector;
                }
                case SUBTRACTION: {
                    TwosComplementCifBddBitVector leftVector = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec);
                    TwosComplementCifBddBitVector rightVector = CifToBddConverter.convertExpr(rhs, initial, cifBddSpec);
                    if (leftVector instanceof UnsignedCifBddBitVector) {
                        UnsignedCifBddBitVector uLeftVector = (UnsignedCifBddBitVector)((Object)leftVector);
                        leftVector = TwosComplementCifBddBitVector.createFromUnsignedBitVector(uLeftVector);
                        uLeftVector.free();
                    }
                    if (rightVector instanceof UnsignedCifBddBitVector) {
                        UnsignedCifBddBitVector uRightVector = (UnsignedCifBddBitVector)((Object)rightVector);
                        rightVector = TwosComplementCifBddBitVector.createFromUnsignedBitVector(uRightVector);
                        uRightVector.free();
                    }
                    CifBddBitVector.ensureSameLength(leftVector, rightVector, 1);
                    CifBddBitVectorAndCarry<TwosComplementCifBddBitVectorAndCarry, TwosComplementCifBddBitVectorAndCarry> result = leftVector.subtractAny(rightVector);
                    leftVector.free();
                    rightVector.free();
                    Assert.check((boolean)result.carry.isZero());
                    return result.vector;
                }
                case MODULUS: 
                case INTEGER_DIVISION: {
                    boolean isDiv;
                    Object rhsValueObj;
                    CifBddBitVector<?, ?> leftVector = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec);
                    Assert.check((boolean)CifValueUtils.hasSingleValue((Expression)rhs, (boolean)initial, (boolean)true));
                    try {
                        rhsValueObj = CifEvalUtils.eval((Expression)rhs, (boolean)initial);
                    }
                    catch (CifEvalException ex) {
                        throw new AssertionError("Precondition violation.", ex);
                    }
                    int divisor = (Integer)rhsValueObj;
                    Assert.check((divisor > 0 ? 1 : 0) != 0);
                    int lhsLen = leftVector.length();
                    CifBddBitVector<?, ?> cifBddBitVector = leftVector;
                    Objects.requireNonNull(cifBddBitVector);
                    CifBddBitVector<?, ?> cifBddBitVector2 = cifBddBitVector;
                    int n = 0;
                    int rhsLen = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnsignedCifBddBitVector.class, TwosComplementCifBddBitVector.class}, cifBddBitVector2, n)) {
                        case 0 -> {
                            UnsignedCifBddBitVector u = (UnsignedCifBddBitVector)cifBddBitVector2;
                            yield UnsignedCifBddBitVector.getMinimumLength(divisor);
                        }
                        case 1 -> {
                            TwosComplementCifBddBitVector tc = (TwosComplementCifBddBitVector)cifBddBitVector2;
                            yield TwosComplementCifBddBitVector.getMinimumLength(divisor);
                        }
                        default -> throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(leftVector.getClass())));
                    };
                    int length = Math.max(lhsLen, rhsLen);
                    boolean bl = isDiv = binExpr.getOperator() == BinaryOperator.INTEGER_DIVISION;
                    if (leftVector instanceof TwosComplementCifBddBitVector || !isDiv) {
                        ++length;
                    }
                    leftVector.resize(length);
                    Object result = isDiv ? leftVector.div(divisor) : leftVector.mod(divisor);
                    leftVector.free();
                    return result;
                }
            }
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            CifBddBitVector<?, ?> result = CifToBddConverter.convertExpr(ifExpr.getElse(), initial, cifBddSpec);
            int i = ifExpr.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifExpr = (ElifExpression)ifExpr.getElifs().get(i);
                BDD elifGuards = CifToBddConverter.convertPreds((List<Expression>)elifExpr.getGuards(), initial, cifBddSpec);
                CifBddBitVector elifThenVector = CifToBddConverter.convertExpr(elifExpr.getThen(), initial, cifBddSpec);
                Pair<CifBddBitVector<?, ?>, CifBddBitVector<?, ?>> vectors = CifBddBitVector.ensureCompatible(result, elifThenVector);
                result = (CifBddBitVector)vectors.left;
                elifThenVector = (CifBddBitVector)vectors.right;
                CifBddBitVector.ensureSameLength(result, elifThenVector);
                CifBddBitVector<?, ?> elifResult = elifThenVector.ifThenElseAny(result, elifGuards);
                elifGuards.free();
                elifThenVector.free();
                result.free();
                result = elifResult;
                --i;
            }
            BDD ifGuards = CifToBddConverter.convertPreds((List<Expression>)ifExpr.getGuards(), initial, cifBddSpec);
            CifBddBitVector ifThenVector = CifToBddConverter.convertExpr(ifExpr.getThen(), initial, cifBddSpec);
            Pair<CifBddBitVector<?, ?>, CifBddBitVector<?, ?>> vectors = CifBddBitVector.ensureCompatible(result, ifThenVector);
            result = (CifBddBitVector<?, ?>)vectors.left;
            ifThenVector = (CifBddBitVector)vectors.right;
            CifBddBitVector.ensureSameLength(result, ifThenVector);
            CifBddBitVector<?, ?> ifResult = ifThenVector.ifThenElseAny(result, ifGuards);
            ifGuards.free();
            ifThenVector.free();
            result.free();
            result = ifResult;
            return result;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            EList cases = switchExpr.getCases();
            CifBddBitVector<?, ?> result = CifToBddConverter.convertExpr(((SwitchCase)Lists.last((List)cases)).getValue(), initial, cifBddSpec);
            int i = cases.size() - 2;
            while (i >= 0) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                Expression caseGuardExpr = CifTypeUtils.isAutRefExpr((Expression)value) ? cse.getKey() : CifConstructors.newBinaryExpression((Expression)((Expression)EMFHelper.deepclone((EObject)value)), (BinaryOperator)BinaryOperator.EQUAL, null, (Expression)((Expression)EMFHelper.deepclone((EObject)cse.getKey())), (CifType)CifConstructors.newBoolType());
                BDD caseGuard = CifToBddConverter.convertPred(caseGuardExpr, initial, cifBddSpec);
                CifBddBitVector caseValueVector = CifToBddConverter.convertExpr(cse.getValue(), initial, cifBddSpec);
                Pair<CifBddBitVector<?, ?>, CifBddBitVector<?, ?>> vectors = CifBddBitVector.ensureCompatible(result, caseValueVector);
                result = (CifBddBitVector<?, ?>)vectors.left;
                caseValueVector = (CifBddBitVector)vectors.right;
                CifBddBitVector.ensureSameLength(result, caseValueVector);
                CifBddBitVector<?, ?> caseResult = caseValueVector.ifThenElseAny(result, caseGuard);
                caseGuard.free();
                caseValueVector.free();
                result.free();
                result = caseResult;
                --i;
            }
            return result;
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)expr, (boolean)initial);
        }
        catch (CifEvalException ex) {
            throw new AssertionError("Precondition violation.", ex);
        }
        if (valueObj instanceof Integer) {
            Integer value = (Integer)valueObj;
            if (value < 0) {
                return TwosComplementCifBddBitVector.createFromInt(cifBddSpec.factory, value);
            }
            return UnsignedCifBddBitVector.createFromInt(cifBddSpec.factory, value);
        }
        Assert.check((boolean)(valueObj instanceof CifEnumLiteral));
        EnumLiteral lit = ((CifEnumLiteral)valueObj).literal;
        EnumDecl enumDecl = (EnumDecl)lit.eContainer();
        int litIdx = enumDecl.getLiterals().indexOf((Object)lit);
        return UnsignedCifBddBitVector.createFromInt(cifBddSpec.factory, litIdx);
    }

    public static void collectEvents(ComplexComponent comp, List<Event> events) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            events.add((Event)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToBddConverter.collectEvents((ComplexComponent)child, events);
            }
        }
    }

    private static void collectAutomata(ComplexComponent comp, List<Automaton> automata) {
        if (comp instanceof Automaton) {
            automata.add((Automaton)comp);
        } else {
            for (Component child : ((Group)comp).getComponents()) {
                CifToBddConverter.collectAutomata((ComplexComponent)child, automata);
            }
        }
    }

    private static void collectVariableObjects(ComplexComponent comp, List<PositionObject> objs) {
        Automaton aut;
        if (comp instanceof Automaton && (aut = (Automaton)comp).getLocations().size() > 1) {
            objs.add((PositionObject)aut);
        }
        for (Declaration decl : comp.getDeclarations()) {
            if (decl instanceof DiscVariable) {
                objs.add((PositionObject)decl);
            }
            if (!(decl instanceof InputVariable)) continue;
            objs.add((PositionObject)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToBddConverter.collectVariableObjects((ComplexComponent)child, objs);
            }
        }
    }

    public static int getDiscVarIdx(CifBddVariable[] vars, DiscVariable var) {
        Assert.check((var.getType() != null ? 1 : 0) != 0);
        return CifToBddConverter.getTypedVarIdx(vars, (Declaration)var);
    }

    public static int getInputVarIdx(CifBddVariable[] vars, InputVariable var) {
        return CifToBddConverter.getTypedVarIdx(vars, (Declaration)var);
    }

    public static int getTypedVarIdx(CifBddVariable[] vars, Declaration var) {
        int i = 0;
        while (i < vars.length) {
            CifBddVariable cifBddVar = vars[i];
            if (cifBddVar instanceof CifBddTypedVariable) {
                CifBddTypedVariable cifBddVarTypedVar = (CifBddTypedVariable)cifBddVar;
                if (cifBddVarTypedVar.obj == var) {
                    return i;
                }
            }
            ++i;
        }
        throw new AssertionError((Object)("Unexpected variable: " + String.valueOf(var)));
    }

    public static int getLpVarIdx(CifBddVariable[] vars, Automaton aut) {
        int i = 0;
        while (i < vars.length) {
            CifBddVariable cifBddVar = vars[i];
            if (cifBddVar instanceof CifBddLocPtrVariable) {
                CifBddLocPtrVariable cifBddLpVar = (CifBddLocPtrVariable)cifBddVar;
                if (cifBddLpVar.aut == aut) {
                    return i;
                }
            }
            ++i;
        }
        Assert.areEqual((Object)aut.getLocations().size(), (Object)1);
        return -1;
    }
}

