/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import java.util.Arrays;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.CifBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.TwosComplementCifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedCifBddBitVector;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;

public abstract class CifBddBitVector<T extends CifBddBitVector<T, TC>, TC extends CifBddBitVectorAndCarry<T, TC>> {
    protected BDDFactory factory;
    protected BDD[] bits;

    protected CifBddBitVector(BDDFactory factory, int length) {
        if (length < this.getMinimumLength()) {
            throw new IllegalArgumentException(Strings.fmt((String)"Length is less than %d.", (Object[])new Object[]{this.getMinimumLength()}));
        }
        this.factory = factory;
        this.bits = new BDD[length];
    }

    protected abstract int getMinimumLength();

    protected abstract T createEmpty(int var1);

    public T copy() {
        T vector = this.createEmpty(this.bits.length);
        int i = 0;
        while (i < this.bits.length) {
            ((CifBddBitVector)vector).bits[i] = this.bits[i].id();
            ++i;
        }
        return vector;
    }

    public void replaceBy(T other) {
        this.free();
        this.factory = ((CifBddBitVector)other).factory;
        this.bits = ((CifBddBitVector)other).bits;
        ((CifBddBitVector)other).factory = null;
        ((CifBddBitVector)other).bits = null;
    }

    public static Pair<CifBddBitVector<?, ?>, CifBddBitVector<?, ?>> ensureCompatible(CifBddBitVector<?, ?> vector1, CifBddBitVector<?, ?> vector2) {
        if (vector1 instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uVector1 = (UnsignedCifBddBitVector)vector1;
            if (vector2 instanceof UnsignedCifBddBitVector) {
                return Pair.pair(vector1, vector2);
            }
            Assert.check((boolean)(vector2 instanceof TwosComplementCifBddBitVector));
            TwosComplementCifBddBitVector tcVector1 = TwosComplementCifBddBitVector.createFromUnsignedBitVector(uVector1);
            uVector1.free();
            return Pair.pair((Object)tcVector1, vector2);
        }
        Assert.check((boolean)(vector1 instanceof TwosComplementCifBddBitVector));
        if (vector2 instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uVector2 = (UnsignedCifBddBitVector)vector2;
            TwosComplementCifBddBitVector tcVector2 = TwosComplementCifBddBitVector.createFromUnsignedBitVector(uVector2);
            uVector2.free();
            return Pair.pair(vector1, (Object)tcVector2);
        }
        Assert.check((boolean)(vector2 instanceof TwosComplementCifBddBitVector));
        return Pair.pair(vector1, vector2);
    }

    public static void ensureSameLength(CifBddBitVector<?, ?> vector1, CifBddBitVector<?, ?> vector2) {
        CifBddBitVector.ensureSameLength(vector1, vector2, 0);
    }

    public static void ensureSameLength(CifBddBitVector<?, ?> vector1, CifBddBitVector<?, ?> vector2, int extraBits) {
        if (extraBits < 0) {
            throw new IllegalArgumentException("The number of extra bits is negative.");
        }
        int length = Math.max(vector1.length(), vector2.length());
        vector1.resize(length += extraBits);
        vector2.resize(length);
    }

    public int length() {
        return this.bits.length;
    }

    int countInt() {
        if (this.bits.length > 30) {
            throw new IllegalStateException("More than 30 bits in vector.");
        }
        return 1 << this.bits.length;
    }

    long countLong() {
        if (this.bits.length > 62) {
            throw new IllegalStateException("More than 62 bits in vector.");
        }
        return 1L << this.bits.length;
    }

    public BDD getBit(int index) {
        return this.bits[index];
    }

    public abstract Integer getInt();

    public abstract Long getLong();

    public void setBit(int idx, BDD bdd) {
        this.bits[idx].free();
        this.bits[idx] = bdd;
    }

    public void setBit(int idx, boolean value) {
        this.setBit(idx, value ? this.factory.one() : this.factory.zero());
    }

    public void setBitsToValue(boolean value) {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = value ? this.factory.one() : this.factory.zero();
            ++i;
        }
    }

    public abstract void setInt(int var1);

    public abstract void setDomain(BDDDomain var1);

    public abstract void resize(int var1);

    public abstract TC negate();

    public abstract TC abs();

    public abstract TC add(T var1);

    public CifBddBitVectorAndCarry<?, ?> addAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.add((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.add((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract TC subtract(T var1);

    public CifBddBitVectorAndCarry<?, ?> subtractAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.subtract((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.subtract((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract T div(int var1);

    public abstract T mod(int var1);

    public T shiftLeft(int amount, BDD carry) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount is negative.");
        }
        T result = this.createEmpty(this.bits.length);
        int numberOfCarryBits = Math.min(this.bits.length, amount);
        int i = 0;
        while (i < numberOfCarryBits) {
            ((CifBddBitVector)result).bits[i] = carry.id();
            ++i;
        }
        while (i < this.bits.length) {
            ((CifBddBitVector)result).bits[i] = this.bits[i - amount].id();
            ++i;
        }
        return result;
    }

    public T shiftRight(int amount, BDD carry) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount is negative.");
        }
        T result = this.createEmpty(this.bits.length);
        int numberOfPreservedBits = Math.max(0, this.bits.length - amount);
        int i = 0;
        while (i < numberOfPreservedBits) {
            ((CifBddBitVector)result).bits[i] = this.bits[i + amount].id();
            ++i;
        }
        while (i < this.bits.length) {
            ((CifBddBitVector)result).bits[i] = carry.id();
            ++i;
        }
        return result;
    }

    public T ifThenElse(T elseVector, BDD condition) {
        if (this.bits.length != ((CifBddBitVector)elseVector).bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        T rslt = this.createEmpty(this.bits.length);
        int i = 0;
        while (i < this.bits.length) {
            ((CifBddBitVector)rslt).bits[i] = condition.ite(this.getBit(i), ((CifBddBitVector)elseVector).getBit(i));
            ++i;
        }
        return rslt;
    }

    public CifBddBitVector<?, ?> ifThenElseAny(CifBddBitVector<?, ?> elseVector, BDD condition) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.ifThenElse((UnsignedCifBddBitVector)elseVector, condition);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.ifThenElse((TwosComplementCifBddBitVector)elseVector, condition);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract BDD lessThan(T var1);

    public BDD lessThanAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.lessThan((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.lessThan((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract BDD lessOrEqual(T var1);

    public BDD lessOrEqualAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.lessOrEqual((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.lessOrEqual((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD greaterThan(T other) {
        BDD le = this.lessOrEqual(other);
        BDD gt = le.not();
        le.free();
        return gt;
    }

    public BDD greaterThanAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.greaterThan((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.greaterThan((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD greaterOrEqual(T other) {
        BDD lt = this.lessThan(other);
        BDD ge = lt.not();
        lt.free();
        return ge;
    }

    public BDD greaterOrEqualAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.greaterOrEqual((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.greaterOrEqual((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD equalTo(T other) {
        if (this.bits.length != ((CifBddBitVector)other).bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD eq = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD bit = this.bits[i].biimp(((CifBddBitVector)other).bits[i]);
            eq = eq.andWith(bit);
            ++i;
        }
        return eq;
    }

    public BDD equalToAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.equalTo((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.equalTo((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD unequalTo(T other) {
        BDD eq = this.equalTo(other);
        BDD uneq = eq.not();
        eq.free();
        return uneq;
    }

    public BDD unequalToAny(CifBddBitVector<?, ?> other) {
        CifBddBitVector cifBddBitVector = this;
        if (cifBddBitVector instanceof UnsignedCifBddBitVector) {
            UnsignedCifBddBitVector uThis = (UnsignedCifBddBitVector)cifBddBitVector;
            return uThis.unequalTo((UnsignedCifBddBitVector)other);
        }
        CifBddBitVector cifBddBitVector2 = this;
        if (cifBddBitVector2 instanceof TwosComplementCifBddBitVector) {
            TwosComplementCifBddBitVector tcThis = (TwosComplementCifBddBitVector)cifBddBitVector2;
            return tcThis.unequalTo((TwosComplementCifBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public void free() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.factory = null;
        this.bits = null;
    }

    public String toString() {
        if (this.bits == null) {
            return "freed";
        }
        return Arrays.toString(this.bits);
    }
}

