/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.CifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.TwosComplementCifBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedCifBddBitVector;
import org.eclipse.escet.common.java.Assert;

public class TwosComplementCifBddBitVector
extends CifBddBitVector<TwosComplementCifBddBitVector, TwosComplementCifBddBitVectorAndCarry> {
    public static final int MINIMUM_LENGTH = 2;

    private TwosComplementCifBddBitVector(BDDFactory factory, int length) {
        super(factory, length);
    }

    @Override
    protected int getMinimumLength() {
        return 2;
    }

    public static int getMinimumLength(int value) {
        if (value >= 0) {
            return Math.max(2, 1 + UnsignedCifBddBitVector.getMinimumLength(value));
        }
        return Math.max(2, 1 + UnsignedCifBddBitVector.getMinimumLength(-(value + 1)));
    }

    @Override
    protected TwosComplementCifBddBitVector createEmpty(int length) {
        return new TwosComplementCifBddBitVector(this.factory, length);
    }

    public static TwosComplementCifBddBitVector create(BDDFactory factory, int length) {
        return TwosComplementCifBddBitVector.create(factory, length, false);
    }

    public static TwosComplementCifBddBitVector create(BDDFactory factory, int length, boolean value) {
        TwosComplementCifBddBitVector vector = new TwosComplementCifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = value ? factory.one() : factory.zero();
            ++i;
        }
        return vector;
    }

    public static TwosComplementCifBddBitVector createFromInt(BDDFactory factory, int value) {
        int length = TwosComplementCifBddBitVector.getMinimumLength(value);
        return TwosComplementCifBddBitVector.createFromInt(factory, length, value);
    }

    public static TwosComplementCifBddBitVector createFromInt(BDDFactory factory, int length, int value) {
        if (length < TwosComplementCifBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        TwosComplementCifBddBitVector vector = new TwosComplementCifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = (value & 1) != 0 ? factory.one() : factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.check((value == 0 || value == -1 ? 1 : 0) != 0, (Object)value);
        return vector;
    }

    public static TwosComplementCifBddBitVector createFromDomain(BDDDomain domain) {
        int varCnt = domain.varNum();
        if (varCnt == 0) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        int length = varCnt + 1;
        TwosComplementCifBddBitVector vector = new TwosComplementCifBddBitVector(domain.getFactory(), length);
        int[] vars = domain.vars();
        int i = 0;
        while (i < vars.length) {
            vector.bits[i] = vector.factory.ithVar(vars[i]);
            ++i;
        }
        vector.bits[length - 1] = vector.factory.zero();
        return vector;
    }

    public static TwosComplementCifBddBitVector createFromUnsignedBitVector(UnsignedCifBddBitVector unsignedVector) {
        TwosComplementCifBddBitVector twosComplementVector = new TwosComplementCifBddBitVector(unsignedVector.factory, unsignedVector.length() + 1);
        int i = 0;
        while (i < unsignedVector.length()) {
            twosComplementVector.bits[i] = unsignedVector.getBit(i).id();
            ++i;
        }
        twosComplementVector.bits[twosComplementVector.bits.length - 1] = twosComplementVector.factory.zero();
        return twosComplementVector;
    }

    @Override
    public Integer getInt() {
        if (this.bits.length > 32) {
            throw new IllegalStateException("More than 32 bits in vector.");
        }
        Long value = this.getLong();
        return value == null ? null : Integer.valueOf((int)value.longValue());
    }

    @Override
    public Long getLong() {
        long value;
        if (this.bits.length > 64) {
            throw new IllegalStateException("More than 64 bits in vector.");
        }
        int bitIndex = this.bits.length - 1;
        if (this.bits[bitIndex].isOne()) {
            value = -1L;
        } else if (this.bits[bitIndex].isZero()) {
            value = 0L;
        } else {
            return null;
        }
        --bitIndex;
        while (bitIndex >= 0) {
            if (this.bits[bitIndex].isOne()) {
                value = value << 1 | 1L;
            } else if (this.bits[bitIndex].isZero()) {
                value <<= 1;
            } else {
                return null;
            }
            --bitIndex;
        }
        return value;
    }

    @Override
    public void setInt(int value) {
        if (this.bits.length < TwosComplementCifBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = (value & 1) != 0 ? this.factory.one() : this.factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.check((value == 0 || value == -1 ? 1 : 0) != 0, (Object)value);
    }

    @Override
    public void setDomain(BDDDomain domain) {
        int varCnt = domain.varNum();
        if (varCnt == 0) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        if (varCnt > this.bits.length - 1) {
            throw new IllegalArgumentException("Domain doesn't fit.");
        }
        int[] vars = domain.vars();
        Assert.areEqual((Object)varCnt, (Object)vars.length);
        int i = 0;
        while (i < varCnt) {
            this.bits[i].free();
            this.bits[i] = this.factory.ithVar(vars[i]);
            ++i;
        }
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = this.factory.zero();
            ++i;
        }
    }

    @Override
    public void resize(int length) {
        if (length == this.bits.length) {
            return;
        }
        if (length < 2) {
            throw new IllegalArgumentException("Length is less than two.");
        }
        BDD[] newBits = new BDD[length];
        int numberOfCommonBits = Math.min(this.bits.length, length);
        System.arraycopy(this.bits, 0, newBits, 0, numberOfCommonBits);
        BDD signBit = this.bits[this.bits.length - 1];
        int i = numberOfCommonBits;
        while (i < length) {
            newBits[i] = signBit.id();
            ++i;
        }
        i = numberOfCommonBits;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.bits = newBits;
    }

    @Override
    public TwosComplementCifBddBitVectorAndCarry negate() {
        TwosComplementCifBddBitVector rslt = new TwosComplementCifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.one();
        BDD lastCarry = this.factory.zero();
        BDD beforeLastCarry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD notThisI = this.bits[i].not();
            rslt.bits[i] = notThisI.id().xorWith(carry.id());
            carry = carry.andWith(notThisI);
            if (i == this.bits.length - 1) {
                lastCarry = carry.id();
            } else if (i == this.bits.length - 2) {
                beforeLastCarry = carry.id();
            }
            ++i;
        }
        carry.free();
        carry = beforeLastCarry.xorWith(lastCarry);
        return new TwosComplementCifBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public TwosComplementCifBddBitVectorAndCarry abs() {
        BDD cmp = this.bits[this.bits.length - 1];
        TwosComplementCifBddBitVectorAndCarry negated = this.negate();
        BDD overflow = negated.carry;
        TwosComplementCifBddBitVector resultVector = ((TwosComplementCifBddBitVector)negated.vector).ifThenElse(this, cmp);
        ((TwosComplementCifBddBitVector)negated.vector).free();
        return new TwosComplementCifBddBitVectorAndCarry(resultVector, overflow);
    }

    @Override
    public TwosComplementCifBddBitVectorAndCarry add(TwosComplementCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        TwosComplementCifBddBitVector rslt = new TwosComplementCifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        BDD lastCarry = this.factory.zero();
        BDD beforeLastCarry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            carry = this.bits[i].and(other.bits[i]).orWith(carry.andWith(this.bits[i].or(other.bits[i])));
            if (i == this.bits.length - 1) {
                lastCarry = carry.id();
            } else if (i == this.bits.length - 2) {
                beforeLastCarry = carry.id();
            }
            ++i;
        }
        carry.free();
        carry = beforeLastCarry.xorWith(lastCarry);
        return new TwosComplementCifBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public TwosComplementCifBddBitVectorAndCarry subtract(TwosComplementCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        TwosComplementCifBddBitVector rslt = new TwosComplementCifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        BDD lastCarry = this.factory.zero();
        BDD beforeLastCarry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            BDD tmp1 = other.bits[i].or(carry);
            BDD tmp2 = this.bits[i].apply(tmp1, BDDFactory.less);
            tmp1.free();
            carry = this.bits[i].and(other.bits[i]).andWith(carry).orWith(tmp2);
            if (i == this.bits.length - 1) {
                lastCarry = carry.id();
            } else if (i == this.bits.length - 2) {
                beforeLastCarry = carry.id();
            }
            ++i;
        }
        carry.free();
        carry = beforeLastCarry.xorWith(lastCarry);
        return new TwosComplementCifBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public TwosComplementCifBddBitVector div(int divisor) {
        return this.divmod(divisor, true);
    }

    @Override
    public TwosComplementCifBddBitVector mod(int divisor) {
        return this.divmod(divisor, false);
    }

    private TwosComplementCifBddBitVector divmod(int divisor, boolean isDiv) {
        TwosComplementCifBddBitVectorAndCarry absThis = this.abs();
        absThis.carry.free();
        TwosComplementCifBddBitVector resultUnsigned = ((TwosComplementCifBddBitVector)absThis.vector).divmodUnsigned(divisor, isDiv);
        ((TwosComplementCifBddBitVector)absThis.vector).free();
        BDD signBit = this.bits[this.bits.length - 1];
        TwosComplementCifBddBitVectorAndCarry resultUnsignedNeg = resultUnsigned.negate();
        TwosComplementCifBddBitVector resultSigned = ((TwosComplementCifBddBitVector)resultUnsignedNeg.vector).ifThenElse(resultUnsigned, signBit);
        resultUnsigned.free();
        ((TwosComplementCifBddBitVector)resultUnsignedNeg.vector).free();
        resultUnsignedNeg.carry.free();
        return resultSigned;
    }

    private TwosComplementCifBddBitVector divmodUnsigned(int divisorValue, boolean isDiv) {
        if (divisorValue <= 0) {
            throw new IllegalArgumentException("Divisor is not positive.");
        }
        if (this.bits.length < TwosComplementCifBddBitVector.getMinimumLength(divisorValue)) {
            throw new IllegalArgumentException("Divisor doesn't fit.");
        }
        TwosComplementCifBddBitVector divisor = TwosComplementCifBddBitVector.createFromInt(this.factory, this.bits.length, divisorValue);
        if (!(!isDiv || this.bits[this.bits.length - 1].isZero() || divisor.bits[divisor.length() - 1].isZero() && divisor.bits[divisor.length() - 2].isZero())) {
            throw new IllegalArgumentException("Computing the quotient/'div', the highest bit of the dividend's absolute value is not 'false', and the highest two bits of the divisor are not both 'false'.");
        }
        if (!isDiv && !this.bits[this.bits.length - 1].isZero()) {
            throw new IllegalStateException("Computing the remainder/'mod', and the highest bit of the dividend's absolute value is not 'false'.");
        }
        TwosComplementCifBddBitVector quotient = (TwosComplementCifBddBitVector)this.shiftLeft(1, this.factory.zero());
        TwosComplementCifBddBitVector remainderZero = TwosComplementCifBddBitVector.create(this.factory, this.bits.length);
        TwosComplementCifBddBitVector remainder = (TwosComplementCifBddBitVector)remainderZero.shiftLeft(1, this.bits[this.bits.length - 1]);
        remainderZero.free();
        this.divModUnsignedRecursive(divisor, quotient, remainder, this.bits.length);
        divisor.free();
        if (isDiv) {
            remainder.free();
            return quotient;
        }
        quotient.free();
        TwosComplementCifBddBitVector shiftedRemainder = (TwosComplementCifBddBitVector)remainder.shiftRight(1, this.factory.zero());
        remainder.free();
        return shiftedRemainder;
    }

    private void divModUnsignedRecursive(TwosComplementCifBddBitVector divisor, TwosComplementCifBddBitVector quotient, TwosComplementCifBddBitVector remainder, int step) {
        int divLen = divisor.bits.length;
        BDD isSmaller = divisor.lessOrEqual(remainder);
        TwosComplementCifBddBitVector newQuotient = (TwosComplementCifBddBitVector)quotient.shiftLeft(1, isSmaller);
        TwosComplementCifBddBitVector sub = TwosComplementCifBddBitVector.create(this.factory, divLen);
        int i = 0;
        while (i < divLen) {
            sub.bits[i] = isSmaller.ite(divisor.bits[i], this.factory.zero());
            ++i;
        }
        TwosComplementCifBddBitVectorAndCarry tmp = remainder.subtract(sub);
        TwosComplementCifBddBitVector newRemainder = (TwosComplementCifBddBitVector)((TwosComplementCifBddBitVector)tmp.vector).shiftLeft(1, quotient.bits[divLen - 1]);
        if (step > 1) {
            this.divModUnsignedRecursive(divisor, newQuotient, newRemainder, step - 1);
        }
        ((TwosComplementCifBddBitVector)tmp.vector).free();
        tmp.carry.free();
        sub.free();
        isSmaller.free();
        quotient.replaceBy(newQuotient);
        remainder.replaceBy(newRemainder);
    }

    @Override
    public BDD lessThan(TwosComplementCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            carry = lt.orWith(eq.andWith(carry));
            ++i;
        }
        BDD thisSignBit = this.bits[this.bits.length - 1];
        BDD otherSignBit = other.bits[other.bits.length - 1];
        BDD lhs = thisSignBit.id().andWith(otherSignBit.not());
        BDD rhs = thisSignBit.id().orWith(otherSignBit.not()).andWith(carry);
        return lhs.orWith(rhs);
    }

    @Override
    public BDD lessOrEqual(TwosComplementCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD carry = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            carry = lt.orWith(eq.andWith(carry));
            ++i;
        }
        BDD thisSignBit = this.bits[this.bits.length - 1];
        BDD otherSignBit = other.bits[other.bits.length - 1];
        BDD lhs = thisSignBit.id().andWith(otherSignBit.not());
        BDD rhs = thisSignBit.id().orWith(otherSignBit.not()).andWith(carry);
        return lhs.orWith(rhs);
    }
}

