/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.settings;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.bdd.settings.BddHyperEdgeAlgo;
import org.eclipse.escet.cif.bdd.settings.CifBddSettingsDefaults;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.settings.EdgeGranularity;
import org.eclipse.escet.cif.bdd.settings.EdgeOrderDuplicateEventAllowance;
import org.eclipse.escet.cif.bdd.settings.ExplorationStrategy;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.output.BlackHoleOutputProvider;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class CifBddSettings {
    protected boolean modificationAllowed = true;
    private Termination termination = Termination.NEVER;
    private DebugNormalOutput debugOutput = new BlackHoleOutputProvider().getDebugOutput();
    private DebugNormalOutput normalOutput = new BlackHoleOutputProvider().getNormalOutput();
    private WarnOutput warnOutput = new BlackHoleOutputProvider().getWarnOutput();
    private int indentAmount = 4;
    private boolean doPlantsRefReqsWarn = true;
    private AllowNonDeterminism allowNonDeterminism = CifBddSettingsDefaults.ALLOW_NON_DETERMINISM_DEFAULT;
    private boolean adhereToExecScheme = false;
    private List<String> bddExtraVarDomainNames = CifBddSettingsDefaults.BDD_EXTRA_VAR_DOMAIN_NAMES_DEFAULT;
    private int bddInitNodeTableSize = 100000;
    private double bddOpCacheRatio = 1.0;
    private Integer bddOpCacheSize = CifBddSettingsDefaults.BDD_OP_CACHE_SIZE_DEFAULT;
    private String bddVarOrderInit = "sorted";
    private boolean bddDcshEnabled = true;
    private boolean bddForceEnabled = true;
    private boolean bddSlidingWindowEnabled = true;
    private int bddSlidingWindowMaxLen = 4;
    private String bddVarOrderAdvanced = "basic";
    private BddHyperEdgeAlgo bddHyperEdgeAlgo = CifBddSettingsDefaults.HYPER_EDGE_ALGO_DEFAULT;
    private Integer bddDebugMaxNodes = CifBddSettingsDefaults.BDD_DEBUG_MAX_NODES_DEFAULT;
    private BigInteger bddDebugMaxPaths = CifBddSettingsDefaults.BDD_DEBUG_MAX_PATHS_DEFAULT;
    private EdgeGranularity edgeGranularity = CifBddSettingsDefaults.EDGE_GRANULARITY_DEFAULT;
    private String edgeOrderBackward = "model";
    private String edgeOrderForward = "model";
    private EdgeOrderDuplicateEventAllowance edgeOrderAllowDuplicateEvents = CifBddSettingsDefaults.EDGE_ORDER_ALLOW_DUPLICATES_EVENTS_DEFAULT;
    private ExplorationStrategy explorationStrategy = CifBddSettingsDefaults.EXPLORATION_STRATEGY_DEFAULT;
    private EnumSet<CifBddStatistics> cifBddStatistics = CifBddSettingsDefaults.CIF_BDD_STATISTICS_DEFAULT.clone();

    public CifBddSettings() {
        this.checkSettings();
    }

    public boolean getModificationAllowed() {
        return this.modificationAllowed;
    }

    public void setModificationAllowed(boolean modificationAllowed) {
        this.modificationAllowed = modificationAllowed;
    }

    public Termination getTermination() {
        return this.termination;
    }

    public void setTermination(Termination termination) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.termination = termination;
        this.checkSettings();
    }

    public DebugNormalOutput getDebugOutput() {
        return this.debugOutput;
    }

    public void setDebugOutput(DebugNormalOutput debugOutput) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.debugOutput = debugOutput;
        this.checkSettings();
    }

    public DebugNormalOutput getNormalOutput() {
        return this.normalOutput;
    }

    public void setNormalOutput(DebugNormalOutput normalOutput) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.normalOutput = normalOutput;
        this.checkSettings();
    }

    public WarnOutput getWarnOutput() {
        return this.warnOutput;
    }

    public void setWarnOutput(WarnOutput warnOutput) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.warnOutput = warnOutput;
        this.checkSettings();
    }

    public int getIndentAmount() {
        return this.indentAmount;
    }

    public void setIndentAmount(int indentAmount) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.indentAmount = indentAmount;
        this.checkSettings();
    }

    public boolean getDoPlantsRefReqsWarn() {
        return this.doPlantsRefReqsWarn;
    }

    public void setDoPlantsRefReqsWarn(boolean doPlantsRefReqsWarn) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.doPlantsRefReqsWarn = doPlantsRefReqsWarn;
        this.checkSettings();
    }

    public AllowNonDeterminism getAllowNonDeterminism() {
        return this.allowNonDeterminism;
    }

    public void setAllowNonDeterminism(AllowNonDeterminism allowNonDeterminism) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.allowNonDeterminism = allowNonDeterminism;
        this.checkSettings();
    }

    public boolean getAdhereToExecScheme() {
        return this.adhereToExecScheme;
    }

    public void setAdhereToExecScheme(boolean adhereToExecScheme) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.adhereToExecScheme = adhereToExecScheme;
        this.checkSettings();
    }

    public List<String> getBddExtraVarDomainNames() {
        return this.bddExtraVarDomainNames;
    }

    public void setBddExtraVarDomainNames(String ... bddExtraVarDomainNames) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddExtraVarDomainNames = Collections.unmodifiableList(Arrays.asList(bddExtraVarDomainNames));
        this.checkSettings();
    }

    public int getBddInitNodeTableSize() {
        return this.bddInitNodeTableSize;
    }

    public void setBddInitNodeTableSize(int bddInitNodeTableSize) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddInitNodeTableSize = bddInitNodeTableSize;
        this.checkSettings();
    }

    public double getBddOpCacheRatio() {
        return this.bddOpCacheRatio;
    }

    public void setBddOpCacheRatio(double bddOpCacheRatio) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddOpCacheRatio = bddOpCacheRatio;
        this.checkSettings();
    }

    public Integer getBddOpCacheSize() {
        return this.bddOpCacheSize;
    }

    public void setBddOpCacheSize(Integer bddOpCacheSize) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddOpCacheSize = bddOpCacheSize;
        this.checkSettings();
    }

    public String getBddVarOrderInit() {
        return this.bddVarOrderInit;
    }

    public void setBddVarOrderInit(String bddVarOrderInit) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddVarOrderInit = bddVarOrderInit;
        this.checkSettings();
    }

    public boolean getBddDcshEnabled() {
        return this.bddDcshEnabled;
    }

    public void setBddDcshEnabled(boolean bddDcshEnabled) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddDcshEnabled = bddDcshEnabled;
        this.checkSettings();
    }

    public boolean getBddForceEnabled() {
        return this.bddForceEnabled;
    }

    public void setBddForceEnabled(boolean bddForceEnabled) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddForceEnabled = bddForceEnabled;
        this.checkSettings();
    }

    public boolean getBddSlidingWindowEnabled() {
        return this.bddSlidingWindowEnabled;
    }

    public void setBddSlidingWindowEnabled(boolean bddSlidingWindowEnabled) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddSlidingWindowEnabled = bddSlidingWindowEnabled;
        this.checkSettings();
    }

    public int getBddSlidingWindowMaxLen() {
        return this.bddSlidingWindowMaxLen;
    }

    public void setBddSlidingWindowMaxLen(int bddSlidingWindowMaxLen) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddSlidingWindowMaxLen = bddSlidingWindowMaxLen;
        this.checkSettings();
    }

    public String getBddVarOrderAdvanced() {
        return this.bddVarOrderAdvanced;
    }

    public void setBddVarOrderAdvanced(String bddVarOrderAdvanced) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddVarOrderAdvanced = bddVarOrderAdvanced;
        this.checkSettings();
    }

    public BddHyperEdgeAlgo getBddHyperEdgeAlgo() {
        return this.bddHyperEdgeAlgo;
    }

    public void setBddHyperEdgeAlgo(BddHyperEdgeAlgo bddHyperEdgeAlgo) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddHyperEdgeAlgo = bddHyperEdgeAlgo;
        this.checkSettings();
    }

    public Integer getBddDebugMaxNodes() {
        return this.bddDebugMaxNodes;
    }

    public void setBddDebugMaxNodes(Integer bddDebugMaxNodes) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddDebugMaxNodes = bddDebugMaxNodes;
        this.checkSettings();
    }

    public BigInteger getBddDebugMaxPaths() {
        return this.bddDebugMaxPaths;
    }

    public void setBddDebugMaxPaths(BigInteger bddDebugMaxPaths) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.bddDebugMaxPaths = bddDebugMaxPaths;
        this.checkSettings();
    }

    public EdgeGranularity getEdgeGranularity() {
        return this.edgeGranularity;
    }

    public void setEdgeGranularity(EdgeGranularity edgeGranularity) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.edgeGranularity = edgeGranularity;
        this.checkSettings();
    }

    public String getEdgeOrderBackward() {
        return this.edgeOrderBackward;
    }

    public void setEdgeOrderBackward(String edgeOrderBackward) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.edgeOrderBackward = edgeOrderBackward;
        this.checkSettings();
    }

    public String getEdgeOrderForward() {
        return this.edgeOrderForward;
    }

    public void setEdgeOrderForward(String edgeOrderForward) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.edgeOrderForward = edgeOrderForward;
        this.checkSettings();
    }

    public EdgeOrderDuplicateEventAllowance getEdgeOrderAllowDuplicateEvents() {
        return this.edgeOrderAllowDuplicateEvents;
    }

    public void setEdgeOrderAllowDuplicateEvents(EdgeOrderDuplicateEventAllowance edgeOrderAllowDuplicateEvents) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.edgeOrderAllowDuplicateEvents = edgeOrderAllowDuplicateEvents;
        this.checkSettings();
    }

    public ExplorationStrategy getExplorationStrategy() {
        return this.explorationStrategy;
    }

    public void setExplorationStrategy(ExplorationStrategy explorationStrategy) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.explorationStrategy = explorationStrategy;
        this.checkSettings();
    }

    public EnumSet<CifBddStatistics> getCifBddStatistics() {
        return this.cifBddStatistics;
    }

    public void setCifBddStatistics(EnumSet<CifBddStatistics> cifBddStatistics) {
        Assert.check((boolean)this.modificationAllowed, (Object)"Modification is not allowed.");
        this.cifBddStatistics = cifBddStatistics;
        this.checkSettings();
    }

    private void checkSettings() {
        if (this.adhereToExecScheme) {
            if (this.edgeGranularity != EdgeGranularity.PER_EDGE) {
                String msg = Strings.fmt((String)"Since adherence to the execution scheme prescribed by the controller properties checker is enabled, the edge granularity must be set to 'per-edge' granularity.", (Object[])new Object[0]);
                throw new InvalidOptionException(msg);
            }
            if (!this.edgeOrderForward.equals("sorted")) {
                String msg = Strings.fmt((String)"Since adherence to the execution scheme prescribed by the controller properties checker is enabled, the forward edge order must be set to \"sorted\" order.", (Object[])new Object[0]);
                throw new InvalidOptionException(msg);
            }
        }
        if (this.indentAmount < 0) {
            String msg = Strings.fmt((String)"The amount of spaces to use for identation \"%d\" is negative.", (Object[])new Object[]{this.indentAmount});
            throw new InvalidOptionException(msg);
        }
        if (this.bddDebugMaxNodes != null && this.bddDebugMaxNodes < 0) {
            String msg = Strings.fmt((String)"BDD debug max nodes value \"%s\" is not in the range [0 .. 2^31-1].", (Object[])new Object[]{this.bddDebugMaxNodes});
            throw new InvalidOptionException(msg);
        }
        if (this.bddDebugMaxPaths != null && this.bddDebugMaxPaths.compareTo(BigInteger.ZERO) < 0) {
            String msg = Strings.fmt((String)"BDD debug max paths value \"%s\" must not be negative.", (Object[])new Object[]{this.bddDebugMaxPaths});
            throw new InvalidOptionException(msg);
        }
        if (this.bddExtraVarDomainNames.size() % 2 != 0) {
            String msg = Strings.fmt((String)"The number of extra BDD variable domains \"%s\" is odd.", (Object[])new Object[]{this.bddExtraVarDomainNames.size()});
            throw new InvalidOptionException(msg);
        }
        if (this.bddInitNodeTableSize < 1) {
            String msg = Strings.fmt((String)"BDD library initial node table size \"%s\" is not in the range [1 .. 2^31-1].", (Object[])new Object[]{this.bddInitNodeTableSize});
            throw new InvalidOptionException(msg);
        }
        if (Double.isNaN(this.bddOpCacheRatio)) {
            throw new InvalidOptionException("BDD library operation cache ratio must not be NaN.");
        }
        if (this.bddOpCacheRatio < 0.01 || this.bddOpCacheRatio > 1000.0) {
            String msg = Strings.fmt((String)"BDD library operation cache ratio \"%s\" is not in the range [0.01 .. 1000].", (Object[])new Object[]{this.bddOpCacheRatio});
            throw new InvalidOptionException(msg);
        }
        if (this.bddOpCacheSize != null && this.bddOpCacheSize < 2) {
            String msg = Strings.fmt((String)"BDD library operation cache size \"%s\" is not in the range [2 .. 2^31-1].", (Object[])new Object[]{this.bddOpCacheSize});
            throw new InvalidOptionException(msg);
        }
        if (this.bddSlidingWindowMaxLen < 1 || this.bddSlidingWindowMaxLen > 12) {
            String msg = Strings.fmt((String)"BDD sliding window size \"%s\" is not in the range [1 .. 12].", (Object[])new Object[]{this.bddSlidingWindowMaxLen});
            throw new InvalidOptionException(msg);
        }
    }
}

