/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.utils;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.conversion.BddToCif;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedCifBddBitVector;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddTypedVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FileSizes;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class BddUtils {
    private BddUtils() {
    }

    public static BDD free(BDD bdd) {
        if (bdd != null) {
            bdd.free();
        }
        return null;
    }

    public static List<BDD> free(List<BDD> bdds) {
        if (bdds != null) {
            for (BDD bdd : bdds) {
                if (bdd == null) continue;
                bdd.free();
            }
        }
        return null;
    }

    public static <K, V> Map<K, V> free(Map<K, V> map, Function<Map.Entry<K, V>, Collection<BDD>> getBddFunc) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Collection<BDD> bdds = getBddFunc.apply(entry);
                for (BDD bdd : bdds) {
                    if (bdd == null) continue;
                    bdd.free();
                }
            }
        }
        return null;
    }

    public static BDDVarSet free(BDDVarSet varSet) {
        if (varSet != null) {
            varSet.free();
        }
        return null;
    }

    public static List<BDDVarSet> freeVarSets(List<BDDVarSet> varSets) {
        if (varSets != null) {
            for (BDDVarSet varSet : varSets) {
                if (varSet == null) continue;
                varSet.free();
            }
        }
        return null;
    }

    public static BDD getVarDomain(CifBddVariable variable, boolean newDomain, BDDFactory factory) {
        int min = variable.lower;
        int max = variable.upper;
        BDDDomain domain = newDomain ? variable.domainNew : variable.domain;
        BDD rslt = factory.zero();
        int i = min;
        while (i <= max) {
            rslt = rslt.orWith(domain.ithVar((long)i));
            ++i;
        }
        return rslt;
    }

    public static String bddToStr(BDD bdd, CifBddSpec cifBddSpec) {
        if (cifBddSpec.settings.getBddDebugMaxNodes() != null || cifBddSpec.settings.getBddDebugMaxPaths() != null) {
            boolean skip;
            int nc = bdd.nodeCount();
            BigInteger tpc = bdd.pathCount();
            boolean bl = skip = cifBddSpec.settings.getBddDebugMaxNodes() != null && nc > cifBddSpec.settings.getBddDebugMaxNodes() || cifBddSpec.settings.getBddDebugMaxPaths() != null && tpc.compareTo(cifBddSpec.settings.getBddDebugMaxPaths()) > 0;
            if (skip) {
                return Strings.fmt((String)"<bdd %,dn %,dp>", (Object[])new Object[]{nc, tpc});
            }
        }
        Expression pred = BddToCif.bddToCifPred(bdd, cifBddSpec);
        return CifTextUtils.exprToStr((Expression)pred);
    }

    public static List<Map<CifBddVariable, Object>> bddToStates(BDD bdd, CifBddSpec cifBddSpec, boolean inclDontCares, int maxStateCount) {
        BigInteger satCount = bdd.satCount(cifBddSpec.varSetOld);
        int expectedCount = satCount.min(BigInteger.valueOf(maxStateCount)).intValue();
        List states = Lists.listc((int)expectedCount);
        BDD.AllSatIterator iter = bdd.allsat();
        while (iter.hasNext()) {
            int maxStateRemaining;
            byte[] valuation = iter.next();
            List<Map<CifBddVariable, Object>> valuationStates = BddUtils.valuationToStates(valuation, cifBddSpec, inclDontCares, maxStateRemaining = maxStateCount - states.size());
            Assert.check((valuationStates.size() <= maxStateRemaining ? 1 : 0) != 0);
            states.addAll(valuationStates);
            if (states.size() == maxStateCount) break;
        }
        BddUtils.sortStates(states);
        Assert.check((states.size() <= maxStateCount ? 1 : 0) != 0);
        return states;
    }

    public static List<Map<CifBddVariable, Object>> valuationToStates(byte[] valuation, CifBddSpec cifBddSpec, boolean inclDontCares, int maxStateCount) {
        if (cifBddSpec.variables.length == 0) {
            return maxStateCount <= 0 ? List.of() : List.of(new TreeMap());
        }
        List variables = Lists.listc((int)cifBddSpec.variables.length);
        List valuesPerVar = Lists.listc((int)cifBddSpec.variables.length);
        CifBddVariable[] cifBddVariableArray = cifBddSpec.variables;
        int n = cifBddSpec.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable cifBddVar = cifBddVariableArray[n2];
            BDDDomain domain = cifBddVar.domain;
            byte[] domainValuation = new byte[domain.varNum()];
            int[] varIdxs = domain.vars();
            int i = 0;
            while (i < varIdxs.length) {
                byte bit;
                int varIdx = varIdxs[i];
                domainValuation[i] = bit = valuation[varIdx];
                ++i;
            }
            boolean anyDontCare = false;
            boolean onlyDontCare = true;
            int i2 = 0;
            while (i2 < domainValuation.length) {
                boolean bitIsDontCare = domainValuation[i2] == -1;
                anyDontCare |= bitIsDontCare;
                onlyDontCare &= bitIsDontCare;
                ++i2;
            }
            if (!onlyDontCare || inclDontCares) {
                variables.add(cifBddVar);
                if (!anyDontCare) {
                    Object value = BddUtils.valuationToValue(cifBddVar, domainValuation, cifBddSpec.factory);
                    if (value == null) {
                        return List.of();
                    }
                    valuesPerVar.add(List.of(value));
                } else {
                    List valuesPerBit = Lists.listc((int)domainValuation.length);
                    int i3 = 0;
                    while (i3 < domainValuation.length) {
                        byte bit = domainValuation[i3];
                        List<Boolean> bitValues = switch (bit) {
                            case -1 -> List.of(Boolean.valueOf(false), Boolean.valueOf(true));
                            case 0 -> List.of(Boolean.valueOf(false));
                            case 1 -> List.of(Boolean.valueOf(true));
                            default -> throw new AssertionError((Object)("Unexpected bit: " + bit));
                        };
                        valuesPerBit.add(bitValues);
                        ++i3;
                    }
                    List varValues = Lists.list();
                    ListProductIterator iter = new ListProductIterator(valuesPerBit);
                    while (iter.hasNext() && varValues.size() < maxStateCount) {
                        List nextValuation = (List)iter.next();
                        byte[] byteValuation = new byte[nextValuation.size()];
                        int i4 = 0;
                        while (i4 < byteValuation.length) {
                            byteValuation[i4] = (byte)((Boolean)nextValuation.get(i4) != false ? 1 : 0);
                            ++i4;
                        }
                        Object value = BddUtils.valuationToValue(cifBddVar, byteValuation, cifBddSpec.factory);
                        if (value == null) continue;
                        varValues.add(value);
                    }
                    valuesPerVar.add(varValues);
                }
            }
            ++n2;
        }
        ListProductIterator stateIter = new ListProductIterator(valuesPerVar);
        Optional stateCountOrOverflow = stateIter.getResultSize();
        long cappedStateCount = stateCountOrOverflow.orElse(Long.MAX_VALUE);
        int approxStateCount = (int)cappedStateCount;
        List states = Lists.listc((int)Math.min(approxStateCount, maxStateCount));
        while (stateIter.hasNext() && states.size() < maxStateCount) {
            List stateValues = stateIter.next();
            TreeMap stateMap = new TreeMap(Comparator.comparing(v -> v.name));
            int i = 0;
            while (i < stateValues.size()) {
                stateMap.put((CifBddVariable)variables.get(i), stateValues.get(i));
                ++i;
            }
            states.add(stateMap);
        }
        BddUtils.sortStates(states);
        return states;
    }

    public static Object valuationToValue(CifBddVariable cifBddVar, byte[] valuation, BDDFactory factory) {
        UnsignedCifBddBitVector vector = UnsignedCifBddBitVector.create(factory, valuation.length);
        int i = 0;
        while (i < valuation.length) {
            byte bit = valuation[i];
            Assert.check((bit == 0 || bit == 1 ? 1 : 0) != 0, (Object)bit);
            vector.setBit(i, bit == 1);
            ++i;
        }
        Integer value = vector.getInt();
        if (value == null) {
            throw new AssertionError();
        }
        if (value < cifBddVar.lower || value > cifBddVar.upper) {
            return null;
        }
        CifBddVariable cifBddVariable = cifBddVar;
        Objects.requireNonNull(cifBddVariable);
        CifBddVariable cifBddVariable2 = cifBddVariable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CifBddLocPtrVariable.class, CifBddTypedVariable.class}, (Object)cifBddVariable2, n)) {
            case 0 -> {
                CifBddLocPtrVariable lpVar = (CifBddLocPtrVariable)cifBddVariable2;
                yield lpVar.aut.getLocations().get(value.intValue());
            }
            case 1 -> {
                CifBddTypedVariable typedVar = (CifBddTypedVariable)cifBddVariable2;
                CifType v2 = typedVar.type;
                Objects.requireNonNull(v2);
                CifType var9_11 = v2;
                int var10_12 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolType.class, IntType.class, EnumType.class}, (Object)var9_11, var10_12)) {
                    case 0: {
                        BoolType btype = (BoolType)var9_11;
                        yield value == 1;
                    }
                    case 1: {
                        IntType itype = (IntType)var9_11;
                        yield value;
                    }
                    case 2: {
                        EnumType etype = (EnumType)var9_11;
                        yield etype.getEnum().getLiterals().get(value.intValue());
                    }
                }
                throw new AssertionError((Object)("Unexpected type: " + String.valueOf(typedVar.type)));
            }
            default -> throw new AssertionError((Object)("Unexpected variable: " + String.valueOf(cifBddVar)));
        };
    }

    static void sortStates(List<Map<CifBddVariable, Object>> states) {
        Collections.sort(states, BddUtils::lambda$1);
    }

    public static String stateToStr(Map<CifBddVariable, Object> state, String emptyText) {
        if (state.isEmpty()) {
            return emptyText;
        }
        return state.entrySet().stream().map(e -> ((CifBddVariable)e.getKey()).name + "=" + BddUtils.stateValueToStr(e.getValue())).collect(Collectors.joining(", "));
    }

    public static String stateValueToStr(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Location.class, Boolean.class, Integer.class, EnumLiteral.class}, (Object)object2, n)) {
            case 0 -> {
                Location loc = (Location)object2;
                yield loc.getName();
            }
            case 1 -> {
                Boolean bool = (Boolean)object2;
                if (bool.booleanValue()) {
                    yield "true";
                }
                yield "false";
            }
            case 2 -> {
                Integer i = (Integer)object2;
                yield Integer.toString(i);
            }
            case 3 -> {
                EnumLiteral lit = (EnumLiteral)object2;
                yield lit.getName();
            }
            default -> throw new AssertionError((Object)("Unexpected value: " + String.valueOf(value)));
        };
    }

    public static void printAsDot(BDD bdd, CifBddSpec cifBddSpec, Writer writer) throws IOException {
        List<String> bddVarNames = Arrays.stream(cifBddSpec.getBddVarNames()).map(n -> n.replace(".", ".\n")).toList();
        writer.write("digraph G {\n");
        writer.write("  0 [shape=box, label=\"0\", style=filled, shape=box, height=0.3, width=0.3];\n");
        writer.write("  1 [shape=box, label=\"1\", style=filled, shape=box, height=0.3, width=0.3];\n");
        boolean[] visited = new boolean[bdd.nodeCount() + 2];
        visited[0] = true;
        visited[1] = true;
        HashMap<BDD, Integer> bddToVisitedIdx = new HashMap<BDD, Integer>(visited.length);
        bddToVisitedIdx.put(bdd.getFactory().zero(), 0);
        bddToVisitedIdx.put(bdd.getFactory().one(), 1);
        int visitedNextFreeIdx = BddUtils.bddToDotRec(bdd.id(), writer, 2, visited, bddToVisitedIdx, bddVarNames);
        Assert.areEqual((Object)visitedNextFreeIdx, (Object)visited.length);
        Assert.areEqual((Object)visitedNextFreeIdx, (Object)bddToVisitedIdx.size());
        writer.write("}\n");
        writer.flush();
        for (BDD key : bddToVisitedIdx.keySet()) {
            key.free();
        }
    }

    private static int bddToDotRec(BDD bdd, Writer writer, int visitedNextFreeIdx, boolean[] visited, Map<BDD, Integer> bddToVisitedIdx, List<String> bddVarNames) throws IOException {
        BDD highBdd;
        Integer highDotNodeIdx;
        Integer dotNodeIdx = bddToVisitedIdx.get(bdd);
        if (dotNodeIdx == null) {
            dotNodeIdx = visitedNextFreeIdx;
            bddToVisitedIdx.put(bdd, dotNodeIdx);
            ++visitedNextFreeIdx;
        }
        if (visited[dotNodeIdx]) {
            return visitedNextFreeIdx;
        }
        visited[dotNodeIdx.intValue()] = true;
        writer.write(Strings.fmt((String)"  %d [label=\"%s\"];\n", (Object[])new Object[]{dotNodeIdx, bddVarNames.get(bdd.var())}));
        BDD lowBdd = bdd.low();
        Integer lowDotNodeIdx = bddToVisitedIdx.get(lowBdd);
        if (lowDotNodeIdx == null) {
            lowDotNodeIdx = visitedNextFreeIdx;
            bddToVisitedIdx.put(lowBdd, lowDotNodeIdx);
            ++visitedNextFreeIdx;
        }
        if ((highDotNodeIdx = bddToVisitedIdx.get(highBdd = bdd.high())) == null) {
            highDotNodeIdx = visitedNextFreeIdx;
            bddToVisitedIdx.put(highBdd, highDotNodeIdx);
            ++visitedNextFreeIdx;
        }
        writer.write(Strings.fmt((String)"  %d -> %d [style=dotted];\n", (Object[])new Object[]{dotNodeIdx, lowDotNodeIdx}));
        writer.write(Strings.fmt((String)"  %d -> %d [style=filled];\n", (Object[])new Object[]{dotNodeIdx, highDotNodeIdx}));
        visitedNextFreeIdx = BddUtils.bddToDotRec(lowBdd, writer, visitedNextFreeIdx, visited, bddToVisitedIdx, bddVarNames);
        visitedNextFreeIdx = BddUtils.bddToDotRec(highBdd, writer, visitedNextFreeIdx, visited, bddToVisitedIdx, bddVarNames);
        return visitedNextFreeIdx;
    }

    public static void registerBddCallbacks(BDDFactory factory, boolean doGcStats, boolean doResizeStats, boolean doContinuousPerformanceStats, DebugNormalOutput normalOutput, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes) {
        if (doGcStats && normalOutput.isEnabled()) {
            factory.registerGcStatsCallback((stats, pre) -> BddUtils.bddGcStatsCallback(stats, pre, normalOutput));
        }
        if (doResizeStats && normalOutput.isEnabled()) {
            factory.registerResizeStatsCallback((oldSize, newSize) -> BddUtils.bddResizeStatsCallback(oldSize, newSize, normalOutput));
        }
        if (doContinuousPerformanceStats) {
            factory.registerContinuousStatsCallback((n, o) -> {
                continuousOpMisses.add(o);
                continuousUsedBddNodes.add(n);
            });
        }
    }

    private static void bddGcStatsCallback(BDDFactory.GCStats stats, boolean pre, DebugNormalOutput normalOutput) {
        StringBuilder txt = new StringBuilder();
        txt.append("BDD ");
        txt.append(pre ? "pre " : "post");
        txt.append(" garbage collection: #");
        txt.append(Strings.fmt((String)"%,d", (Object[])new Object[]{stats.num + 1 - (pre ? 0 : 1)}));
        txt.append(", ");
        txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.freenodes}));
        txt.append(" of ");
        txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.nodes}));
        txt.append(" nodes free");
        if (!pre) {
            txt.append(", ");
            txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.time}));
            txt.append(" ms, ");
            txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.sumtime}));
            txt.append(" ms total");
        }
        normalOutput.line(txt.toString());
    }

    private static void bddResizeStatsCallback(int oldSize, int newSize, DebugNormalOutput normalOutput) {
        normalOutput.line("BDD node table resize: from %,13d nodes to %,13d nodes", new Object[]{oldSize, newSize});
    }

    public static void printStats(BDDFactory factory, CifBddSettings settings, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes, String continuousPerformanceStatisticsFilePath, String continuousPerformanceStatisticsFileAbsPath) {
        DebugNormalOutput debugOutput = settings.getDebugOutput();
        boolean dbgEnabled = debugOutput.isEnabled();
        boolean doCacheStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CACHE);
        boolean doContinuousPerformanceStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CONT);
        boolean doMaxBddNodesStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_MAX_NODES);
        boolean doMaxMemoryStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.MAX_MEMORY);
        if (doCacheStats) {
            if (dbgEnabled) {
                debugOutput.line();
            }
            BddUtils.printBddCacheStats(factory.getCacheStats(), settings.getNormalOutput());
        }
        if (doContinuousPerformanceStats) {
            if (dbgEnabled) {
                debugOutput.line();
                debugOutput.line("Writing continuous BDD performance statistics file \"%s\".", new Object[]{continuousPerformanceStatisticsFilePath});
            }
            BddUtils.writeBddContinuousPerformanceStatsFile(continuousOpMisses, continuousUsedBddNodes, continuousPerformanceStatisticsFilePath, continuousPerformanceStatisticsFileAbsPath);
        }
        if (doMaxBddNodesStats) {
            if (dbgEnabled) {
                debugOutput.line();
            }
            BddUtils.printBddMaxUsedBddNodesStats(factory.getMaxUsedBddNodesStats(), settings.getNormalOutput());
        }
        if (doMaxMemoryStats) {
            if (dbgEnabled) {
                debugOutput.line();
            }
            BddUtils.printMaxMemoryStats(factory.getMaxMemoryStats(), settings.getNormalOutput());
        }
    }

    public static void printBddCacheStats(BDDFactory.CacheStats stats, DebugNormalOutput normalOutput) {
        GridBox grid = new GridBox(7, 2, 0, 1);
        grid.set(0, 0, "Node creation requests:");
        grid.set(1, 0, "Node creation chain accesses:");
        grid.set(2, 0, "Node creation cache hits:");
        grid.set(3, 0, "Node creation cache misses:");
        grid.set(4, 0, "Operation count:");
        grid.set(5, 0, "Operation cache hits:");
        grid.set(6, 0, "Operation cache misses:");
        grid.set(0, 1, Strings.str((Object)stats.uniqueAccess));
        grid.set(1, 1, Strings.str((Object)stats.uniqueChain));
        grid.set(2, 1, Strings.str((Object)stats.uniqueHit));
        grid.set(3, 1, Strings.str((Object)stats.uniqueMiss));
        grid.set(4, 1, Strings.str((Object)stats.opAccess));
        grid.set(5, 1, Strings.str((Object)stats.opHit));
        grid.set(6, 1, Strings.str((Object)stats.opMiss));
        normalOutput.line("BDD cache statistics:");
        normalOutput.inc();
        for (String line : grid.getLines()) {
            normalOutput.line(line);
        }
        normalOutput.dec();
    }

    public static void printBddMaxUsedBddNodesStats(BDDFactory.MaxUsedBddNodesStats stats, DebugNormalOutput normalOutput) {
        normalOutput.line(Strings.fmt((String)"Maximum used BDD nodes: %d.", (Object[])new Object[]{stats.getMaxUsedBddNodes()}));
    }

    public static void printMaxMemoryStats(BDDFactory.MaxMemoryStats stats, DebugNormalOutput normalOutput) {
        long maxMemoryBytes = stats.getMaxMemoryBytes();
        normalOutput.line(Strings.fmt((String)"Maximum used memory: %d bytes = %s.", (Object[])new Object[]{maxMemoryBytes, FileSizes.formatFileSize((long)maxMemoryBytes, (boolean)false)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeBddContinuousPerformanceStatsFile(List<Long> operationsSamples, List<Integer> nodesSamples, String filePath, String absFilePath) {
        Assert.notNull((Object)filePath);
        Assert.notNull((Object)absFilePath);
        Assert.areEqual((Object)operationsSamples.size(), (Object)nodesSamples.size());
        int numberOfDataPoints = operationsSamples.size();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(absFilePath));
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                        writer.write("Operations,Used BBD nodes");
                        writer.write(Strings.NL);
                        long lastOperations = -1L;
                        int lastNodes = -1;
                        int i = 0;
                        while (i < numberOfDataPoints) {
                            long nextOperations = operationsSamples.get(i);
                            int nextNodes = nodesSamples.get(i);
                            if (nextOperations != lastOperations || nextNodes != lastNodes) {
                                lastOperations = nextOperations;
                                lastNodes = nextNodes;
                                writer.write(Strings.fmt((String)"%d,%d", (Object[])new Object[]{lastOperations, lastNodes}));
                                writer.write(Strings.NL);
                            }
                            ++i;
                        }
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    ((OutputStream)stream).close();
                    throw throwable;
                }
                ((OutputStream)stream).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new InputOutputException(Strings.fmt((String)"Failed to write continuous BDD performance statistics file \"%s\".", (Object[])new Object[]{filePath}), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ int lambda$1(Map s1, Map s2) {
        keyIter1 = s1.keySet().iterator();
        keyIter2 = s2.keySet().iterator();
        while (keyIter1.hasNext() || keyIter2.hasNext()) {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            if (!keyIter1.hasNext() && keyIter2.hasNext()) {
                                return -1;
                            }
                            if (keyIter1.hasNext() && !keyIter2.hasNext()) {
                                return 1;
                            }
                            var1 = (CifBddVariable)keyIter1.next();
                            var2 = (CifBddVariable)keyIter2.next();
                            result = var1.name.compareTo(var2.name);
                            if (result != 0) {
                                return result;
                            }
                            Assert.check((boolean)(var1 == var2));
                            value1 = s1.get(var1);
                            value2 = s2.get(var2);
                            if (!(value1 instanceof Location)) break block6;
                            l1 = (Location)value1;
                            if (!(value2 instanceof Location)) break block6;
                            l2 = (Location)value2;
                            result = l1.getName().compareTo(l2.getName());
                            break block7;
                        }
                        if (!(value1 instanceof Boolean)) break block8;
                        b1 = (Boolean)value1;
                        if (!(value2 instanceof Boolean)) break block8;
                        b2 = (Boolean)value2;
                        result = b1.compareTo(b2);
                        break block7;
                    }
                    if (!(value1 instanceof Integer)) break block9;
                    i1 = (Integer)value1;
                    if (!(value2 instanceof Integer)) break block9;
                    i2 = (Integer)value2;
                    result = i1.compareTo(i2);
                    break block7;
                }
                if (!(value1 instanceof EnumLiteral)) ** GOTO lbl-1000
                l1 = (EnumLiteral)value1;
                if (value2 instanceof EnumLiteral) {
                    l2 = (EnumLiteral)value2;
                    result = l1.getName().compareTo(l2.getName());
                } else lbl-1000:
                // 2 sources

                {
                    throw new AssertionError((Object)("Unexpected combination of values: " + String.valueOf(value1) + " / " + String.valueOf(value2)));
                }
            }
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

