/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing.graph;

import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.common.dsm.sequencing.graph.Edge;

public class Cycle {
    public final List<Edge> edges;
    public final BitSet vertices;
    public final int smallestVertexIndex;

    public Cycle(List<Edge> edges) {
        this.edges = edges;
        this.vertices = new BitSet();
        int smallestIndex = -1;
        int smallestVertex = Integer.MAX_VALUE;
        int edgeIndex = 0;
        while (edgeIndex < edges.size()) {
            int vertex = edges.get((int)edgeIndex).producingVertex;
            this.vertices.set(vertex);
            if (smallestVertex > vertex) {
                smallestVertex = vertex;
                smallestIndex = edgeIndex;
            }
            ++edgeIndex;
        }
        this.smallestVertexIndex = smallestIndex;
    }

    public boolean equals(Object obj) {
        Cycle otherCycle;
        block7: {
            block6: {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Cycle)) break block6;
                otherCycle = (Cycle)obj;
                if (this.vertices.equals(otherCycle.vertices)) break block7;
            }
            return false;
        }
        int thisIndex = this.smallestVertexIndex;
        int otherIndex = otherCycle.smallestVertexIndex;
        int index = 1;
        while (index < this.edges.size()) {
            thisIndex = (thisIndex + 1) % this.edges.size();
            otherIndex = (otherIndex + 1) % this.edges.size();
            if (otherCycle.edges.get((int)otherIndex).producingVertex != this.edges.get((int)thisIndex).producingVertex) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public int hashCode() {
        return this.vertices.hashCode();
    }
}

