/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates.tree;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.updates.FindDeclarationUsage;
import org.eclipse.escet.cif.codegen.updates.ReadWriteDeclarations;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.SequenceUpdate;
import org.eclipse.escet.cif.codegen.updates.tree.UpdateData;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class SelectionUpdate
extends UpdateData {
    public final List<List<Expression>> guards;
    public final UpdateData[] childs;

    public SelectionUpdate(IfUpdate ifUpd) {
        int numAlternatives = 1 + ifUpd.getElifs().size() + (ifUpd.getElses().isEmpty() ? 0 : 1);
        this.guards = Lists.listc((int)numAlternatives);
        this.childs = new UpdateData[numAlternatives];
        int index = 0;
        this.guards.add((List<Expression>)ifUpd.getGuards());
        this.childs[index] = new SequenceUpdate((List<Update>)ifUpd.getThens());
        ++index;
        for (ElifUpdate elif : ifUpd.getElifs()) {
            this.guards.add((List<Expression>)elif.getGuards());
            this.childs[index] = new SequenceUpdate((List<Update>)elif.getThens());
            ++index;
        }
        if (!ifUpd.getElses().isEmpty()) {
            this.guards.add(null);
            this.childs[index] = new SequenceUpdate((List<Update>)ifUpd.getElses());
            ++index;
        }
        Assert.check((index == numAlternatives ? 1 : 0) != 0);
    }

    @Override
    public ReadWriteDeclarations collectVariableUsage(CodeContext ctxt) {
        ReadWriteDeclarations rwDecls = null;
        int index = 0;
        while (index < this.childs.length) {
            ReadWriteDeclarations childRW = this.childs[index].collectVariableUsage(ctxt);
            if (rwDecls == null) {
                rwDecls = new ReadWriteDeclarations(childRW);
            } else {
                rwDecls.addAll(childRW);
            }
            if (this.guards.get(index) != null) {
                FindDeclarationUsage.collectUse(this.guards.get(index), rwDecls.read);
            }
            ++index;
        }
        Assert.check((rwDecls != null ? 1 : 0) != 0);
        return rwDecls;
    }

    @Override
    protected void addLocalCopies(Set<VariableWrapper> copiedVars) {
        int index = 0;
        while (index < this.childs.length) {
            this.childs[index].addLocalCopies(copiedVars);
            ++index;
        }
    }

    @Override
    public void genCode(CodeBox code, boolean safeScope, CodeContext readCtxt, CodeContext writeCtxt) {
        IfElseGenerator ifStatementGen = readCtxt.getIfElseUpdateGenerator();
        int index = 0;
        while (index < this.childs.length) {
            if (this.guards.get(index) == null) {
                ifStatementGen.generateElse(code);
            } else {
                ExprCode guard = readCtxt.predsToTarget(this.guards.get(index));
                if (index == 0) {
                    ifStatementGen.generateIf(guard, code);
                } else {
                    ifStatementGen.generateElseIf(guard, code);
                }
            }
            this.childs[index].genCode(code, ifStatementGen.branchIsSafeScope(), readCtxt, writeCtxt);
            ++index;
        }
        ifStatementGen.generateEndIf(code);
    }
}

