/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.tags.ITagExtension;
import org.eclipse.gendoc.tags.ITagHandler;
import org.eclipse.gendoc.tags.TagsExtensionPoint;
import org.eclipse.gendoc.tags.impl.AbstractContainerExtension;
import org.eclipse.gendoc.tags.impl.AbstractExtension;
import org.eclipse.gendoc.tags.impl.AttributeExtension;
import org.eclipse.gendoc.tags.impl.TagExtensionService;

public class TagExtension
extends AbstractContainerExtension
implements ITagExtension {
    private final String name;
    private final Set<AttributeExtension> attributes = new HashSet<AttributeExtension>();
    private ITagHandler handler;

    public static TagExtension load(TagExtensionService tagExtensionService, IConfigurationElement configElement) {
        if (!configElement.getName().equals(TagsExtensionPoint.TAG)) {
            return null;
        }
        try {
            TagExtension tagExtension = new TagExtension(tagExtensionService, configElement);
            if (tagExtension != null) {
                tagExtensionService.getTagExtensions().add(tagExtension);
            }
            return tagExtension;
        }
        catch (Exception e) {
            String message = "Failed to load " + TagsExtensionPoint.TAG + " in " + configElement.getDeclaringExtension().getNamespaceIdentifier();
            AbstractExtension.log(message, e);
            return null;
        }
    }

    protected TagExtension(TagExtensionService tagExtensionService, IConfigurationElement configElement) {
        super(tagExtensionService, configElement);
        this.name = TagExtension.parseStringAttribute(configElement, TagsExtensionPoint.TAG_NAME, true);
        this.loadAttributes(configElement);
    }

    public Set<AttributeExtension> getAttributes() {
        return this.attributes;
    }

    @Override
    public ITagHandler getHandler() {
        if (this.handler == null) {
            try {
                this.handler = (ITagHandler)this.getConfigElement().createExecutableExtension(TagsExtensionPoint.TAG_HANDLER);
            }
            catch (CoreException e) {
                String message = "Failed to load handler for " + TagsExtensionPoint.TAG + " named " + this.getName() + " in " + this.getConfigElement().getDeclaringExtension().getNamespaceIdentifier();
                TagExtension.log(message, (Exception)((Object)e));
            }
        }
        return this.handler;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void loadAttributes(IConfigurationElement configElement) {
        IConfigurationElement[] attributeElements;
        IConfigurationElement[] iConfigurationElementArray = attributeElements = configElement.getChildren(TagsExtensionPoint.ATTRIBUTE);
        int n = attributeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement attributeElement = iConfigurationElementArray[n2];
            AttributeExtension attributeExtension = AttributeExtension.load(attributeElement);
            if (attributeExtension != null) {
                this.attributes.add(attributeExtension);
            }
            ++n2;
        }
    }
}

