/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.internal;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.glassfish.tools.GlassFishInstall;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.IGlassfishRuntimeModel;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public final class GlassFishRuntimeLocatorDelegate
extends RuntimeLocatorDelegate {
    private static final IRuntimeType RUNTIME_TYPE = ServerCore.findRuntimeType((String)"glassfish");

    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        this.search(path.toFile(), listener, monitor);
    }

    private void search(File f, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !f.isDirectory() || f.isHidden()) {
            return;
        }
        try {
            IRuntime rt = GlassFishRuntimeLocatorDelegate.create(f);
            if (rt != null) {
                IRuntimeWorkingCopy wc = rt.createWorkingCopy();
                listener.runtimeFound(wc);
                return;
            }
        }
        catch (CoreException e) {
            GlassfishToolsPlugin.log((Exception)((Object)e));
            return;
        }
        File[] children = f.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.search(child, listener, monitor);
                ++n2;
            }
        }
    }

    private static IRuntime create(File gfhome) throws CoreException {
        IStatus validationResult;
        GlassFishInstall install = GlassFishInstall.find((File)gfhome);
        if (install == null) {
            return null;
        }
        if (GlassFishRuntimeLocatorDelegate.findRuntime(gfhome) != null) {
            return null;
        }
        String name = GlassFishRuntime.createDefaultRuntimeName((Version)install.version());
        IRuntimeWorkingCopy created = RUNTIME_TYPE.createRuntime(name, null);
        created.setLocation((IPath)new Path(gfhome.getAbsolutePath()));
        created.setName(name);
        RuntimeWorkingCopy rwc = (RuntimeWorkingCopy)created;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sunappserver.rootdirectory", rwc.getLocation().toPortableString());
        rwc.setAttribute("generic_server_instance_properties", props);
        GlassFishRuntime gf = (GlassFishRuntime)rwc.loadAdapter(GlassFishRuntime.class, null);
        final IGlassfishRuntimeModel gfmodel = gf.getModel();
        Value javaRuntimeEnvironmentProperty = gfmodel.getJavaRuntimeEnvironment();
        if (javaRuntimeEnvironmentProperty.content() == null) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    new SapphireDialog(display.getActiveShell(), (Element)gfmodel, DefinitionLoader.sdef(GlassFishRuntimeLocatorDelegate.class).dialog()).open();
                }
            });
            if (javaRuntimeEnvironmentProperty.content() == null) {
                rwc.dispose();
                return null;
            }
            gf.getVMInstall();
            javaRuntimeEnvironmentProperty.clear();
        }
        if ((validationResult = created.validate(null)).getSeverity() != 4) {
            created.save(true, null);
            return created.getOriginal();
        }
        return null;
    }

    private static IRuntime findRuntime(File location) {
        IRuntime[] iRuntimeArray = ResourceManager.getInstance().getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (RUNTIME_TYPE == runtime.getRuntimeType() && location.equals(runtime.getLocation().toFile())) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }
}

