/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.log;

import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LogStyle
implements LineStyleListener,
IPropertyChangeListener {
    Display display = Display.getCurrent();
    IPreferenceStore store = GlassfishToolsPlugin.getInstance().getPreferenceStore();
    boolean colorInConsole = this.store.getBoolean("EnableColorsInConsolePreference");

    public LogStyle(IDocument document) {
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void finalize() throws Throwable {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        super.finalize();
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyleRange styleRange = null;
        String buf = event.lineText;
        if (this.colorInConsole) {
            int start = buf.indexOf(Level.WARNING.getName());
            if (start != -1) {
                styleRange = new StyleRange();
                styleRange.start = event.lineOffset + start;
                styleRange.length = 6;
                styleRange.foreground = this.display.getSystemColor(8);
            } else {
                String errorColorName;
                start = buf.indexOf(Level.SEVERE.getName());
                if (start != -1) {
                    styleRange = new StyleRange();
                    errorColorName = "ERROR_COLOR";
                    styleRange.foreground = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(errorColorName);
                    styleRange.start = event.lineOffset + start;
                    styleRange.length = 5;
                    styleRange.fontStyle = 1;
                } else {
                    start = buf.indexOf("FATAL");
                    if (start != -1) {
                        styleRange = new StyleRange();
                        errorColorName = "ERROR_COLOR";
                        styleRange.foreground = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(errorColorName);
                        styleRange.start = event.lineOffset + start;
                        styleRange.length = 4;
                        styleRange.fontStyle = 1;
                    }
                }
            }
            if (styleRange != null) {
                StyleRange[] styles = event.styles != null ? Arrays.copyOf(event.styles, event.styles.length + 1) : new StyleRange[1];
                styles[styles.length - 1] = styleRange;
                event.styles = styles;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("EnableColorsInConsolePreference")) {
            this.colorInConsole = this.store.getBoolean("EnableColorsInConsolePreference");
        }
    }
}

