/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.IGlassfishServerModel;
import org.eclipse.glassfish.tools.ui.wizards.GlassfishSapphireWizardFragment;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;

public class ServerPropertyPage
extends PropertyPage {
    IServerWorkingCopy serverWC = null;
    GlassFishServer sunserver;
    IGlassfishServerModel model;
    FilteredListener<PropertyValidationEvent> listener = new FilteredListener<PropertyValidationEvent>(){

        protected void handleTypedEvent(PropertyValidationEvent event) {
            ServerPropertyPage.this.refreshStatus();
        }
    };

    protected Control createContents(Composite parent) {
        IServer server = (IServer)this.getElement();
        this.serverWC = server instanceof IServerWorkingCopy ? (IServerWorkingCopy)server : server.createWorkingCopy();
        this.sunserver = (GlassFishServer)this.serverWC.loadAdapter(GlassFishServer.class, (IProgressMonitor)new NullProgressMonitor());
        this.model = this.sunserver.getModel();
        this.model.attach(this.listener, "*");
        SapphireForm control = new SapphireForm(parent, (Element)this.model, DefinitionLoader.context(GlassfishSapphireWizardFragment.class).sdef("org.eclipse.glassfish.tools.ui.GlassfishUI").form("glassfish.server"));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.refreshStatus();
        return control;
    }

    private void refreshStatus() {
        org.eclipse.sapphire.modeling.Status status = this.model.validation();
        if (status.severity() == Status.Severity.ERROR) {
            this.setMessage(status.message(), 3);
            this.setValid(false);
        } else if (status.severity() == Status.Severity.WARNING) {
            this.setMessage(status.message(), 2);
            this.setValid(true);
        } else {
            this.setMessage(null, 0);
            this.setValid(true);
        }
    }

    public boolean isValid() {
        return super.isValid();
    }

    public boolean performCancel() {
        this.model.detach(this.listener, "*");
        return super.performCancel();
    }

    protected void performApply() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            final IServer server = this.serverWC.save(true, (IProgressMonitor)monitor);
            Job job = new Job("Update Glassfish server state"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        GlassFishServerBehaviour serverBehavior = (GlassFishServerBehaviour)ServerPropertyPage.this.serverWC.loadAdapter(GlassFishServerBehaviour.class, monitor);
                        serverBehavior.updateServerStatus();
                        Server gfServer = (Server)server;
                        gfServer.setServerPublishState(4);
                    }
                    catch (Exception exception) {
                        ((Server)server).setServerState(4);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        this.model.detach(this.listener, "*");
        this.performApply();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.serverWC.setAttribute("glassfish.adminname", "");
        this.serverWC.setAttribute("glassfish.adminpassword", "");
        this.serverWC.setAttribute("glassfish.domainpath", GlassFishServer.getDefaultDomainDir((IPath)this.serverWC.getRuntime().getLocation()).toString());
        this.serverWC.setAttribute("glassfish.adminserverportnumber", "");
        this.serverWC.setAttribute("glassfish.debugport", "");
        this.model.refresh();
    }
}

