/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.resources.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.glassfish.tools.sdk.server.parser.ResourcesReader;
import org.eclipse.glassfish.tools.ui.resources.JDBCInfo;
import org.eclipse.glassfish.tools.ui.resources.wizards.Messages;
import org.eclipse.glassfish.tools.utils.ResourceUtils;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JDBCResourceWizardPage
extends WizardPage {
    private static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";
    private Text jndiText;
    private IConnectionProfile connectionProfile;
    private IProject selectedProject;
    private List<IProject> candidateProjects;
    private Combo combo;
    private Combo projectNameCombo;
    private NewCPWizard wizard;
    private WizardDialog wizardDialog;
    private List<String> resources = new ArrayList<String>();
    private String defaultJndiName = "jdbc/myDatasource";

    public JDBCResourceWizardPage(IProject project, List<IProject> projects) {
        super("wizardPage");
        this.setTitle(Messages.wizardTitle);
        this.setDescription(Messages.wizardDescription);
        this.selectedProject = project;
        this.candidateProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.ProjectName);
        this.projectNameCombo = new Combo(container, 12);
        GridDataFactory.defaultsFor((Control)this.projectNameCombo).span(2, 1).applyTo((Control)this.projectNameCombo);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newSelection = JDBCResourceWizardPage.this.projectNameCombo.getText();
                if (newSelection != null) {
                    JDBCResourceWizardPage.this.selectedProject = ProjectUtilities.getProject((String)newSelection);
                    JDBCResourceWizardPage.this.resources = ResourceUtils.getResources((IProject)JDBCResourceWizardPage.this.selectedProject, (ResourcesReader.ResourceType[])new ResourcesReader.ResourceType[]{ResourcesReader.ResourceType.JDBC_RESOURCE});
                    JDBCResourceWizardPage.this.dialogChanged();
                }
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.JNDIName);
        this.jndiText = new Text(container, 2052);
        GridDataFactory.defaultsFor((Control)this.jndiText).span(2, 1).applyTo((Control)this.jndiText);
        this.jndiText.setText(this.defaultJndiName);
        this.jndiText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCResourceWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.Connection);
        this.combo = new Combo(container, 12);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newSelection = JDBCResourceWizardPage.this.combo.getText();
                if (newSelection != null) {
                    JDBCResourceWizardPage.this.connectionProfile = ProfileManager.getInstance().getProfileByName(newSelection);
                }
            }
        });
        GridDataFactory.defaultsFor((Control)this.combo).align(4, 0x1000000).applyTo((Control)this.combo);
        Button button = new Button(container, 8);
        button.setText(Messages.Create);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IConnectionProfile newProfile = JDBCResourceWizardPage.this.showCPWizard();
                if (newProfile != null) {
                    JDBCResourceWizardPage.this.connectionProfile = newProfile;
                    String newName = JDBCResourceWizardPage.this.connectionProfile.getName();
                    JDBCResourceWizardPage.this.combo.add(newName);
                    JDBCResourceWizardPage.this.combo.select(JDBCResourceWizardPage.this.combo.indexOf(newName));
                    JDBCResourceWizardPage.this.combo.pack();
                }
                JDBCResourceWizardPage.this.dialogChanged();
            }
        });
        GridDataFactory.defaultsFor((Control)button).align(0x1000008, 0x1000000).applyTo((Control)button);
        this.initialize();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.populateCombos();
        this.dialogChanged();
        this.resources = ResourceUtils.getResources((IProject)this.selectedProject, (ResourcesReader.ResourceType[])new ResourcesReader.ResourceType[]{ResourcesReader.ResourceType.JDBC_RESOURCE});
        if (this.resources.contains(this.defaultJndiName)) {
            String jndiName = ResourceUtils.getUniqueResourceName((String)this.defaultJndiName, this.resources);
            this.jndiText.setText(jndiName);
        }
    }

    private void dialogChanged() {
        boolean hasConnection;
        this.setPageComplete(false);
        boolean hasProject = this.projectNameCombo.getSelectionIndex() != -1;
        boolean bl = hasConnection = this.combo.getSelectionIndex() != -1;
        if (!hasProject) {
            this.setErrorMessage(Messages.errorProjectMissing);
            return;
        }
        String jndiName = this.getJNDIName();
        if (jndiName == null || jndiName.length() == 0) {
            this.setErrorMessage(Messages.errorJndiNameMissing);
            return;
        }
        if (ResourceUtils.isDuplicate((String)jndiName, this.resources)) {
            this.setErrorMessage(NLS.bind((String)Messages.errorDuplicateName, (Object)jndiName));
            return;
        }
        if (!hasConnection) {
            this.setErrorMessage(Messages.errorConnectionMissing);
            return;
        }
        if (this.connectionProfile == null) {
            this.setErrorMessage(Messages.errorConnectionInvalid);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getJNDIName() {
        return this.jndiText.getText();
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    private IConnectionProfile showCPWizard() {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                CPWizardNode wizardNode = (CPWizardNode)element;
                if (!(wizardNode.getProvider() instanceof IWizardCategoryProvider)) {
                    ICategory cat = ConnectionProfileManager.getInstance().getProvider(((ProfileWizardProvider)wizardNode.getProvider()).getProfile()).getCategory();
                    while (cat != null) {
                        if (cat.getId().equals(JDBCResourceWizardPage.DATABASE_CATEGORY_ID)) {
                            return true;
                        }
                        cat = cat.getParent();
                    }
                }
                return false;
            }
        };
        this.wizard = new NewCPWizard(viewerFilter, null);
        Shell currentShell = Display.getCurrent().getActiveShell();
        this.wizardDialog = new WizardDialog(currentShell, (IWizard)this.wizard);
        this.wizardDialog.setBlockOnOpen(true);
        ProfileManager profileManager = ProfileManager.getInstance();
        ProfileListener listener = new ProfileListener();
        profileManager.addProfileListener((IProfileListener)listener);
        int result = this.wizardDialog.open();
        profileManager.removeProfileListener((IProfileListener)listener);
        return result != 1 ? listener.newProfile : null;
    }

    private IConnectionProfile[] getConnectionProfiles() {
        return ProfileManager.getInstance().getProfilesByCategory(DATABASE_CATEGORY_ID);
    }

    private void populateCombos() {
        this.combo.removeAll();
        IConnectionProfile[] iConnectionProfileArray = this.getConnectionProfiles();
        int n = iConnectionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile profile = iConnectionProfileArray[n2];
            if (this.connectionProfile == null) {
                this.connectionProfile = profile;
            }
            this.combo.add(profile.getName());
            ++n2;
        }
        if (this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
        this.projectNameCombo.removeAll();
        String selectProjectName = this.selectedProject != null ? this.selectedProject.getName() : null;
        int selectionIndex = -1;
        int i = 0;
        while (i < this.candidateProjects.size()) {
            IProject nextProject = this.candidateProjects.get(i);
            String projectName = nextProject.getName();
            this.projectNameCombo.add(projectName);
            if (projectName.equals(selectProjectName)) {
                selectionIndex = i;
            }
            ++i;
        }
        if (selectionIndex != -1 && this.projectNameCombo.getItemCount() > 0) {
            this.projectNameCombo.select(selectionIndex);
        } else {
            this.selectedProject = null;
        }
    }

    JDBCInfo getJDBCInfo() {
        return new JDBCInfo(this.connectionProfile);
    }

    static class ProfileListener
    implements IProfileListener {
        IConnectionProfile newProfile;

        ProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.newProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }
}

