/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.resources.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.glassfish.tools.sdk.server.parser.ResourcesReader;
import org.eclipse.glassfish.tools.ui.resources.MailInfo;
import org.eclipse.glassfish.tools.ui.resources.wizards.Messages;
import org.eclipse.glassfish.tools.utils.ResourceUtils;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MailResourceWizardPage
extends WizardPage {
    private Text jndiText;
    private Text hostText;
    private Text userText;
    private Text fromText;
    private IProject selectedProject;
    private List<IProject> candidateProjects;
    private MailInfo mailInfo;
    private Combo projectNameCombo;
    private List<String> resources = new ArrayList<String>();
    private String defaultJndiName = "mail/mymailSession";

    public MailResourceWizardPage(IProject project, List<IProject> projects) {
        super("wizardPage");
        this.setTitle(Messages.mailWizardTitle);
        this.setDescription(Messages.mailWizardDescription);
        this.selectedProject = project;
        this.candidateProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.ProjectName);
        this.projectNameCombo = new Combo(container, 12);
        GridDataFactory.defaultsFor((Control)this.projectNameCombo).span(2, 1).applyTo((Control)this.projectNameCombo);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newSelection = MailResourceWizardPage.this.projectNameCombo.getText();
                if (newSelection != null) {
                    MailResourceWizardPage.this.selectedProject = ProjectUtilities.getProject((String)newSelection);
                    MailResourceWizardPage.this.resources = ResourceUtils.getResources((IProject)MailResourceWizardPage.this.selectedProject, (ResourcesReader.ResourceType[])new ResourcesReader.ResourceType[]{ResourcesReader.ResourceType.JDBC_RESOURCE});
                    MailResourceWizardPage.this.dialogChanged();
                }
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.JNDIName);
        this.jndiText = new Text(container, 2052);
        GridDataFactory.defaultsFor((Control)this.jndiText).span(2, 1).applyTo((Control)this.jndiText);
        this.jndiText.setText(this.defaultJndiName);
        this.jndiText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailResourceWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.MailHost);
        this.hostText = new Text(container, 2052);
        GridDataFactory.defaultsFor((Control)this.hostText).span(2, 1).applyTo((Control)this.hostText);
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailResourceWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.MailUser);
        this.userText = new Text(container, 2052);
        GridDataFactory.defaultsFor((Control)this.userText).span(2, 1).applyTo((Control)this.userText);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailResourceWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.MailFrom);
        this.fromText = new Text(container, 2052);
        GridDataFactory.defaultsFor((Control)this.fromText).span(2, 1).applyTo((Control)this.fromText);
        this.fromText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailResourceWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.resources = ResourceUtils.getResources((IProject)this.selectedProject, (ResourcesReader.ResourceType[])new ResourcesReader.ResourceType[]{ResourcesReader.ResourceType.JAVA_MAIL});
        if (this.resources.contains(this.defaultJndiName)) {
            String jndiName = ResourceUtils.getUniqueResourceName((String)this.defaultJndiName, this.resources);
            this.jndiText.setText(jndiName);
        }
        this.populateCombos();
        this.dialogChanged();
    }

    public String getJNDIName() {
        return this.jndiText.getText();
    }

    public String getMailHost() {
        return this.hostText.getText();
    }

    public String getMailUser() {
        return this.userText.getText();
    }

    public String getMailFrom() {
        return this.fromText.getText();
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    private void dialogChanged() {
        boolean hasProject;
        this.setPageComplete(false);
        boolean bl = hasProject = this.projectNameCombo.getSelectionIndex() != -1;
        if (!hasProject) {
            this.setErrorMessage(Messages.errorProjectMissing);
            return;
        }
        String jndiName = this.getJNDIName();
        if (jndiName == null || jndiName.length() == 0) {
            this.setErrorMessage(Messages.errorJndiNameMissing);
            return;
        }
        if (ResourceUtils.isDuplicate((String)jndiName, this.resources)) {
            this.setErrorMessage(NLS.bind((String)Messages.errorDuplicateName, (Object)jndiName));
            return;
        }
        String mailHost = this.getMailHost();
        if (mailHost == null || mailHost.length() == 0) {
            this.setErrorMessage(Messages.errorMailHostNameMissing);
            return;
        }
        String mailUser = this.getMailUser();
        if (mailUser == null || mailUser.length() == 0) {
            this.setErrorMessage(Messages.errorMailUserNameMissing);
            return;
        }
        String mailFrom = this.getMailFrom();
        if (mailFrom == null || mailFrom.length() == 0) {
            this.setErrorMessage(Messages.errorMailReturnAddrMissing);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private void populateCombos() {
        this.projectNameCombo.removeAll();
        String selectProjectName = this.selectedProject != null ? this.selectedProject.getName() : null;
        int selectionIndex = -1;
        int i = 0;
        while (i < this.candidateProjects.size()) {
            IProject nextProject = this.candidateProjects.get(i);
            String projectName = nextProject.getName();
            this.projectNameCombo.add(projectName);
            if (projectName.equals(selectProjectName)) {
                selectionIndex = i;
            }
            ++i;
        }
        if (selectionIndex != -1 && this.projectNameCombo.getItemCount() > 0) {
            this.projectNameCombo.select(selectionIndex);
        } else {
            this.selectedProject = null;
        }
    }

    public MailInfo getMailInfo() {
        this.mailInfo = new MailInfo();
        this.mailInfo.setJndiName(this.getJNDIName());
        this.mailInfo.setMailFrom(this.getMailFrom());
        this.mailInfo.setMailHost(this.getMailHost());
        this.mailInfo.setMailUser(this.getMailUser());
        return this.mailInfo;
    }
}

