/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.resources.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.glassfish.tools.ui.resources.MailInfo;
import org.eclipse.glassfish.tools.ui.resources.wizards.MailResourceWizardPage;
import org.eclipse.glassfish.tools.ui.resources.wizards.Messages;
import org.eclipse.glassfish.tools.ui.resources.wizards.ResourceWizard;
import org.eclipse.glassfish.tools.utils.ResourceUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MailWizard
extends ResourceWizard {
    private MailResourceWizardPage page;

    public MailWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        IContainer containerResource = this.getContainerResource();
        IProject selectedProject = containerResource != null ? containerResource.getProject() : null;
        this.page = new MailResourceWizardPage(selectedProject, this.getGlassFishAndSailfinProjects());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String jndiName = this.page.getJNDIName();
        final MailInfo mailInfo = this.page.getMailInfo();
        final IProject selectedProject = this.page.getSelectedProject();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        MailWizard.this.doFinish(jndiName, mailInfo, selectedProject, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            String message = realException.getMessage();
            if (message == null) {
                message = Messages.errorUnknown;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ErrorTitle, (String)message);
            return false;
        }
        return true;
    }

    private void doFinish(String jndiName, MailInfo mailInfo, IProject selectedProject, IProgressMonitor monitor) throws CoreException {
        this.checkDir(selectedProject);
        monitor.beginTask("Creating sun-resources.xml", 2);
        final IFile file = this.folder.getFile((IPath)new Path("sun-resources.xml"));
        try {
            String fragment = MailWizard.createFragment(jndiName, mailInfo);
            InputStream stream = ResourceUtils.appendResource((IFile)file, (String)fragment);
            if (!this.folder.exists()) {
                this.folder.create(true, true, monitor);
            }
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    public static String createFragment(String jndiName, MailInfo mailInfo) throws CoreException {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        String mailHost = mailInfo.getMailHost();
        String mailUser = mailInfo.getMailUser();
        String mailFrom = mailInfo.getMailFrom();
        boolean matchStart = false;
        boolean matchEnd = false;
        try {
            InputStream input = MailInfo.class.getResourceAsStream("templates/sun-resources-xml-template.resource");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf("<mail-resource") != -1) {
                        matchStart = true;
                    }
                    if (!matchStart || matchEnd) continue;
                    line = line.replaceAll("\\$\\{jndiName\\}", jndiName);
                    line = line.replaceAll("\\$\\{mailHost\\}", mailHost);
                    line = line.replaceAll("\\$\\{mailUser\\}", mailUser);
                    if ((line = line.replaceAll("\\$\\{mailFrom\\}", mailFrom)) != null) {
                        sb.append(line);
                        sb.append(newline);
                    }
                    if (line.indexOf("</mail-resource>") == -1) continue;
                    matchEnd = true;
                }
            }
        }
        catch (IOException ioe) {
            Status status = new Status(4, "MailWizard", 0, ioe.getLocalizedMessage(), null);
            throw new CoreException((IStatus)status);
        }
        return sb.toString();
    }
}

