/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.resources.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.glassfish.tools.ui.resources.wizards.Messages;
import org.eclipse.glassfish.tools.utils.ResourceUtils;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.server.core.IRuntime;

public abstract class ResourceWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected String dirName;
    protected IFolder folder;

    public ResourceWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected void checkDir(IProject selectedProject) throws CoreException {
        this.dirName = ResourceUtils.getResourceLocation((IProject)selectedProject);
        if (this.dirName == null) {
            Status status = new Status(4, ((Object)((Object)this)).getClass().getName(), 0, NLS.bind((String)Messages.errorFolderNull, (Object)this.dirName), null);
            throw new CoreException((IStatus)status);
        }
        IProject containerResource = selectedProject;
        this.folder = containerResource.getFolder((IPath)new Path(this.dirName));
        if (!this.folder.exists()) {
            Status status = new Status(4, ((Object)((Object)this)).getClass().getName(), 0, NLS.bind((String)Messages.errorFolderMissing, (Object)this.dirName), null);
            throw new CoreException((IStatus)status);
        }
    }

    protected static String replaceOrRemove(String originalLine, String pattern, String value) {
        String containsPattern = ".*" + pattern + ".*";
        if (originalLine != null && Pattern.matches(containsPattern, originalLine)) {
            return value == null || value.length() == 0 ? null : originalLine.replaceAll(pattern, value);
        }
        return originalLine;
    }

    protected IContainer getContainerResource() {
        if (this.selection != null && !this.selection.isEmpty()) {
            IStructuredSelection ssel = this.selection;
            if (ssel.size() > 1) {
                return null;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer containerResource = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                return containerResource != null ? containerResource.getProject() : null;
            }
        }
        return null;
    }

    protected List<IProject> getGlassFishAndSailfinProjects() {
        IProject[] allProjects = ProjectUtilities.getAllProjects();
        ArrayList<IProject> returnProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            try {
                if (FacetedProjectFramework.hasProjectFacet((IProject)project2, (String)"sun.facet")) {
                    returnProjects.add(project2);
                } else {
                    String runtimeId;
                    IRuntime runtime = J2EEProjectUtilities.getServerRuntime((IProject)project2);
                    if (runtime != null && (runtimeId = runtime.getRuntimeType().getId()).equals("glassfish")) {
                        returnProjects.add(project2);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return returnProjects;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

