/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.serverview;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.serverview.AppDesc;
import org.eclipse.glassfish.tools.ui.serverview.ApplicationNode;
import org.eclipse.glassfish.tools.ui.serverview.TreeNode;
import org.eclipse.glassfish.tools.utils.NodesUtils;

public class DeployedApplicationsNode
extends TreeNode {
    GlassFishServer server = null;
    ApplicationNode[] deployedapps = null;

    public DeployedApplicationsNode(GlassFishServer server) {
        super("Deployed Applications", null, null);
        this.server = server;
    }

    public GlassFishServer getServer() {
        return this.server;
    }

    @Override
    public Object[] getChildren() {
        ArrayList<ApplicationNode> appsList = new ArrayList<ApplicationNode>();
        if (this.deployedapps == null) {
            try {
                if (this.server == null) {
                    this.deployedapps = appsList.toArray(new ApplicationNode[appsList.size()]);
                    return this.deployedapps;
                }
                try {
                    Map appMap = NodesUtils.getApplications((GlassFishServer)this.server, null);
                    for (Map.Entry entry : appMap.entrySet()) {
                        List apps = (List)entry.getValue();
                        for (AppDesc app : apps) {
                            ApplicationNode t = new ApplicationNode(this, this.server, app);
                            appsList.add(t);
                        }
                    }
                }
                catch (Exception ex) {
                    GlassfishToolsPlugin.logError((String)"get Applications is failing=", (Exception)ex);
                }
            }
            catch (Exception exception) {}
            this.deployedapps = appsList.toArray(new ApplicationNode[appsList.size()]);
        }
        return this.deployedapps;
    }

    public void refresh() {
        this.deployedapps = null;
    }
}

