/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.serverview;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.serverview.ResourceDesc;
import org.eclipse.glassfish.tools.ui.serverview.NodeTypes;
import org.eclipse.glassfish.tools.ui.serverview.TreeNode;
import org.eclipse.glassfish.tools.utils.NodesUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ResourcesNode
extends TreeNode {
    GlassFishServer server = null;
    ResourcesNode[] children = null;
    boolean containerNode = false;
    ResourceDesc resDescriptor = null;
    private Map<String, String> map = null;

    public ResourcesNode(String name, String type, GlassFishServer server, ResourceDesc resDescriptor) {
        super(name, type, null);
        this.server = server;
        this.resDescriptor = resDescriptor;
        String[] childTypes = NodeTypes.getChildTypes(type);
        if (childTypes != null) {
            int i = 0;
            while (i < childTypes.length) {
                String childtype = childTypes[i];
                ResourcesNode n = new ResourcesNode(childtype, childtype, server, null);
                if (NodeTypes.getChildTypes(childtype) != null) {
                    n.setContainerNode();
                }
                this.addChild(n);
                ++i;
            }
        }
    }

    public GlassFishServer getServer() {
        return this.server;
    }

    public void setContainerNode() {
        this.containerNode = true;
    }

    public boolean isContainerNode() {
        return this.containerNode;
    }

    public ResourceDesc getResource() {
        return this.resDescriptor;
    }

    @Override
    public Object[] getChildren() {
        if (this.containerNode || this.resDescriptor != null) {
            return this.childModules.toArray();
        }
        ArrayList<ResourcesNode> list = new ArrayList<ResourcesNode>();
        if (this.children == null) {
            try {
                if (this.server == null) {
                    this.children = list.toArray(new ResourcesNode[list.size()]);
                    return this.children;
                }
                try {
                    List resourcesList = NodesUtils.getResources((GlassFishServer)this.server, (String)this.type);
                    for (ResourceDesc resource : resourcesList) {
                        ResourcesNode t = new ResourcesNode(resource.getName(), this.type, this.server, resource);
                        list.add(t);
                    }
                }
                catch (Exception ex) {
                    GlassfishToolsPlugin.logError((String)"get GlassFish Resources is failing=", (Exception)ex);
                }
            }
            catch (Exception exception) {}
            this.children = list.toArray(new ResourcesNode[list.size()]);
        }
        return this.children;
    }

    public void refresh() {
        this.children = null;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> properties = new ArrayList<TextPropertyDescriptor>();
        try {
            if (this.resDescriptor != null) {
                this.map = NodesUtils.getResourceData((GlassFishServer)this.server, (String)this.resDescriptor.getName());
                Set<String> s = this.map.keySet();
                for (String prop : s) {
                    String realvalue = prop.substring(prop.lastIndexOf(".") + 1, prop.length());
                    TextPropertyDescriptor pd = new TextPropertyDescriptor((Object)prop, realvalue);
                    properties.add(pd);
                }
            }
            return properties.toArray(new IPropertyDescriptor[0]);
        }
        catch (Exception ex) {
            GlassfishToolsPlugin.logError((String)"get GlassFish Resources is failing=", (Exception)ex);
            return null;
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (this.resDescriptor == null) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        return this.map.get(id);
    }
}

