/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.serverview.actions;

import java.net.URI;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.ui.serverview.DeployedApplicationsNode;
import org.eclipse.glassfish.tools.ui.serverview.TreeNode;
import org.eclipse.glassfish.tools.utils.Utils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenInBrowserAction
extends Action {
    ISelection selection;

    public OpenInBrowserAction(ISelection selection) {
        this.setText("Open in Browser");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.file.print");
        this.selection = selection;
    }

    public void runWithEvent(Event event) {
        if (this.selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)this.selection;
            Object obj = ts.getFirstElement();
            if (obj instanceof TreeNode) {
                TreeNode module = (TreeNode)obj;
                DeployedApplicationsNode target = (DeployedApplicationsNode)module.getParent();
                try {
                    GlassFishServerBehaviour be = target.getServer().getServerBehaviourAdapter();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    GlassFishServer server = be.getGlassfishServerDelegate();
                    String host = server.getServer().getHost();
                    int port = server.getPort();
                    URI uri = new URI(Utils.getHttpListenerProtocol((String)host, (int)port), null, host, port, "/" + module.getName(), null, null);
                    browser.openURL(uri.toURL());
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage((String)("Error opening browser: " + e.getMessage()));
                }
            }
            super.run();
        }
    }

    public void run() {
        this.runWithEvent(null);
    }
}

