/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.serverview.actions;

import java.net.URL;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.ui.serverview.DeployedWebServicesNode;
import org.eclipse.glassfish.tools.ui.serverview.WebServiceNode;
import org.eclipse.glassfish.tools.utils.Utils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class TestWebServiceAction
extends Action {
    ISelection selection;

    public TestWebServiceAction(ISelection selection) {
        this.setText("Test Web Service in Browser");
        this.selection = selection;
    }

    public void runWithEvent(Event event) {
        if (this.selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)this.selection;
            Object obj = ts.getFirstElement();
            if (obj instanceof WebServiceNode) {
                WebServiceNode module = (WebServiceNode)obj;
                DeployedWebServicesNode target = (DeployedWebServicesNode)module.getParent();
                try {
                    GlassFishServerBehaviour be = target.getServer().getServerBehaviourAdapter();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    GlassFishServer server = be.getGlassfishServerDelegate();
                    String host = server.getServer().getHost();
                    int port = server.getPort();
                    String url = String.valueOf(Utils.getHttpListenerProtocol((String)host, (int)port)) + "://" + host + ":" + port + "/" + module.getWSInfo().getTestURL();
                    browser.openURL(new URL(url));
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logMessage((String)("Error opening browser: " + e.getMessage()));
                }
            }
            super.run();
        }
    }

    public void run() {
        this.runWithEvent(null);
    }
}

