/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.serverview.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.ui.serverview.DeployedApplicationsNode;
import org.eclipse.glassfish.tools.ui.serverview.TreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class UndeployAction
extends Action {
    ISelection selection;
    ICommonActionExtensionSite actionSite;

    public UndeployAction(ISelection selection, ICommonActionExtensionSite actionSite) {
        this.setText("Undeploy");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.selection = selection;
        this.actionSite = actionSite;
    }

    public void runWithEvent(Event event) {
        TreeSelection ts;
        Object obj;
        if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof TreeNode) {
            final TreeNode module = (TreeNode)obj;
            DeployedApplicationsNode target = (DeployedApplicationsNode)module.getParent();
            try {
                final GlassFishServerBehaviour be = target.getServer().getServerBehaviourAdapter();
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            IServer server = be.getServer();
                            IModule[] im = server.getModules();
                            IModule imodule = null;
                            int i = 0;
                            while (i < im.length) {
                                if (im[i].getName().equals(module.getName())) {
                                    imodule = im[i];
                                }
                                ++i;
                            }
                            if (imodule == null) {
                                be.undeploy(module.getName(), monitor);
                                return;
                            }
                            try {
                                IServerWorkingCopy wc = server.createWorkingCopy();
                                wc.modifyModules(null, new IModule[]{imodule}, monitor);
                                server = wc.save(true, monitor);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            if (server.getServerState() != 4 && ServerUIPlugin.getPreferences().getPublishOnAddRemoveModule()) {
                                IAdaptable info = new IAdaptable(){

                                    public <T> T getAdapter(Class<T> adapter) {
                                        if (Shell.class.equals(adapter)) {
                                            return adapter.cast(Display.getDefault().getActiveShell());
                                        }
                                        return null;
                                    }
                                };
                                server.publish(1, null, info, null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                Shell shell = Display.getDefault().getActiveShell();
                if (shell != null) {
                    new ProgressMonitorDialog(shell).run(true, false, op);
                }
                target.refresh();
                StructuredViewer view = this.actionSite.getStructuredViewer();
                view.refresh((Object)target);
                Server server = (Server)be.getServer();
                server.setModulePublishState(server.getModules(), 3);
            }
            catch (Exception exception) {}
        }
        super.run();
    }

    public void run() {
        this.runWithEvent(null);
    }
}

