/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.IGlassfishRuntimeModel;
import org.eclipse.glassfish.tools.RuntimeConfigurator;
import org.eclipse.glassfish.tools.exceptions.UniqueNameNotFound;
import org.eclipse.glassfish.tools.ui.wizards.GlassfishSapphireWizardFragment;
import org.eclipse.glassfish.tools.ui.wizards.GlassfishWizardResources;
import org.eclipse.sapphire.Element;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;

public class GlassfishSapphireRuntimeWizardFragment
extends GlassfishSapphireWizardFragment {
    @Override
    protected String getTitle() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        return runtime.getRuntimeType().getName();
    }

    @Override
    protected String getDescription() {
        return GlassfishWizardResources.wzdRuntimeDescription;
    }

    @Override
    protected Element getModel() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        GlassFishRuntime runtimeDelegate = (GlassFishRuntime)runtime.loadAdapter(GlassFishRuntime.class, null);
        IGlassfishRuntimeModel model = runtimeDelegate.getModel();
        return model;
    }

    @Override
    public void enter() {
        super.enter();
    }

    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime.getOriginal() == null) {
            try {
                runtime.setName(RuntimeConfigurator.createUniqueRuntimeName((String)runtime.getRuntimeType().getName()));
            }
            catch (UniqueNameNotFound uniqueNameNotFound) {
                runtime.setName(runtime.getRuntimeType().getName());
            }
        }
    }

    @Override
    protected String getUserInterfaceDef() {
        return "glassfish.runtime";
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        runtime.save(true, monitor);
        ((RuntimeWorkingCopy)runtime).dispose();
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        super.performCancel(monitor);
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        ((RuntimeWorkingCopy)runtime).dispose();
    }

    @Override
    protected String getInitialFocus() {
        return IGlassfishRuntimeModel.PROP_NAME.name();
    }
}

