/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.wizards;

import org.eclipse.glassfish.tools.ui.GlassfishToolsUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public abstract class GlassfishSapphireWizardFragment
extends WizardFragment {
    private IWizardHandle wizard;
    private Composite composite;
    private SapphireForm form;

    public GlassfishSapphireWizardFragment() {
        this.setComplete(false);
    }

    public final boolean hasComposite() {
        return true;
    }

    protected abstract String getTitle();

    protected abstract String getDescription();

    protected abstract Element getModel();

    protected abstract String getUserInterfaceDef();

    protected abstract String getInitialFocus();

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.wizard = handle;
        this.wizard.setTitle(this.getTitle());
        this.wizard.setDescription(this.getDescription());
        this.wizard.setImageDescriptor(this.getImageDescriptor());
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)GridLayoutUtil.glayout((int)1, (int)0, (int)0));
        this.render();
        return this.composite;
    }

    public void enter() {
        super.enter();
        this.render();
    }

    protected Composite render() {
        if (this.form != null) {
            this.form.dispose();
        }
        this.form = new SapphireForm(this.composite, this.getModel(), DefinitionLoader.context(GlassfishSapphireWizardFragment.class).sdef("org.eclipse.glassfish.tools.ui.GlassfishUI").form(this.getUserInterfaceDef()));
        this.form.part().attach((Listener)new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GlassfishSapphireWizardFragment.this.refreshStatus();
                    }
                });
            }
        });
        this.form.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.form.part().setFocus(this.getInitialFocus());
        this.composite.layout(true, true);
        this.refreshStatus();
        return this.form;
    }

    private void refreshStatus() {
        Status status = this.form.part().validation();
        if (status.severity() == Status.Severity.ERROR) {
            this.wizard.setMessage(status.message(), 3);
            this.setComplete(false);
        } else if (status.severity() == Status.Severity.WARNING) {
            this.wizard.setMessage(status.message(), 2);
            this.setComplete(true);
        } else {
            this.wizard.setMessage(null, 0);
            this.setComplete(true);
        }
        this.wizard.update();
    }

    protected ImageDescriptor getImageDescriptor() {
        return GlassfishToolsUIPlugin.getInstance().getImageRegistry().getDescriptor("wizard.img");
    }
}

