/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.ServerStatus;
import org.eclipse.glassfish.tools.utils.ServerStatusHelper;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class GlassfishTestConnectionAction
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        IServerWorkingCopy wc = (IServerWorkingCopy)context.part().getModelElement().adapt(IServerWorkingCopy.class);
        GlassFishServer glassfish = (GlassFishServer)wc.loadAdapter(GlassFishServer.class, null);
        ServerStatus s = ServerStatusHelper.checkServerStatus((GlassFishServer)glassfish);
        if (!s.equals((Object)ServerStatus.RUNNING_DOMAIN_MATCHING)) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Cannot communicate with ");
            errorMessage.append(glassfish.getServer().getHost());
            errorMessage.append(":");
            errorMessage.append(glassfish.getAdminPort());
            errorMessage.append(" remote server.");
            if (s.equals((Object)ServerStatus.STOPPED_NOT_LISTENING)) {
                errorMessage.append(" Is it up?");
            } else if (s.equals((Object)ServerStatus.RUNNING_REMOTE_NOT_SECURE)) {
                errorMessage.append(" Is it secure? (Hint: run asadmin enable-secure-admin)");
            } else if (s.equals((Object)ServerStatus.RUNNING_CREDENTIAL_PROBLEM)) {
                errorMessage.append(" Wrong user name or password. Check your credentials.");
            } else if (s.equals((Object)ServerStatus.RUNNING_PROXY_ERROR)) {
                errorMessage.append(" Check your proxy settings.");
            } else if (s.equals((Object)ServerStatus.RUNNING_CONNECTION_ERROR)) {
                errorMessage.append(" Is it up?");
                errorMessage.append(" Is it secure? (Hint: run asadmin enable-secure-admin)");
            }
            Status status = new Status(4, "org.eclipse.glassfish.tools", errorMessage.toString());
            MessageDialog.openMessage((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error connecting to remote server", (IStatus)status);
        } else {
            String remoteServerVersion = GlassFishServerBehaviour.getVersion((GlassFishServer)glassfish);
            GlassFishRuntime gfRuntime = (GlassFishRuntime)wc.getRuntime().getAdapter(GlassFishRuntime.class);
            String thisServerVersion = gfRuntime.getVersion().toString();
            int n = thisServerVersion.indexOf(".X");
            if (n > 0) {
                thisServerVersion = thisServerVersion.substring(0, n + 1);
            }
            if (remoteServerVersion != null && remoteServerVersion.indexOf(thisServerVersion) < 0) {
                String errorMessage = "The remote server version is " + remoteServerVersion;
                Status status = new Status(4, "org.eclipse.glassfish.tools", errorMessage.toString());
                MessageDialog.openMessage((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)Messages.versionsNotMatching, (IStatus)status);
            } else {
                MessageDialog.openMessage((Shell)Display.getDefault().getActiveShell(), (String)"Connection successful", (String)"Connection to server was successful", (IStatus)new Status(1, "org.eclipse.glassfish.tools", "Connection to server was successful"));
            }
        }
        return null;
    }
}

