/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.glassfish.tools.AssembleModules;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;

public class ExportJavaEEArchive {
    public static File export(IModule module, IProgressMonitor monitor) throws ExecutionException {
        File root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        IProject p = module.getProject();
        File archiveName = null;
        IDataModel dataModel = null;
        if (AssembleModules.isModuleType(module, "jst.web")) {
            dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentExportDataModelProvider());
            archiveName = new File(root, String.valueOf(p.getName()) + ".war");
        } else if (AssembleModules.isModuleType(module, "jst.ear")) {
            dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentExportDataModelProvider());
            archiveName = new File(root, String.valueOf(p.getName()) + ".ear");
        } else {
            dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentExportDataModelProvider());
            archiveName = new File(root, String.valueOf(p.getName()) + ".jar");
        }
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)p.getName());
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", (Object)false);
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", (Object)true);
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)archiveName.getAbsolutePath());
        dataModel.getDefaultOperation().execute(monitor, null);
        return archiveName;
    }
}

