/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.glassfish.tools.internal.ManifestUtil;
import org.eclipse.glassfish.tools.internal.SystemLibrariesSetting;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public final class GlassFishInstall {
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}(\\.[0-9])?(\\.[0-9])?)(\\..*)?");
    private static final String[] LIBRARIES_3_1 = new String[]{"glassfish/modules/javax.*.jar", "glassfish/modules/weld-osgi-bundle.jar", "glassfish/modules/bean-validator.jar", "glassfish/modules/jersey-*.jar", "glassfish/modules/grizzly-comet.jar", "glassfish/modules/grizzly-websockets.jar", "glassfish/modules/glassfish-api.jar", "glassfish/modules/ha-api.jar", "glassfish/modules/endorsed/*.jar", "glassfish/modules/jsf-api.jar", "glassfish/modules/jsf-impl.jar", "glassfish/modules/jstl-impl.jar", "glassfish/modules/org.eclipse.persistence*.jar", "glassfish/modules/jaxb*.jar", "glassfish/modules/webservices*.jar", "glassfish/modules/woodstox-osgi*.jar", "mq/lib/jaxm-api*.jar"};
    private static final String[] LIBRARIES_3_1_2 = new String[]{"glassfish/modules/javax.*.jar", "glassfish/modules/weld-osgi-bundle.jar", "glassfish/modules/bean-validator.jar", "glassfish/modules/jersey-*.jar", "glassfish/modules/grizzly-comet.jar", "glassfish/modules/grizzly-websockets.jar", "glassfish/modules/glassfish-api.jar", "glassfish/modules/ha-api.jar", "glassfish/modules/endorsed/*.jar", "glassfish/modules/org.eclipse.persistence*.jar", "glassfish/modules/jaxb*.jar", "glassfish/modules/webservices*.jar", "glassfish/modules/woodstox-osgi*.jar", "mq/lib/jaxm-api*.jar"};
    private static final String[] LIBRARIES_4 = new String[]{"glassfish/modules/javax.*.jar", "glassfish/modules/weld-osgi-bundle.jar", "glassfish/modules/bean-validator.jar", "glassfish/modules/jersey-*.jar", "glassfish/modules/glassfish-api.jar", "glassfish/modules/ha-api.jar", "glassfish/modules/endorsed/*.jar", "glassfish/modules/org.eclipse.persistence*.jar", "glassfish/modules/jaxb*.jar", "glassfish/modules/webservices*.jar", "glassfish/modules/cdi-api.jar", "mq/lib/jaxm-api.jar"};
    private static final String[] LIBRARIES_5 = new String[]{"glassfish/modules/javax.*.jar", "glassfish/modules/jakarta.*.jar", "glassfish/modules/weld-osgi-bundle.jar", "glassfish/modules/bean-validator.jar", "glassfish/modules/jersey-*.jar", "glassfish/modules/glassfish-api.jar", "glassfish/modules/ha-api.jar", "glassfish/modules/endorsed/*.jar", "glassfish/modules/org.eclipse.persistence*.jar", "glassfish/modules/jaxb*.jar", "glassfish/modules/webservices*.jar", "glassfish/modules/cdi-api.jar", "mq/lib/jaxm-api.jar"};
    private String versionString = null;
    private static final String RUNTIME_COMPONENT_ID = "glassfish";
    private static final Map<File, SoftReference<GlassFishInstall>> CACHE = new HashMap<File, SoftReference<GlassFishInstall>>();
    private final File location;
    private final Version version;
    private final List<File> libraries;

    public static synchronized GlassFishInstall find(File location) {
        Iterator<Map.Entry<File, SoftReference<GlassFishInstall>>> itr = CACHE.entrySet().iterator();
        while (itr.hasNext()) {
            if (itr.next().getValue().get() != null) continue;
            itr.remove();
        }
        GlassFishInstall gf = null;
        if (location != null) {
            SoftReference<GlassFishInstall> ref = CACHE.get(location);
            if (ref != null) {
                gf = ref.get();
            }
            if (gf == null) {
                try {
                    gf = new GlassFishInstall(location);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                CACHE.put(location, new SoftReference<GlassFishInstall>(gf));
            }
        }
        return gf;
    }

    public static synchronized GlassFishInstall find(IRuntimeComponent component) {
        String location;
        if (component != null && component.getRuntimeComponentType().getId().equals(RUNTIME_COMPONENT_ID) && (location = component.getProperty("location")) != null) {
            return GlassFishInstall.find(new File(location));
        }
        return null;
    }

    public static synchronized GlassFishInstall find(IRuntime runtime) {
        if (runtime != null) {
            for (IRuntimeComponent component : runtime.getRuntimeComponents()) {
                GlassFishInstall gf = GlassFishInstall.find(component);
                if (gf == null) continue;
                return gf;
            }
        }
        return null;
    }

    public static synchronized GlassFishInstall find(IFacetedProject project) {
        IRuntime primary;
        if (project != null && (primary = project.getPrimaryRuntime()) != null) {
            GlassFishInstall gf = GlassFishInstall.find(primary);
            if (gf != null) {
                return gf;
            }
            for (IRuntime runtime : project.getTargetedRuntimes()) {
                if (runtime == primary || (gf = GlassFishInstall.find(runtime)) == null) continue;
                return gf;
            }
        }
        return null;
    }

    public static synchronized GlassFishInstall find(IProject project) {
        if (project != null) {
            IFacetedProject fproj = null;
            try {
                fproj = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {}
            if (fproj != null) {
                return GlassFishInstall.find(fproj);
            }
        }
        return null;
    }

    public static synchronized GlassFishInstall find(IJavaProject project) {
        if (project != null) {
            return GlassFishInstall.find(project.getProject());
        }
        return null;
    }

    private GlassFishInstall(File location) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!location.exists()) {
            throw new IllegalArgumentException();
        }
        if (!location.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File gfApiJar = new File(location, "modules/glassfish-api.jar");
        if (!gfApiJar.exists()) {
            throw new IllegalArgumentException();
        }
        if (!gfApiJar.isFile()) {
            throw new IllegalArgumentException();
        }
        try {
            this.versionString = ManifestUtil.readManifestEntry(gfApiJar, "Bundle-Version");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Matcher versionMatcher = VERSION_PATTERN.matcher(this.versionString);
        if (!versionMatcher.matches()) {
            throw new IllegalArgumentException();
        }
        String partialVersionString = versionMatcher.group(1);
        this.location = location;
        this.version = new Version(partialVersionString);
        ListFactory librariesListFactory = ListFactory.start();
        Object libraryIncludes = this.version.matches("[5") ? LIBRARIES_5 : (this.version.matches("[4-5)") ? LIBRARIES_4 : (this.version.matches("[3.1.2-4)") ? LIBRARIES_3_1_2 : (this.version.matches("[3.1-3.1.2)") ? LIBRARIES_3_1 : null)));
        if (libraryIncludes != null) {
            File parentFolderToLocation = this.location.getParentFile();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(parentFolderToLocation);
            scanner.setIncludes(libraryIncludes);
            scanner.scan();
            String[] stringArray = scanner.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String libraryRelativePath = stringArray[n2];
                librariesListFactory.add((Object)new File(parentFolderToLocation, libraryRelativePath));
                ++n2;
            }
        }
        this.libraries = librariesListFactory.result();
    }

    public File location() {
        return this.location;
    }

    public Version version() {
        return this.version;
    }

    public String versionString() {
        return this.versionString;
    }

    public List<File> libraries() {
        return this.libraries;
    }

    public List<IClasspathEntry> classpath(IProject proj) {
        URL doc;
        ListFactory classpathListFactory = ListFactory.start();
        String v = this.version.matches("[5") ? "8" : (this.version.matches("[4") ? "7" : "6");
        try {
            doc = new URL("http://docs.oracle.com/javaee/" + v + "/api/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        SystemLibrariesSetting libSettings = SystemLibrariesSetting.load(proj);
        for (File library : this.libraries) {
            File srcPath = libSettings != null ? libSettings.getSourcePath(library) : null;
            classpathListFactory.add((Object)GlassFishInstall.createLibraryEntry((IPath)new Path(library.toString()), srcPath, doc));
        }
        List classpath = classpathListFactory.result();
        return classpath;
    }

    private static IClasspathEntry createLibraryEntry(IPath library, File src, URL javadoc) {
        Path srcpath = src == null ? null : new Path(src.getAbsolutePath());
        IAccessRule[] access = new IAccessRule[]{};
        IClasspathAttribute[] attrs = javadoc == null ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadoc.toExternalForm())};
        return JavaCore.newLibraryEntry((IPath)library, (IPath)srcpath, null, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
    }
}

