/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.glassfish.tools.GlassFishInstall;
import org.eclipse.glassfish.tools.IGlassfishRuntimeModel;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.utils.JdtUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public final class GlassFishRuntime
extends RuntimeDelegate
implements IJavaRuntime {
    public static final String TYPE_ID = "glassfish";
    public static final IRuntimeType TYPE = ServerCore.findRuntimeType((String)"glassfish");
    public static final String ATTR_SERVER_ROOT = "server.root";
    public static final String ATTR_SERVER_JDK = "server.jdk";
    public static final boolean IS_MACOSX = "macosx".equals(Platform.getOS());
    public static final String DEFAULT_JRE_KEY = "###DefaultJREForGlassFishCode###";
    private static final VersionConstraint VERSION_CONSTRAINT_3_1 = new VersionConstraint("[1.6-1.7]");
    private static final VersionConstraint VERSION_CONSTRAINT_4 = new VersionConstraint("[1.7");
    private static final VersionConstraint VERSION_CONSTRAINT_5 = new VersionConstraint("[1.8");
    private IGlassfishRuntimeModel model;

    public static String createDefaultRuntimeName(Version version) {
        String baseName = "GlassFish";
        if (version != null) {
            if (version.matches("[5-6)")) {
                baseName = String.valueOf(baseName) + " 5";
            } else if (version.matches("[4-5)")) {
                baseName = String.valueOf(baseName) + " 4";
            } else if (version.matches("[3.1-4)")) {
                baseName = String.valueOf(baseName) + " 3.1";
            }
        }
        int counter = 1;
        String name;
        while (ServerCore.findRuntime((String)(name = GlassFishRuntime.createDefaultRuntimeName(baseName, counter))) != null) {
            ++counter;
        }
        return name;
    }

    private static String createDefaultRuntimeName(String baseName, int counter) {
        StringBuilder buf = new StringBuilder();
        buf.append(baseName);
        if (counter != 1) {
            buf.append(" (");
            buf.append(counter);
            buf.append(')');
        }
        return buf.toString();
    }

    public Version getVersion() {
        GlassFishInstall gfInstall;
        IPath location = this.getRuntime().getLocation();
        if (location != null && (gfInstall = GlassFishInstall.find(location.toFile())) != null) {
            return gfInstall.version();
        }
        return null;
    }

    public IStatus validateVersion() {
        Version version = this.getVersion();
        if (version == null) {
            return new Status(4, "org.eclipse.glassfish.tools", Messages.runtimeNotValid);
        }
        if (!version.matches("[3.1-6)")) {
            return new Status(4, "org.eclipse.glassfish.tools", Messages.unsupportedVersion);
        }
        return Status.OK_STATUS;
    }

    public VersionConstraint getJavaVersionConstraint() {
        Version version = this.getVersion();
        if (version != null) {
            if (version.matches("[5")) {
                return VERSION_CONSTRAINT_5;
            }
            if (version.matches("[4")) {
                return VERSION_CONSTRAINT_4;
            }
            return VERSION_CONSTRAINT_3_1;
        }
        return null;
    }

    public synchronized IGlassfishRuntimeModel getModel() {
        if (this.model == null) {
            this.model = (IGlassfishRuntimeModel)IGlassfishRuntimeModel.TYPE.instantiate((Resource)new ConfigResource(this.getRuntime()));
            this.model.initialize();
        }
        return this.model;
    }

    public IVMInstall getVMInstall() {
        return JdtUtil.findOrCreateJvm(this.getModel().getJavaRuntimeEnvironment().text());
    }

    public boolean isUsingDefaultJRE() {
        return false;
    }

    IStatus validateServerLocation() {
        IPath location = this.getRuntime().getLocation();
        if (location == null || !location.toFile().exists()) {
            return new Status(4, "org.eclipse.glassfish.tools", NLS.bind((String)Messages.pathDoesNotExist, (Object)"Specified path"));
        }
        GlassFishInstall gfInstall = GlassFishInstall.find(location.toFile());
        if (gfInstall == null) {
            return new Status(4, "org.eclipse.glassfish.tools", Messages.notValidGlassfishInstall);
        }
        return Status.OK_STATUS;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (status.isOK()) {
            status = StatusBridge.create((org.eclipse.sapphire.modeling.Status)this.getModel().validation());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        GlassFishRuntime glassFishRuntime = this;
        synchronized (glassFishRuntime) {
            if (this.model != null) {
                this.model.dispose();
                this.model = null;
            }
        }
    }

    private static final class AttributeValueBinding
    extends ValuePropertyBinding {
        private final IRuntime runtime;
        private final String attribute;

        public AttributeValueBinding(IRuntime runtime, String attribute) {
            this.runtime = runtime;
            this.attribute = attribute;
        }

        public String read() {
            return ((Runtime)this.runtime).getAttribute(this.attribute, null);
        }

        public void write(String value) {
            if (!(this.runtime instanceof RuntimeWorkingCopy)) {
                throw new UnsupportedOperationException();
            }
            RuntimeWorkingCopy wc = (RuntimeWorkingCopy)this.runtime;
            wc.setAttribute(this.attribute, value);
        }
    }

    private static final class ConfigResource
    extends Resource {
        private final IRuntime runtime;

        public ConfigResource(IRuntime runtime) {
            super(null);
            if (runtime == null) {
                throw new IllegalArgumentException();
            }
            this.runtime = runtime;
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == IGlassfishRuntimeModel.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return runtime.getName();
                    }

                    public void write(String value) {
                        if (!(runtime instanceof RuntimeWorkingCopy)) {
                            throw new UnsupportedOperationException();
                        }
                        RuntimeWorkingCopy wc = (RuntimeWorkingCopy)runtime;
                        wc.setName(value);
                    }
                };
            }
            if (p == IGlassfishRuntimeModel.PROP_JAVA_RUNTIME_ENVIRONMENT) {
                return new AttributeValueBinding(this.runtime, GlassFishRuntime.ATTR_SERVER_JDK);
            }
            if (p == IGlassfishRuntimeModel.PROP_SERVER_ROOT) {
                return new ValuePropertyBinding(){

                    public String read() {
                        IPath path = runtime.getLocation();
                        return path == null ? null : path.toOSString();
                    }

                    public void write(String value) {
                        if (!(runtime instanceof RuntimeWorkingCopy)) {
                            throw new UnsupportedOperationException();
                        }
                        RuntimeWorkingCopy wc = (RuntimeWorkingCopy)runtime;
                        Path path = value == null ? Path.EMPTY : new Path(value);
                        wc.setLocation((IPath)path);
                    }
                };
            }
            throw new IllegalStateException();
        }

        public <A> A adapt(Class<A> adapterType) {
            if (adapterType == IRuntime.class) {
                return adapterType.cast(this.runtime);
            }
            return (A)super.adapt(adapterType);
        }
    }
}

