/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.glassfish.tools.GlassFishInstall;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.IGlassfishServerModel;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.facets.IGlassfishWebDeploymentDescriptor;
import org.eclipse.glassfish.tools.facets.internal.GlassfishDeploymentDescriptorFactory;
import org.eclipse.glassfish.tools.sdk.data.GlassFishAdminInterface;
import org.eclipse.glassfish.tools.sdk.server.parser.HttpData;
import org.eclipse.glassfish.tools.sdk.server.parser.HttpListenerReader;
import org.eclipse.glassfish.tools.sdk.server.parser.NetworkListenerReader;
import org.eclipse.glassfish.tools.sdk.server.parser.TargetConfigNameReader;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.utils.ModuleUtil;
import org.eclipse.glassfish.tools.utils.Utils;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public final class GlassFishServer
extends ServerDelegate
implements IURLProvider {
    public static final String TYPE_ID = "glassfish.server";
    public static final IServerType TYPE = ServerCore.findServerType((String)"glassfish.server");
    private static final String DEFAULT_DOMAIN_DIR_NAME = "domains";
    private static final String DEFAULT_DOMAIN_NAME = "domain1";
    public static final int DEFAULT_DEBUG_PORT = 9009;
    public static final String ATTR_SERVER_ADDRESS = "server.address";
    public static final String ATTR_SERVERPORT = "glassfish.serverportnumber";
    public static final String ATTR_ADMINPORT = "glassfish.adminserverportnumber";
    public static final String ATTR_DEBUG_PORT = "glassfish.debugport";
    public static final String ATTR_USECUSTOMTARGET = "glassfish.usecustomtarget";
    public static final String ATTR_DOMAINPATH = "glassfish.domainpath";
    public static final String ATTR_ADMIN = "glassfish.adminname";
    public static final String ATTR_ADMINPASS = "glassfish.adminpassword";
    public static final String ATTR_KEEPSESSIONS = "glassfish.keepSessions";
    public static final String ATTR_JARDEPLOY = "glassfish.jarDeploy";
    public static final String ATTR_USEANONYMOUSCONNECTIONS = "glassfish.useAnonymousConnection";
    public static final String SAMPLEDBDIR = "glassfish.sampledbdir";
    public static final String CONTEXTROOT = "glassfish.contextroot";
    public static final String DOMAINUPDATE = "domainupdate";
    private List<PropertyChangeListener> propChangeListeners;
    private IGlassfishServerModel model;

    protected void initialize() {
        GlassfishToolsPlugin.logMessage("in GlassFishServer initialize" + this.getServer().getName());
        if (this.getServerWorkingCopy() != null) {
            this.readDomainConfig();
        }
        this.model = (IGlassfishServerModel)IGlassfishServerModel.TYPE.instantiate((Resource)new ConfigResource(this.getServerWorkingCopy()));
    }

    public GlassFishServerBehaviour getServerBehaviourAdapter() {
        GlassFishServerBehaviour serverBehavior = (GlassFishServerBehaviour)this.getServer().getAdapter(GlassFishServerBehaviour.class);
        if (serverBehavior == null) {
            serverBehavior = (GlassFishServerBehaviour)this.getServer().loadAdapter(GlassFishServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return serverBehavior;
    }

    public IGlassfishServerModel getModel() {
        return this.model;
    }

    public static IPath getDefaultDomainDir(IPath serverLocation) {
        return serverLocation.append(DEFAULT_DOMAIN_DIR_NAME).append(DEFAULT_DOMAIN_NAME);
    }

    public static String createServerNameWithDomain(String serverName, Path domain) {
        int domainStartPos = serverName.lastIndexOf("[");
        if (domainStartPos == -1) {
            return String.valueOf(serverName) + " [" + domain.lastSegment() + "]";
        }
        return String.valueOf(serverName.substring(0, domainStartPos)) + "[" + domain.lastSegment() + "]";
    }

    public boolean isRemote() {
        return this.getServer().getServerType().supportsRemoteHosts() && !SocketUtil.isLocalhost((String)this.getServer().getHost());
    }

    protected String getDebugOptions(int debugPort) {
        Version version = this.getVersion();
        if (version.matches("[4")) {
            return "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort;
        }
        return "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + debugPort;
    }

    protected void readDomainConfig() {
        if (!this.isRemote()) {
            if (this.readServerConfiguration(new File(String.valueOf(this.getDomainsFolder()) + File.separator + this.getDomainName() + "/config/domain.xml"))) {
                GlassfishToolsPlugin.logMessage("in glassfish initialize done readServerConfiguration");
                this.syncHostAndPortsValues();
            } else {
                GlassfishToolsPlugin.logMessage("in glassfish could not readServerConfiguration - probably invalid domain");
            }
        }
    }

    public String validateDomainExists(String domainPath) {
        if (this.isRemote()) {
            return null;
        }
        if (domainPath != null && !domainPath.startsWith("${")) {
            File f = new File(domainPath);
            if (!f.exists()) {
                return MessageFormat.format(Messages.pathDoesNotExist, f.getAbsolutePath());
            }
            if (!f.isDirectory()) {
                return MessageFormat.format(Messages.pathNotDirectory, f.getAbsolutePath());
            }
            if (!Utils.canWrite(f)) {
                return MessageFormat.format(Messages.pathNotWritable, f.getAbsolutePath());
            }
            File configDir = new File(f, "config");
            if (!configDir.exists()) {
                return MessageFormat.format(Messages.pathDoesNotExist, configDir.getAbsolutePath());
            }
            if (!configDir.canWrite()) {
                return MessageFormat.format(Messages.pathNotWritable, configDir.getAbsolutePath());
            }
            File domain = new File(f, "config/domain.xml");
            if (!domain.exists()) {
                return MessageFormat.format(Messages.pathNotValidDomain, domain.getAbsolutePath());
            }
            return null;
        }
        return Messages.missingDomainLocation;
    }

    IStatus validateDomainLocation() {
        if (this.isRemote()) {
            return Status.OK_STATUS;
        }
        String domainPath = this.getDomainPath();
        String domainConfigPath = String.valueOf(domainPath) + File.separator + "config" + File.separator + "domain.xml";
        File domainConfigLocation = new File(domainConfigPath);
        if (!domainConfigLocation.exists()) {
            return new Status(4, "org.eclipse.glassfish.tools", Messages.pathNotValidDomain);
        }
        File domainLocation = domainConfigLocation.getParentFile().getParentFile();
        if (!Utils.canWrite(domainLocation)) {
            return new Status(4, "org.eclipse.glassfish.tools", NLS.bind((String)Messages.pathNotWritable, (Object)domainLocation.getAbsolutePath()));
        }
        File domainConfigDir = domainConfigLocation.getParentFile();
        if (!Utils.canWrite(domainConfigDir)) {
            return new Status(4, "org.eclipse.glassfish.tools", NLS.bind((String)Messages.pathNotWritable, (Object)domainConfigDir.getAbsolutePath()));
        }
        return Status.OK_STATUS;
    }

    public IStatus validate() {
        GlassfishToolsPlugin.logMessage("in AbstractGlassfishServer validate");
        IStatus s = null;
        if (!this.isRemote()) {
            s = this.validateDomainLocation();
            if (!s.isOK()) {
                return s;
            }
            IServer[] iServerArray = ServerCore.getServers();
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                if (!server.getId().equals(this.getServer().getId()) && server.getServerType() == this.getServer().getServerType()) {
                    File p2;
                    GlassFishServer gfServer = (GlassFishServer)((Object)server.loadAdapter(GlassFishServer.class, null));
                    File p1 = new File(this.getDomainPath());
                    if (p1.equals(p2 = new File(gfServer.getDomainPath()))) {
                        return new Status(4, "org.eclipse.glassfish.tools", Messages.serverWithSameDomainPathExisting);
                    }
                }
                ++n2;
            }
            this.readDomainConfig();
            if (this.getAdminPort() == -1) {
                return new Status(4, "org.eclipse.glassfish.tools", Messages.invalidPortNumbers);
            }
            this.getModel().setAdminPort(this.getAdminPort());
            this.getModel().setServerPort(this.getPort());
        }
        return Status.OK_STATUS;
    }

    private void syncHostAndPortsValues() {
        System.err.println("syncHostAndPortsValues");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeListeners == null) {
            this.propChangeListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeListeners != null) {
            this.propChangeListeners.remove(listener);
        }
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propChangeListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        try {
            Iterator<PropertyChangeListener> iterator = this.propChangeListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logError("Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logError("Error in property event", e);
        }
    }

    public static GlassFishServer getGlassfishServerDelegate(IServerWorkingCopy server) {
        GlassFishServer glassfishDelegate = (GlassFishServer)((Object)server.getOriginal().getAdapter(GlassFishServer.class));
        if (glassfishDelegate == null) {
            glassfishDelegate = (GlassFishServer)((Object)server.getOriginal().loadAdapter(GlassFishServer.class, (IProgressMonitor)new NullProgressMonitor()));
        }
        return glassfishDelegate;
    }

    public ServerPort[] getServerPorts() {
        try {
            ServerPort[] sp = new ServerPort[]{new ServerPort("adminserver", "Admin Server Port", this.getAdminPort(), "HTTP"), new ServerPort("server", "Server Port", this.getPort(), "HTTP")};
            return sp;
        }
        catch (Exception exception) {
            return new ServerPort[0];
        }
    }

    protected boolean readServerConfiguration(File domainXml) {
        boolean result = false;
        LinkedHashMap<String, HttpData> httpMap = new LinkedHashMap<String, HttpData>();
        if (domainXml.exists()) {
            TargetConfigNameReader configNameReader = new TargetConfigNameReader();
            TreeParser.readXml(domainXml, configNameReader);
            String configName = configNameReader.getTargetConfigName();
            if (configName == null) {
                return false;
            }
            HttpListenerReader httpListenerReader = new HttpListenerReader(configName);
            NetworkListenerReader networkListenerReader = new NetworkListenerReader(configName);
            try {
                TreeParser.readXml(domainXml, httpListenerReader, networkListenerReader);
                httpMap.putAll(httpListenerReader.getResult());
                httpMap.putAll(networkListenerReader.getResult());
                HttpData adminData = (HttpData)httpMap.remove("admin-listener");
                int adminPort = adminData != null ? adminData.getPort() : -1;
                this.setAttribute(ATTR_ADMINPORT, String.valueOf(adminPort));
                GlassfishToolsPlugin.logMessage("reading from domain.xml adminServerPortNumber=" + this.getAdminPort());
                HttpData httpPortData = (HttpData)httpMap.remove("http-listener-1");
                int httpPort = httpPortData != null ? httpPortData.getPort() : -1;
                this.setAttribute(ATTR_SERVERPORT, String.valueOf(httpPort));
                result = adminPort != -1;
            }
            catch (IllegalStateException ex) {
                GlassfishToolsPlugin.logError("error IllegalStateException ", ex);
            }
        }
        return result;
    }

    public String getDomainConfigurationFilePath() {
        return String.valueOf(this.getDomainPath().trim()) + "/config/domain.xml";
    }

    public int getDebugPort() {
        return this.getAttribute(ATTR_DEBUG_PORT, -1);
    }

    public int getAdminPort() {
        return this.getAttribute(ATTR_ADMINPORT, -1);
    }

    public String getAdminUser() {
        return this.getAttribute(ATTR_ADMIN, "admin");
    }

    public String getDomainsFolder() {
        if (!this.isRemote()) {
            return new File(this.getDomainPath()).getParent();
        }
        return null;
    }

    public String getDomainName() {
        return this.getDomainPath() != null ? new File(this.getDomainPath()).getName() : null;
    }

    public String getHost() {
        return this.getServer().getHost();
    }

    public String getName() {
        return this.getServer().getName();
    }

    public int getPort() {
        return this.getAttribute(ATTR_SERVERPORT, 8080);
    }

    public String getUrl() {
        return null;
    }

    public Version getVersion() {
        GlassFishInstall gfInstall;
        IPath location = this.getServer().getRuntime().getLocation();
        if (location != null && (gfInstall = GlassFishInstall.find(location.toFile())) != null) {
            return gfInstall.version();
        }
        return null;
    }

    public GlassFishAdminInterface getAdminInterface() {
        return GlassFishAdminInterface.HTTP;
    }

    public String getServerHome() {
        return new File(this.getServer().getRuntime().getLocation().toString()).getAbsolutePath();
    }

    public String getServerRoot() {
        return null;
    }

    public boolean getKeepSessions() {
        return this.getAttribute(ATTR_KEEPSESSIONS, true);
    }

    public String getAdminPassword() {
        return this.getAttribute(ATTR_ADMINPASS, "");
    }

    public void setAdminPassword(String value) {
        this.setAttribute(ATTR_ADMINPASS, value);
    }

    public String computePreserveSessions() {
        String ret = null;
        if (!this.getKeepSessions()) {
            return ret;
        }
        ret = "keepstate";
        return ret;
    }

    public boolean getJarDeploy() {
        if (this.isRemote()) {
            return true;
        }
        return this.getAttribute(ATTR_JARDEPLOY, false);
    }

    public void setPort(int port) {
        this.setAttribute(ATTR_SERVERPORT, port);
    }

    public String getDomainPath() {
        return this.getAttribute(ATTR_DOMAINPATH, "");
    }

    public boolean useAnonymousConnections() {
        return this.getAttribute(ATTR_USEANONYMOUSCONNECTIONS, true);
    }

    public String getServerInstallationDirectory() {
        return this.getServer().getRuntime().getLocation().toString();
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add == null || add.length == 0) {
            return Status.OK_STATUS;
        }
        IModule[] iModuleArray = add;
        int n = add.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (!this.isModuleSupported(module)) {
                return GlassfishToolsPlugin.createErrorStatus("Module is not supported on this server", null);
            }
            IStatus s = this.checkModule(module);
            if (s.getSeverity() == 4) {
                return s;
            }
            IModule[] root = this.doGetParentModules(module);
            if (root != null && root.length > 0 && root[0] != module) {
                return GlassfishToolsPlugin.createErrorStatus("Web module which is part of an Ear cannot be added as top level module to this server", null);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected boolean isModuleSupported(IModule module) {
        return ModuleUtil.isEARModule(module) || ModuleUtil.isWebModule(module) || ModuleUtil.isEJBModule(module);
    }

    public IModule[] getChildModules(IModule[] modulePath) {
        if (modulePath == null || modulePath.length == 0) {
            return new IModule[0];
        }
        IModule module = modulePath[modulePath.length - 1];
        if (module != null && module.getModuleType() != null) {
            IWebModule webModule;
            IModuleType moduleType = module.getModuleType();
            if (moduleType != null && "jst.ear".equals(moduleType.getId())) {
                IModule[] earModules;
                IEnterpriseApplication enterpriseApplication = (IEnterpriseApplication)module.loadAdapter(IEnterpriseApplication.class, null);
                if (enterpriseApplication != null && (earModules = enterpriseApplication.getModules()) != null) {
                    return earModules;
                }
            } else if (moduleType != null && "jst.web".equals(moduleType.getId()) && (webModule = (IWebModule)module.loadAdapter(IWebModule.class, null)) != null) {
                IModule[] modules = webModule.getModules();
                return modules;
            }
        }
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (!this.isModuleSupported(module)) {
            return null;
        }
        IModule[] parents = this.doGetParentModules(module);
        if (parents.length > 0) {
            return parents;
        }
        return new IModule[]{module};
    }

    private IModule[] doGetParentModules(IModule module) {
        IModule[] ears = ServerUtil.getModules((String)"jst.ear");
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < ears.length) {
            IEnterpriseApplication ear = (IEnterpriseApplication)ears[i].loadAdapter(IEnterpriseApplication.class, null);
            IModule[] childs = ear.getModules();
            int j = 0;
            while (j < childs.length) {
                if (childs[j].equals(module)) {
                    list.add(ears[i]);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }

    protected IStatus checkModule(IModule module) {
        return this.canSupportModule(module);
    }

    public IStatus canSupportModule(IModule module) {
        IProject proj = module.getProject();
        if (proj == null) {
            return GlassfishToolsPlugin.createErrorStatus("module type not supported", null);
        }
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)module.getProject());
            if (fproj != null) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = FacetUtil.getRuntime((IRuntime)this.getServer().getRuntime());
                if (runtime == null) {
                    return GlassfishToolsPlugin.createErrorStatus("cannot bridge runtimes", null);
                }
                for (IProjectFacetVersion fv : fproj.getProjectFacets()) {
                    if (runtime.supports(fv)) continue;
                    String msg = NLS.bind((String)Messages.facetNotSupported, (Object)fv.toString());
                    return GlassfishToolsPlugin.createErrorStatus(msg, null);
                }
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IModule[] iModuleArray = this.getChildModules(new IModule[]{module});
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule child = iModuleArray[n2];
            IStatus st = this.canSupportModule(child);
            if (st.getSeverity() == 4) {
                return st;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public URL getModuleRootURL(IModule module) {
        String protocol = Utils.getHttpListenerProtocol(this.getHost(), this.getPort());
        String path = this.getModuleRootPath(module);
        int serverPort = this.getMonitorPort(this.getPort());
        String hostname = this.getHost();
        try {
            return new URL(protocol, hostname, serverPort, path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getModuleRootPath(IModule module) {
        if (module == null || module.getProject() == null) {
            return "/";
        }
        if (Utils.hasProjectFacet(module, ProjectFacetsManager.getProjectFacet((String)"jst.web"))) {
            IModule[] rootEars = this.getRootEarModulesOnThisServer(module);
            if (rootEars != null && rootEars.length > 0) {
                return this.getModuleRootPath(module, rootEars[0]);
            }
            IGlassfishWebDeploymentDescriptor webDesc = GlassfishDeploymentDescriptorFactory.getWebDeploymentDescriptor(module.getProject());
            String path = webDesc.getContext();
            if (path != null) {
                return path;
            }
        }
        return "/" + J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
    }

    private String getModuleRootPath(IModule module, IModule parent) {
        String context = Utils.getAppWebContextRoot(parent, module);
        if (context != null && context.length() > 0) {
            try {
                context = URLEncoder.encode(context, "UTF-8");
                return "/" + context;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return "/";
    }

    private IModule[] getRootEarModulesOnThisServer(IModule module) {
        IModule[] ear = J2EEUtil.getEnterpriseApplications((IModule)module, null);
        if (ear != null && ear.length > 0) {
            ArrayList<IModule> ret = new ArrayList<IModule>();
            HashSet<IModule> allmodules = new HashSet<IModule>(Arrays.asList(this.getServer().getModules()));
            int i = 0;
            while (i < ear.length) {
                if (allmodules.contains(ear[i])) {
                    ret.add(ear[i]);
                }
                ++i;
            }
            return ret.toArray(new IModule[ret.size()]);
        }
        return null;
    }

    private int getMonitorPort(int configedPort) {
        ServerMonitorManager manager = ServerMonitorManager.getInstance();
        IMonitoredServerPort[] iMonitoredServerPortArray = manager.getMonitoredPorts(this.getServer());
        int n = iMonitoredServerPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitoredServerPort port = iMonitoredServerPortArray[n2];
            if (port.getServerPort().getPort() == configedPort) {
                return port.getMonitorPort();
            }
            ++n2;
        }
        return configedPort;
    }

    private static class AttributeValueBinding
    extends ValuePropertyBinding {
        private final IServerWorkingCopy wc;
        private final String attribute;

        public AttributeValueBinding(IServerWorkingCopy wc, String attribute) {
            this.wc = wc;
            this.attribute = attribute;
        }

        public String read() {
            return this.wc.getAttribute(this.attribute, null);
        }

        public void write(String value) {
            this.wc.setAttribute(this.attribute, value);
        }
    }

    private final class ConfigResource
    extends Resource {
        private final IServerWorkingCopy wc;

        public ConfigResource(IServerWorkingCopy wc) {
            super(null);
            this.wc = wc;
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == IGlassfishServerModel.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return ConfigResource.this.wc.getName();
                    }

                    public void write(String value) {
                        ConfigResource.this.wc.setName(value);
                    }
                };
            }
            if (p == IGlassfishServerModel.PROP_HOST_NAME) {
                return new ValuePropertyBinding(){
                    private PropertyChangeListener listener;

                    public void init(Property property) {
                        super.init(property);
                        this.listener = new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent event) {
                                if ("hostname".equals(event.getPropertyName())) {
                                    this.property().refresh();
                                }
                            }
                        };
                        ConfigResource.this.wc.addPropertyChangeListener(this.listener);
                    }

                    public String read() {
                        return ConfigResource.this.wc.getHost();
                    }

                    public void write(String value) {
                        ConfigResource.this.wc.setHost(value);
                    }

                    public void dispose() {
                        super.dispose();
                        ConfigResource.this.wc.removePropertyChangeListener(this.listener);
                        this.listener = null;
                    }
                };
            }
            if (p == IGlassfishServerModel.PROP_ADMIN_NAME) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_ADMIN);
            }
            if (p == IGlassfishServerModel.PROP_ADMIN_PASSWORD) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_ADMINPASS);
            }
            if (p == IGlassfishServerModel.PROP_ADMIN_PORT) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_ADMINPORT);
            }
            if (p == IGlassfishServerModel.PROP_DEBUG_PORT) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_DEBUG_PORT);
            }
            if (p == IGlassfishServerModel.PROP_SERVER_PORT) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_SERVERPORT);
            }
            if (p == IGlassfishServerModel.PROP_DOMAIN_PATH) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_DOMAINPATH);
            }
            if (p == IGlassfishServerModel.PROP_PRESERVE_SESSIONS) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_KEEPSESSIONS);
            }
            if (p == IGlassfishServerModel.PROP_USE_ANONYMOUS_CONNECTIONS) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_USEANONYMOUSCONNECTIONS);
            }
            if (p == IGlassfishServerModel.PROP_USE_JAR_DEPLOYMENT) {
                return new AttributeValueBinding(this.wc, GlassFishServer.ATTR_JARDEPLOY);
            }
            throw new IllegalStateException();
        }

        public <A> A adapt(Class<A> adapterType) {
            if (adapterType == IServerWorkingCopy.class) {
                return (A)this.wc;
            }
            return (A)super.adapt(adapterType);
        }
    }
}

