/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.glassfish.tools.AssembleModules;
import org.eclipse.glassfish.tools.ExportJavaEEArchive;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.ServerStatus;
import org.eclipse.glassfish.tools.StartupArgsImpl;
import org.eclipse.glassfish.tools.exceptions.GlassfishLaunchException;
import org.eclipse.glassfish.tools.exceptions.HttpPortUpdateException;
import org.eclipse.glassfish.tools.internal.GlassfishStateResolver;
import org.eclipse.glassfish.tools.internal.ServerStateListener;
import org.eclipse.glassfish.tools.internal.ServerStatusMonitor;
import org.eclipse.glassfish.tools.log.GlassfishConsoleManager;
import org.eclipse.glassfish.tools.log.IGlassFishConsole;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandAddResources;
import org.eclipse.glassfish.tools.sdk.admin.CommandDeploy;
import org.eclipse.glassfish.tools.sdk.admin.CommandGetProperty;
import org.eclipse.glassfish.tools.sdk.admin.CommandRedeploy;
import org.eclipse.glassfish.tools.sdk.admin.CommandStopDAS;
import org.eclipse.glassfish.tools.sdk.admin.CommandUndeploy;
import org.eclipse.glassfish.tools.sdk.admin.CommandVersion;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.ResultProcess;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.data.IdeContext;
import org.eclipse.glassfish.tools.sdk.server.FetchLogSimple;
import org.eclipse.glassfish.tools.sdk.server.ServerTasks;
import org.eclipse.glassfish.tools.utils.ResourceUtils;
import org.eclipse.glassfish.tools.utils.Utils;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.launching.JavaRemoteApplicationLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.PublishHelper;

public final class GlassFishServerBehaviour
extends ServerBehaviourDelegate
implements ServerStateListener {
    protected boolean needARedeploy = true;
    private GlassfishStateResolver stateResolver = new GlassfishStateResolver();
    private ServerStatusMonitor statusMonitor;
    private static final ExecutorService asyncJobsService = Executors.newCachedThreadPool();
    private static JavaRemoteApplicationLaunchConfigurationDelegate REMOTE_JAVA_APP_LAUNCH_DELEGATE = new JavaRemoteApplicationLaunchConfigurationDelegate();

    public GlassFishServerBehaviour() {
        GlassfishToolsPlugin.logMessage("in SunAppServerBehaviour CTOR ");
    }

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        GlassfishToolsPlugin.logMessage("in Behaviour initialize for " + this.getGlassfishServerDelegate().getName());
        GlassFishServer sunserver = this.getGlassfishServerDelegate();
        this.statusMonitor = ServerStatusMonitor.getInstance(sunserver, this);
        this.statusMonitor.start();
    }

    public void dispose() {
        super.dispose();
        this.statusMonitor.stop();
        GlassfishToolsPlugin.logMessage("in Behaviour dispose for " + this.getGlassfishServerDelegate().getName());
    }

    public IStatus canRestart(String mode) {
        if (this.getGlassfishServerDelegate().isRemote() && !mode.equals("debug")) {
            return new Status(4, "org.eclipse.glassfish.tools", "Restart remote Glassfish server is not supported");
        }
        return super.canRestart(mode);
    }

    public IStatus canStart(String launchMode) {
        if (this.getGlassfishServerDelegate().isRemote()) {
            return new Status(4, "org.eclipse.glassfish.tools", "Start remote Glassfish server is not supported");
        }
        return super.canStart(launchMode);
    }

    public IStatus canStop() {
        if (!this.getGlassfishServerDelegate().isRemote()) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.glassfish.tools", "Start remote Glassfish server is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStatusChanged(ServerStatus newStatus) {
        GlassFishServerBehaviour glassFishServerBehaviour = this;
        synchronized (glassFishServerBehaviour) {
            int currentState = this.getServer().getServerState();
            int nextState = this.stateResolver.resolve(newStatus, currentState);
            if (currentState != nextState) {
                this.setGFServerState(nextState);
                this.serverStateChanged(nextState);
                this.updateServerStatus(newStatus);
            }
            this.notify();
        }
    }

    private void serverStateChanged(int serverState) {
        switch (serverState) {
            case 2: {
                try {
                    this.updateHttpPort();
                    this.tryAttachDebug();
                }
                catch (HttpPortUpdateException e) {
                    GlassfishToolsPlugin.logError("Unable to update HTTP port for server startedoutside of IDE!", e);
                }
                break;
            }
            case 4: {
                this.setLaunch(null);
                break;
            }
        }
    }

    private void tryAttachDebug() {
        Thread t = new Thread("attach debugger to glassfish"){

            @Override
            public void run() {
                try {
                    GlassFishServerBehaviour.this.getServer().getLaunchConfiguration(true, null);
                    ILaunch launch = GlassFishServerBehaviour.this.getServer().getLaunch();
                    if (launch != null) {
                        String mode = launch.getLaunchMode();
                        mode.equals("debug");
                    }
                }
                catch (CoreException coreException) {
                    GlassfishToolsPlugin.logMessage("Unable to attach debugger, running in normal mode");
                }
            }
        };
        t.start();
    }

    public ServerStatus getServerStatus(boolean forceUpdate) {
        return this.statusMonitor.getServerStatus(forceUpdate);
    }

    public GlassFishServer getGlassfishServerDelegate() {
        GlassFishServer sunserver = (GlassFishServer)((Object)this.getServer().getAdapter(GlassFishServer.class));
        if (sunserver == null) {
            sunserver = (GlassFishServer)((Object)this.getServer().loadAdapter(GlassFishServer.class, (IProgressMonitor)new NullProgressMonitor()));
        }
        return sunserver;
    }

    ResultProcess launchServer(StartupArgsImpl gfStartArguments, ServerTasks.StartMode launchMode, IProgressMonitor monitor) throws TimeoutException, InterruptedException, ExecutionException, HttpPortUpdateException {
        this.setGFServerState(1);
        ResultProcess p = null;
        StartJob j = new StartJob(gfStartArguments, launchMode);
        Future<ResultProcess> res = asyncJobsService.submit(j);
        try {
            p = res.get(this.getServer().getStartTimeout(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            res.cancel(true);
            throw e;
        }
        this.updateHttpPort();
        return p;
    }

    void attach(ILaunch launch, ILaunchConfigurationWorkingCopy config, IProgressMonitor monitor) throws CoreException {
        GlassFishServer serverDelegate = this.getGlassfishServerDelegate();
        int debugPort = serverDelegate.getDebugPort();
        debugPort = debugPort == -1 ? 9009 : debugPort;
        this.attach(launch, config, monitor, debugPort);
    }

    void attach(final ILaunch launch, ILaunchConfigurationWorkingCopy config, IProgressMonitor monitor, int debugPort) throws CoreException {
        this.setDebugArgument(config, "hostname", this.getServer().getHost());
        this.setDebugArgument(config, "port", String.valueOf(debugPort));
        REMOTE_JAVA_APP_LAUNCH_DELEGATE.launch((ILaunchConfiguration)config, "debug", launch, ProgressUtil.getMonitorFor((IProgressMonitor)monitor));
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    JDIDebugTarget debugTarget;
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 8 && event.getSource() instanceof JDIDebugTarget && (debugTarget = (JDIDebugTarget)event.getSource()) != null && debugTarget.getLaunch().getLaunchConfiguration() == launch.getLaunchConfiguration()) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        ((Server)GlassFishServerBehaviour.this.getServer()).setMode("run");
                        ((Server)GlassFishServerBehaviour.this.getServer()).setServerStatus((IStatus)new Status(0, "org.eclipse.glassfish.tools", ""));
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    private void setDebugArgument(ILaunchConfigurationWorkingCopy config, String key, String arg) {
        try {
            HashMap<String, String> args = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            args = args != null ? new HashMap(args) : new HashMap<String, String>();
            args.put(key, String.valueOf(arg));
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, args);
        }
        catch (CoreException ce) {
            GlassfishToolsPlugin.logError("Error when setting debug argument for remote GF", (Exception)((Object)ce));
        }
    }

    protected synchronized void setGFServerState(int state) {
        this.setServerState(state);
    }

    public GlassFishRuntime getRuntimeDelegate() {
        return (GlassFishRuntime)((Object)this.getServer().getRuntime().loadAdapter(GlassFishRuntime.class, null));
    }

    public static String getVersion(GlassFishServer server) throws GlassFishIdeException {
        CommandVersion command = new CommandVersion();
        IdeContext ide = new IdeContext();
        Future future = ServerAdmin.exec(server, (Command)command, ide);
        try {
            ResultString result = (ResultString)future.get(30L, TimeUnit.SECONDS);
            return result.getValue();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Exception by calling getVersion", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Exception by calling getVersion", e);
        }
        catch (TimeoutException e) {
            throw new GlassFishIdeException("Timeout for getting version command exceeded", e);
        }
    }

    public void restart(final String launchMode) throws CoreException {
        if (this.getGlassfishServerDelegate().isRemote() && launchMode.equals("debug")) {
            ((Server)this.getServer()).setServerStatus((IStatus)new Status(0, "org.eclipse.glassfish.tools", "Attaching to remote server..."));
        }
        GlassfishToolsPlugin.logMessage("in GlassfishServerBehaviourDelegate restart");
        this.stopServer(false);
        Thread thread = new Thread("Synchronous server start"){

            @Override
            public void run() {
                try {
                    GlassFishServerBehaviour.this.getServer().getLaunchConfiguration(true, null).launch(launchMode, (IProgressMonitor)new NullProgressMonitor());
                    GlassfishToolsPlugin.logMessage("GlassfishServerBehaviourDelegate restart done");
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logError("in SunAppServerBehaviour restart", e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void stop(boolean force) {
        GlassfishToolsPlugin.logMessage("in GlassfishServerBehaviourDelegate stop");
        this.stopServer(true);
    }

    protected void stopServer(boolean stopLogging) {
        GlassFishServer server = this.getGlassfishServerDelegate();
        if (server.isRemote()) {
            return;
        }
        this.stopImpl(server);
        if (stopLogging) {
            GlassfishConsoleManager.getStandardConsole(server).stopLogging(3);
        }
    }

    private void stopImpl(GlassFishServer server) {
        this.setGFServerState(3);
        StopJob j = new StopJob();
        Future<Object> res = asyncJobsService.submit(j);
        try {
            res.get(this.getServer().getStopTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            GlassfishToolsPlugin.logError("Stop server could not be finished because of exception.", e);
        }
        catch (TimeoutException timeoutException) {
            res.cancel(true);
            GlassfishToolsPlugin.logMessage("Stop server could not be finished in time.");
        }
        this.setLaunch(null);
    }

    protected String getConfigTypeID() {
        return "org.eclipse.glassfish.tools.SunAppServerLaunchConfigurationType";
    }

    public void undeploy(String moduleName, IProgressMonitor monitor) throws CoreException {
        this.undeploy(moduleName);
        List moduleList = this.getAllModules();
        IModule[] module = null;
        for (IModule[] m : moduleList) {
            if (m.length != 1 || !m[0].getName().equals(moduleName)) continue;
            module = m;
            break;
        }
        if (module != null) {
            this.setModulePublishState(module, 3);
        }
    }

    public void undeploy(String moduleName) throws CoreException {
        CommandUndeploy cmd = new CommandUndeploy(moduleName, null);
        try {
            Future future = ServerAdmin.exec(this.getGlassfishServerDelegate(), (Command)cmd, new IdeContext());
            ResultString result = (ResultString)future.get(520L, TimeUnit.SECONDS);
            if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                GlassfishToolsPlugin.logMessage("undeploy is failing=" + result.getValue());
                throw new Exception("undeploy is failing=" + result.getValue());
            }
        }
        catch (Exception ex) {
            GlassfishToolsPlugin.logError("Undeploy is failing=", ex);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.glassfish.tools", 0, "cannot UnDeploy " + moduleName, (Throwable)ex));
        }
    }

    protected boolean publishNeeded(int kind, int deltaKind, IModule[] module) {
        if (this.getServer().getServerPublishState() == 4) {
            return true;
        }
        if (kind != 1 && kind != 3) {
            return true;
        }
        if (deltaKind != 0) {
            return true;
        }
        if (module[0] instanceof DeletedModule) {
            return false;
        }
        if (AssembleModules.isModuleType(module[0], "jst.ear")) {
            IEnterpriseApplication earModule = (IEnterpriseApplication)module[0].loadAdapter(IEnterpriseApplication.class, (IProgressMonitor)new NullProgressMonitor());
            IModule[] childModules = earModule.getModules();
            int i = 0;
            while (i < childModules.length) {
                IModule m = childModules[i];
                IModule[] modules = new IModule[]{module[0], m};
                if (1 != this.getGlassfishServerDelegate().getServer().getModulePublishState(modules)) {
                    return true;
                }
                ++i;
            }
        } else {
            int publishState = this.getGlassfishServerDelegate().getServer().getModulePublishState(module);
            if (1 != publishState) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void publishDeployedDirectory(int deltaKind, Properties p, IModule[] module, IProgressMonitor monitor) throws CoreException {
        PublishHelper helper = new PublishHelper(new Path(String.valueOf(this.getGlassfishServerDelegate().getDomainPath()) + "/eclipseAppsTmp").toFile());
        if (deltaKind == 3) {
            String publishPath = (String)p.get(module[0].getId());
            GlassfishToolsPlugin.logMessage("REMOVED in publishPath" + publishPath);
            String name = Utils.simplifyModuleID(module[0].getName());
            try {
                this.undeploy(name);
            }
            catch (Exception exception) {}
            if (publishPath == null) return;
            try {
                File pub = new File(publishPath);
                if (!pub.exists()) return;
                GlassfishToolsPlugin.logMessage("PublishUtil.deleteDirectory called");
                IStatus[] stat = PublishHelper.deleteDirectory((File)pub, (IProgressMonitor)monitor);
                this.analyseReturnedStatus(stat);
                return;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.glassfish.tools", 0, "cannot remove " + module[0].getName(), (Throwable)e));
            }
        }
        Path path = new Path(String.valueOf(this.getGlassfishServerDelegate().getDomainPath()) + "/eclipseApps/" + module[0].getName());
        String contextRoot = null;
        AssembleModules assembler = new AssembleModules(module, (IPath)path, this.getGlassfishServerDelegate(), helper);
        GlassfishToolsPlugin.logMessage("Deploy direcotry " + path.toFile().getAbsolutePath());
        if (module[0] instanceof DeletedModule) {
            return;
        }
        if (AssembleModules.isModuleType(module[0], "jst.web")) {
            GlassfishToolsPlugin.logMessage("is WEB");
            assembler.assembleWebModule(monitor);
            this.needARedeploy = assembler.needsARedeployment();
            String projectContextRoot = ComponentUtilities.getServerContextRoot((IProject)module[0].getProject());
            contextRoot = projectContextRoot != null && projectContextRoot.length() > 0 ? projectContextRoot : module[0].getName();
        } else if (AssembleModules.isModuleType(module[0], "jst.ear")) {
            GlassfishToolsPlugin.logMessage("is EAR");
            assembler.assembleDirDeployedEARModule(monitor);
            this.needARedeploy = assembler.needsARedeployment();
        } else {
            assembler.assembleNonWebOrNonEARModule(monitor);
            this.needARedeploy = assembler.needsARedeployment();
        }
        this.registerSunResource(module, p, (IPath)path);
        String spath = "" + path;
        if (this.needARedeploy) {
            String name = Utils.simplifyModuleID(module[0].getName());
            HashMap<String, String> properties = new HashMap<String, String>();
            boolean keepSession = this.getGlassfishServerDelegate().getKeepSessions();
            String preserveSessionKey = this.getGlassfishServerDelegate().computePreserveSessions();
            if (preserveSessionKey != null) {
                properties.put(preserveSessionKey, Boolean.toString(this.getGlassfishServerDelegate().getKeepSessions()));
            }
            File[] libraries = new File[]{};
            Object var15_20 = null;
            if (deltaKind == 1) {
                CommandDeploy commandDeploy = new CommandDeploy(name, null, new File(spath), contextRoot, properties, libraries);
            } else {
                CommandRedeploy commandRedeploy = new CommandRedeploy(name, null, contextRoot, properties, libraries, keepSession);
            }
            try {
                void var15_23;
                Future future = ServerAdmin.exec(this.getGlassfishServerDelegate(), (Command)var15_23, new IdeContext());
                ResultString result = (ResultString)future.get(300L, TimeUnit.SECONDS);
                if (TaskState.COMPLETED.equals((Object)result.getState())) return;
                GlassfishToolsPlugin.logMessage("deploy is failing=" + result.getValue());
                throw new Exception("deploy is failing=" + result.getValue());
            }
            catch (Exception ex) {
                GlassfishToolsPlugin.logError("deploy is failing=", ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.glassfish.tools", 0, "cannot Deploy " + name, (Throwable)ex));
            }
        }
        GlassfishToolsPlugin.logMessage("optimal: NO NEED TO TO A REDEPLOYMENT, !!!");
    }

    public void updateHttpPort() throws HttpPortUpdateException {
        GlassFishServer server = (GlassFishServer)((Object)this.getServer().createWorkingCopy().loadAdapter(GlassFishServer.class, null));
        CommandGetProperty cgp = new CommandGetProperty("*.server-config.*.http-listener-1.port");
        Future future = ServerAdmin.exec(this.getGlassfishServerDelegate(), (Command)cgp, new IdeContext());
        ResultMap result = null;
        try {
            result = (ResultMap)future.get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            GlassfishToolsPlugin.logError("Unable to retrieve server http port for server ", e);
            throw new HttpPortUpdateException(e);
        }
        catch (ExecutionException e) {
            GlassfishToolsPlugin.logError("Unable to retrieve server http port for target ", e);
            throw new HttpPortUpdateException(e);
        }
        catch (TimeoutException e) {
            GlassfishToolsPlugin.logError("Unable to retrieve server http port for target ", e);
            throw new HttpPortUpdateException(e);
        }
        if (result != null && TaskState.COMPLETED.equals((Object)result.getState())) {
            for (Map.Entry entry : result.getValue().entrySet()) {
                String val = (String)entry.getValue();
                try {
                    if (val == null || val.trim().length() <= 0) continue;
                    server.setPort(Integer.parseInt(val));
                    server.getServerWorkingCopy().save(true, null);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new HttpPortUpdateException(nfe);
                }
                catch (CoreException ce) {
                    throw new HttpPortUpdateException(ce);
                }
            }
        }
    }

    protected void registerSunResource(IModule[] module, Properties p, IPath path) throws CoreException {
        File sunResource;
        IProject project = module[0].getProject();
        String location = ResourceUtils.getRuntimeResourceLocation(project);
        if (location != null) {
            location = location.trim().length() > 0 ? String.valueOf(location) + File.separatorChar + "sun-resources.xml" : "sun-resources.xml";
        }
        if ((sunResource = new File("" + path, location)).exists()) {
            ResourceUtils.checkUpdateServerResources(sunResource, this.getGlassfishServerDelegate());
            CommandAddResources command = new CommandAddResources(sunResource, null);
            try {
                Future future = ServerAdmin.exec(this.getGlassfishServerDelegate(), (Command)command, new IdeContext());
                ResultString result = (ResultString)future.get(120L, TimeUnit.SECONDS);
                if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                    GlassfishToolsPlugin.logMessage("register resource is failing=" + result.getValue());
                    throw new Exception("register resource is failing=" + result.getValue());
                }
            }
            catch (Exception ex) {
                GlassfishToolsPlugin.logError("deploy of sun-resources is failing ", ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.glassfish.tools", 0, "cannot register sun-resource.xml for " + module[0].getName(), (Throwable)ex));
            }
        }
        p.put(module[0].getId(), path.toOSString());
    }

    protected void analyseReturnedStatus(IStatus[] status) throws CoreException {
        if (status == null || status.length == 0) {
            return;
        }
        IStatus[] iStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            GlassfishToolsPlugin.logMessage("analyseReturnedStatus: " + s.getMessage());
            ++n2;
        }
    }

    public void updateServerStatus() {
        ServerStatus status = this.getServerStatus(true);
        this.updateServerStatus(status);
    }

    private void updateServerStatus(ServerStatus status) {
        Server server2 = (Server)this.getServer();
        if (status != ServerStatus.RUNNING_DOMAIN_MATCHING) {
            String statusMsg = null;
            switch (status) {
                case RUNNING_CREDENTIAL_PROBLEM: {
                    statusMsg = Messages.invalidCredentials;
                    break;
                }
                case STOPPED_DOMAIN_NOT_MATCHING: {
                    if (!this.getGlassfishServerDelegate().isRemote()) {
                        statusMsg = Messages.serverNotMatchingLocal;
                        break;
                    }
                    statusMsg = Messages.serverNotMatchingRemote;
                    break;
                }
                case RUNNING_CONNECTION_ERROR: {
                    if (server2.getServerState() == 4) break;
                    statusMsg = Messages.connectionError;
                    break;
                }
                default: {
                    server2.setServerStatus(null);
                }
            }
            if (statusMsg != null) {
                server2.setServerStatus(GlassfishToolsPlugin.createErrorStatus(statusMsg, null));
            }
        } else {
            server2.setServerStatus(null);
        }
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        IModule[] modules = this.getServer().getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (this.getServer().getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            this.setServerPublishState(1);
        }
    }

    public void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        File serverloc = new File(this.getGlassfishServerDelegate().getServerInstallationDirectory());
        if (!serverloc.exists()) {
            GlassfishToolsPlugin.logError(NLS.bind((String)Messages.serverDirectoryGone, (Object)serverloc.getAbsolutePath()), null);
            return;
        }
        this.needARedeploy = true;
        long t = System.currentTimeMillis();
        if (module.length > 1) {
            this.setModulePublishState(module, 1);
        } else {
            this.publishModuleForGlassFishV3(kind, deltaKind, module, monitor);
            GlassfishToolsPlugin.logMessage("done publishModule in " + (System.currentTimeMillis() - t) + " ms");
        }
    }

    protected void publishModuleForGlassFishV3(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        block30: {
            Properties prop;
            IPath path;
            block28: {
                if (module.length > 1) {
                    this.setModulePublishState(module, 1);
                    return;
                }
                if (!this.publishNeeded(kind, deltaKind, module) || monitor.isCanceled()) {
                    return;
                }
                path = this.getTempDirectory().append("publish.txt");
                FileInputStream fis = null;
                prop = new Properties();
                try {
                    try {
                        fis = new FileInputStream(path.toFile());
                        prop.load(fis);
                    }
                    catch (Exception exception) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception2) {}
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            boolean isRemote = this.getGlassfishServerDelegate().isRemote();
            boolean isJarDeploy = this.getGlassfishServerDelegate().getJarDeploy();
            if (!isRemote && !isJarDeploy) {
                this.publishDeployedDirectory(deltaKind, prop, module, monitor);
            } else {
                this.publishJarFile(kind, deltaKind, prop, module, monitor);
            }
            this.setModulePublishState(module, 1);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(path.toFile());
                    prop.store(fos, "GlassFish 3");
                }
                catch (Exception e) {
                    GlassfishToolsPlugin.logError(" error in PUBLISH_STATE_NONE", e);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void publishJarFile(int kind, int deltaKind, Properties p, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (deltaKind == 3) {
            this.publishDeployedDirectory(deltaKind, p, module, monitor);
        } else {
            try {
                File archivePath = ExportJavaEEArchive.export(module[0], monitor);
                GlassfishToolsPlugin.logMessage("Deploy archive " + archivePath.getAbsolutePath());
                String name = Utils.simplifyModuleID(module[0].getName());
                String contextRoot = null;
                if (AssembleModules.isModuleType(module[0], "jst.web")) {
                    String projectContextRoot = ComponentUtilities.getServerContextRoot((IProject)module[0].getProject());
                    contextRoot = projectContextRoot != null && projectContextRoot.length() > 0 ? projectContextRoot : module[0].getName();
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                boolean keepSession = this.getGlassfishServerDelegate().getKeepSessions();
                String preserveSessionKey = this.getGlassfishServerDelegate().computePreserveSessions();
                if (preserveSessionKey != null) {
                    properties.put(preserveSessionKey, Boolean.toString(keepSession));
                }
                File[] libraries = new File[]{};
                CommandDeploy command = null;
                command = new CommandDeploy(name, null, archivePath, contextRoot, properties, libraries);
                try {
                    Future future = ServerAdmin.exec(this.getGlassfishServerDelegate(), (Command)command, new IdeContext());
                    ResultString result = (ResultString)future.get(520L, TimeUnit.SECONDS);
                    if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                        GlassfishToolsPlugin.logMessage("deploy is failing=" + result.getValue());
                        throw new Exception("deploy is failing=" + result.getValue());
                    }
                }
                catch (Exception ex) {
                    GlassfishToolsPlugin.logError("deploy is failing=", ex);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.glassfish.tools", 0, "cannot Deploy " + name, (Throwable)ex));
                }
            }
            catch (org.eclipse.core.commands.ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private class StartJob
    implements Callable<ResultProcess> {
        private StartupArgsImpl args;
        private ServerTasks.StartMode mode;

        StartJob(StartupArgsImpl args, ServerTasks.StartMode mode) {
            this.args = args;
            this.mode = mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResultProcess call() throws Exception {
            ResultProcess process = null;
            try {
                process = ServerTasks.startServer(GlassFishServerBehaviour.this.getGlassfishServerDelegate(), this.args, this.mode);
            }
            catch (GlassFishIdeException e) {
                throw new GlassfishLaunchException("Exception in startup library.", e);
            }
            Process gfProcess = process.getValue().getProcess();
            IGlassFishConsole startupConsole = GlassfishConsoleManager.getStartupProcessConsole(GlassFishServerBehaviour.this.getGlassfishServerDelegate(), gfProcess);
            startupConsole.startLogging(new FetchLogSimple(gfProcess.getInputStream()), new FetchLogSimple(gfProcess.getErrorStream()));
            GlassFishServerBehaviour glassFishServerBehaviour = GlassFishServerBehaviour.this;
            synchronized (glassFishServerBehaviour) {
                block15: while (true) {
                    ServerStatus status = GlassFishServerBehaviour.this.getServerStatus(false);
                    switch (status) {
                        case STOPPED_NOT_LISTENING: {
                            try {
                                int exit_code = gfProcess.exitValue();
                                System.out.println("Process exit code: " + exit_code);
                                if (exit_code != 0) {
                                    GlassfishToolsPlugin.logMessage("launch failed with exit code " + exit_code);
                                    GlassfishConsoleManager.showConsole(startupConsole);
                                    throw new GlassfishLaunchException("Launch process failed with exit code " + exit_code);
                                }
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {}
                            break;
                        }
                        case RUNNING_PROXY_ERROR: {
                            startupConsole.stopLogging();
                            gfProcess.destroy();
                            throw new GlassfishLaunchException("BAD GATEWAY response code returned. Check your proxy settings. Killing startup process.", gfProcess);
                        }
                        case RUNNING_CREDENTIAL_PROBLEM: {
                            startupConsole.stopLogging();
                            gfProcess.destroy();
                            throw new GlassfishLaunchException("Wrong user name or password. Killing startup process.", gfProcess);
                        }
                        case RUNNING_DOMAIN_MATCHING: {
                            startupConsole.stopLogging();
                            break block15;
                        }
                    }
                    try {
                        GlassFishServerBehaviour.this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("StartJob interrupted, killing startup process");
                        startupConsole.stopLogging();
                        gfProcess.destroy();
                        throw e;
                    }
                }
                return process;
            }
        }
    }

    private class StopJob
    implements Callable<Object> {
        private StopJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            ResultString result = null;
            try {
                result = CommandStopDAS.stopDAS(GlassFishServerBehaviour.this.getGlassfishServerDelegate());
            }
            catch (GlassFishIdeException e) {
                GlassfishToolsPlugin.logMessage("Stop command failed in library code." + e.getMessage());
                throw e;
            }
            if (!TaskState.COMPLETED.equals((Object)result.getState())) {
                GlassfishToolsPlugin.logMessage("Stop call failed. Reason: " + result.getValue());
                throw new Exception("Stop call failed. Reason: " + result.getValue());
            }
            GlassFishServerBehaviour e = GlassFishServerBehaviour.this;
            synchronized (e) {
                while (!GlassFishServerBehaviour.this.getServerStatus(false).equals((Object)ServerStatus.STOPPED_NOT_LISTENING)) {
                    GlassFishServerBehaviour.this.wait();
                }
            }
            Server server2 = (Server)GlassFishServerBehaviour.this.getServer();
            server2.setServerStatus(null);
            return null;
        }
    }
}

