/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.glassfish.tools.GlassFishInstall;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.IGlassfishRuntimeModel;
import org.eclipse.glassfish.tools.IGlassfishServerModel;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.utils.JavaLocationDefaultValueService;
import org.eclipse.glassfish.tools.utils.JavaLocationValidationService;
import org.eclipse.glassfish.tools.utils.JdtUtil;
import org.eclipse.glassfish.tools.utils.WtpUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.DefaultValueService;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public final class GlassfishServerConfigServices {

    public static final class DomainLocationDefaultValueService
    extends DefaultValueService {
        private static final String DEFAULT_DOMAINS_DIR = "domains";
        private static final String DEFAULT_DOMAIN_NAME = "domain1";

        protected String compute() {
            IServerWorkingCopy wc = (IServerWorkingCopy)((Value)this.context(Value.class)).element().adapt(IServerWorkingCopy.class);
            IRuntime runtime = wc.getRuntime();
            IPath serverLocation = runtime.getLocation();
            return serverLocation.append(DEFAULT_DOMAINS_DIR).append(DEFAULT_DOMAIN_NAME).toString();
        }
    }

    public static final class DomainLocationListener
    extends Listener {
        public void handle(Event event) {
            Property property = ((PropertyEvent)event).property();
            IServerWorkingCopy wc = (IServerWorkingCopy)property.element().adapt(IServerWorkingCopy.class);
            IGlassfishServerModel model = (IGlassfishServerModel)property.nearest(IGlassfishServerModel.class);
            String name = String.valueOf(wc.getRuntime().getName()) + " [";
            name = (Boolean)model.getRemote().content() != false ? String.valueOf(name) + (String)model.getHostName().content() : String.valueOf(name) + ((Path)model.getDomainPath().content()).lastSegment();
            name = String.valueOf(name) + "]";
            model.setName(WtpUtil.findUniqueServerName(name));
        }
    }

    public static final class DomainLocationValidationService
    extends ValidationService {
        protected Status compute() {
            IServerWorkingCopy wc = (IServerWorkingCopy)((Value)this.context(Value.class)).element().adapt(IServerWorkingCopy.class);
            GlassFishServer serverDelegate = (GlassFishServer)((Object)wc.loadAdapter(GlassFishServer.class, null));
            return StatusBridge.create((IStatus)serverDelegate.validate());
        }
    }

    public static final class JdkDefaultValueService
    extends JavaLocationDefaultValueService {
        @Override
        protected void initDefaultValueService() {
            super.initDefaultValueService();
            ((IGlassfishRuntimeModel)this.context(IGlassfishRuntimeModel.class)).getServerRoot().attach((Listener)new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    this.refresh();
                }
            });
        }

        @Override
        protected boolean acceptable(IVMInstall jvm) {
            if (((IGlassfishRuntimeModel)this.context(IGlassfishRuntimeModel.class)).getServerRoot().validation().ok()) {
                IRuntime r = (IRuntime)((Value)this.context(Value.class)).element().adapt(IRuntime.class);
                GlassFishRuntime gf = (GlassFishRuntime)((Object)r.loadAdapter(GlassFishRuntime.class, null));
                return JdtUtil.validateJvm(jvm).jdk().version(gf.getJavaVersionConstraint()).result().ok();
            }
            return false;
        }
    }

    public static final class JdkValidationService
    extends JavaLocationValidationService {
        protected void initValidationService() {
            super.initValidationService();
            ((IGlassfishRuntimeModel)this.context(IGlassfishRuntimeModel.class)).getServerRoot().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    this.refresh();
                }
            });
        }

        @Override
        protected Status validate(File location) {
            IRuntime r = (IRuntime)((Value)this.context(Value.class)).element().adapt(IRuntime.class);
            GlassFishRuntime gf = (GlassFishRuntime)((Object)r.loadAdapter(GlassFishRuntime.class, null));
            return JdtUtil.validateJvm(location).jdk().version(gf.getJavaVersionConstraint()).result();
        }
    }

    public static final class ServerLocationListener
    extends Listener {
        private static final List<Path> subFoldersToSearch = ListFactory.start().add((Object)new Path("glassfish")).add((Object)new Path("glassfish4/glassfish")).add((Object)new Path("glassfish3/glassfish")).result();

        public void handle(Event event) {
            IGlassfishRuntimeModel model = (IGlassfishRuntimeModel)((PropertyEvent)event).property().nearest(IGlassfishRuntimeModel.class);
            Version gfVersion = null;
            Path location = (Path)model.getServerRoot().content();
            if (location != null) {
                GlassFishInstall gfInstall = GlassFishInstall.find(location.toFile());
                if (gfInstall == null) {
                    for (Path sf : subFoldersToSearch) {
                        Path p = location.append(sf);
                        gfInstall = GlassFishInstall.find(p.toFile());
                        if (gfInstall == null) continue;
                        model.setServerRoot(p);
                        break;
                    }
                }
                if (gfInstall != null) {
                    gfVersion = gfInstall.version();
                }
            }
            model.setName(GlassFishRuntime.createDefaultRuntimeName(gfVersion));
        }
    }

    public static final class ServerLocationValidationService
    extends ValidationService {
        protected Status compute() {
            IRuntime r = (IRuntime)((Value)this.context(Value.class)).element().adapt(IRuntime.class);
            GlassFishRuntime runtimeDelegate = (GlassFishRuntime)((Object)r.loadAdapter(GlassFishRuntime.class, null));
            IStatus s = runtimeDelegate.validateServerLocation();
            if (!s.isOK()) {
                return StatusBridge.create((IStatus)s);
            }
            return StatusBridge.create((IStatus)runtimeDelegate.validateVersion());
        }
    }

    public static final class UniqueRuntimeNameValidationService
    extends ValidationService {
        protected Status compute() {
            Value name = (Value)this.context(Value.class);
            if (!name.empty()) {
                IRuntime thisRuntime = (IRuntime)name.element().adapt(IRuntime.class);
                if (thisRuntime instanceof IRuntimeWorkingCopy) {
                    thisRuntime = ((IRuntimeWorkingCopy)thisRuntime).getOriginal();
                }
                IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
                int n = iRuntimeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntime r = iRuntimeArray[n2];
                    if (r != thisRuntime && name.text().equals(r.getName())) {
                        return Status.createErrorStatus((String)NLS.bind((String)Messages.duplicateRuntimeName, (Object)name.text()));
                    }
                    ++n2;
                }
            }
            return Status.createOkStatus();
        }
    }

    public static final class UniqueServerNameValidationService
    extends ValidationService {
        @Text(value="Server name {0} is already in use")
        private static LocalizableText duplicateServerName;

        static {
            LocalizableText.init(UniqueServerNameValidationService.class);
        }

        protected Status compute() {
            Value name = (Value)this.context(Value.class);
            if (!name.empty()) {
                IServerWorkingCopy thisServerWorkingCopy = (IServerWorkingCopy)name.element().adapt(IServerWorkingCopy.class);
                IServer thisServer = thisServerWorkingCopy.getOriginal();
                IServer[] iServerArray = ServerCore.getServers();
                int n = iServerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IServer s = iServerArray[n2];
                    if (s != thisServer && name.text().equals(s.getName())) {
                        return Status.createErrorStatus((String)duplicateServerName.format(new Object[]{name.text()}));
                    }
                    ++n2;
                }
            }
            return Status.createOkStatus();
        }
    }
}

