/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.ServerStatus;
import org.eclipse.glassfish.tools.StartupArgsImpl;
import org.eclipse.glassfish.tools.exceptions.HttpPortUpdateException;
import org.eclipse.glassfish.tools.log.GlassfishConsoleManager;
import org.eclipse.glassfish.tools.log.IGlassFishConsole;
import org.eclipse.glassfish.tools.sdk.admin.ResultProcess;
import org.eclipse.glassfish.tools.sdk.server.FetchLogPiped;
import org.eclipse.glassfish.tools.sdk.server.ServerTasks;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;
import org.eclipse.glassfish.tools.sdk.utils.Utils;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class GlassfishServerLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String GFV3_MODULES_DIR_NAME = "modules";
    private static final int MONITOR_TOTAL_WORK = 1000;
    private static final int WORK_STEP = 200;
    private static Pattern debugPortPattern = Pattern.compile("-\\S+jdwp[:=]\\S*address=([0-9]+)");

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.glassfish.tools", code, message, exception));
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        GlassFishServerBehaviour serverBehavior;
        block17: {
            GlassfishToolsPlugin.logMessage("in SUN SunAppServerLaunch launch");
            monitor.beginTask("Starting GlassFish", 1000);
            IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
            if (server == null) {
                this.abort("missing Server", null, 150);
            }
            serverBehavior = (GlassFishServerBehaviour)server.loadAdapter(GlassFishServerBehaviour.class, null);
            GlassFishServer serverAdapter = (GlassFishServer)((Object)server.loadAdapter(GlassFishServer.class, (IProgressMonitor)new NullProgressMonitor()));
            serverBehavior.setLaunch(launch);
            try {
                this.checkMonitorAndProgress(monitor, 200);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            boolean isRunning = this.isRunning(serverBehavior);
            if (isRunning) {
                GlassfishToolsPlugin.logMessage("server is already started!!!");
                if ("debug".equals(mode)) {
                    try {
                        serverBehavior.attach(launch, configuration.getWorkingCopy(), monitor);
                    }
                    catch (CoreException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error attaching to GlassFish Server. Please make sure the server is started in debug mode.");
                            }
                        });
                        GlassfishToolsPlugin.logError("Not able to attach debugger, running in normal mode", (Exception)((Object)e));
                        ((Server)serverBehavior.getServer()).setMode("run");
                        throw e;
                    }
                    ((Server)serverBehavior.getServer()).setServerStatus((IStatus)new Status(0, "org.eclipse.glassfish.tools", "Debugging"));
                }
            }
            try {
                if (serverAdapter.isRemote()) {
                    if (!isRunning) {
                        this.abort("GlassFish Remote Servers cannot be start from this machine.", null, 150);
                    }
                } else if (!isRunning) {
                    this.startDASAndTarget(serverAdapter, serverBehavior, configuration, launch, mode, monitor);
                }
            }
            catch (InterruptedException e) {
                IGlassFishConsole console = GlassfishConsoleManager.getStandardConsole(serverAdapter);
                console.stopLogging(3);
                GlassfishToolsPlugin.logError("Server start interrupted.", e);
                serverBehavior.setGFServerState(4);
                this.abort("Unable to start server due interruption.", e, 150);
                monitor.done();
                break block17;
            }
            catch (CoreException e) {
                try {
                    IGlassFishConsole console = GlassfishConsoleManager.getStandardConsole(serverAdapter);
                    console.stopLogging(3);
                    serverBehavior.setGFServerState(4);
                    throw e;
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
        }
        ((Server)serverBehavior.getServer()).setMode(mode);
    }

    private void startDASAndTarget(GlassFishServer serverAdapter, GlassFishServerBehaviour serverBehavior, ILaunchConfiguration configuration, ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException, InterruptedException {
        AbstractVMInstall vm;
        String domain = serverAdapter.getDomainName();
        String domainAbsolutePath = serverAdapter.getDomainPath();
        File bootstrapJar = ServerUtils.getJarName(serverAdapter.getServerInstallationDirectory(), "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (bootstrapJar == null) {
            this.abort("bootstrap jar not found", null, 150);
        }
        if ((vm = (AbstractVMInstall)serverBehavior.getRuntimeDelegate().getVMInstall()) == null || vm.getInstallLocation() == null) {
            this.abort("Invalid Java VM location for server " + serverAdapter.getName(), null, 150);
        }
        StartupArgsImpl startArgs = new StartupArgsImpl();
        startArgs.setJavaHome(vm.getInstallLocation().getAbsolutePath());
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        if (vmArgs.indexOf("-Doracle.mds.cache=simple") < 0) {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, String.valueOf(vmArgs) + " -Doracle.mds.cache=simple ");
            configuration = wc.doSave();
        }
        ServerTasks.StartMode startMode = "debug".equals(mode) ? ServerTasks.StartMode.DEBUG : ServerTasks.StartMode.START;
        this.addJavaOptions(serverAdapter, mode, startArgs, vmArgs);
        startArgs.addGlassfishArgs(pgmArgs);
        startArgs.addGlassfishArgs("--domain " + domain);
        startArgs.addGlassfishArgs("--domaindir " + Utils.quote(domainAbsolutePath));
        GlassfishToolsPlugin.getInstance().getPreferenceStore();
        this.setDefaultSourceLocator(launch, configuration);
        this.checkMonitorAndProgress(monitor, 200);
        Process processGF = null;
        this.checkMonitorAndProgress(monitor, 200);
        this.startLogging(serverAdapter, serverBehavior);
        ResultProcess process = null;
        try {
            process = serverBehavior.launchServer(startArgs, startMode, monitor);
            processGF = process.getValue().getProcess();
            launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
            new RuntimeProcess(launch, processGF, "GlassFish Application Server", null);
        }
        catch (TimeoutException e) {
            this.abort("Unable to start server on time.", e, 150);
        }
        catch (ExecutionException e) {
            this.abort("Unable to start server due following issues:", e.getCause(), 150);
        }
        catch (HttpPortUpdateException e) {
            this.abort("Unable to update http port. Server shut down.", e, 150);
        }
        try {
            this.checkMonitorAndProgress(monitor, 200);
        }
        catch (InterruptedException e) {
            this.killProcesses(processGF);
            throw e;
        }
        this.setDefaultSourceLocator(launch, configuration);
        if ("debug".equals(mode)) {
            Integer debugPort = null;
            try {
                debugPort = GlassfishServerLaunchDelegate.getDebugPort(process.getValue().getArguments());
            }
            catch (NumberFormatException e) {
                this.killProcesses(processGF);
                this.abort("Server run in debug mode but the debug port couldn't be determined!", e, 150);
            }
            catch (IllegalArgumentException e) {
                this.killProcesses(processGF);
                this.abort("Server run in debug mode but the debug port couldn't be determined!", e, 150);
            }
            serverBehavior.attach(launch, configuration.getWorkingCopy(), monitor, debugPort);
        }
    }

    private void addJavaOptions(GlassFishServer serverAdapter, String mode, StartupArgsImpl args, String vmArgs) {
        if ("debug".equals(mode)) {
            args.addJavaArgs(vmArgs);
            int debugPort = serverAdapter.getDebugPort();
            if (debugPort != -1) {
                args.addJavaArgs(serverAdapter.getDebugOptions(debugPort));
            }
        } else {
            args.addJavaArgs(this.ignoreDebugArgs(vmArgs));
        }
    }

    private String ignoreDebugArgs(String vmArgs) {
        StringBuilder args = new StringBuilder(vmArgs.length());
        String[] stringArray = vmArgs.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if ("-Xdebug".equalsIgnoreCase(a) || a.startsWith("-agentlib") || a.startsWith("-Xrunjdwp")) break;
            args.append(a);
            args.append(" ");
            ++n2;
        }
        return args.toString();
    }

    private void killProcesses(Process ... process) {
        Process[] processArray = process;
        int n = process.length;
        int n2 = 0;
        while (n2 < n) {
            Process p = processArray[n2];
            if (p != null) {
                p.destroy();
            }
            ++n2;
        }
    }

    private boolean isRunning(GlassFishServerBehaviour serverBehavior) throws CoreException {
        IServer thisServer = serverBehavior.getServer();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GlassFishServer runingGfServer;
            ServerDelegate delegate;
            IServer server = iServerArray[n2];
            if (server != thisServer && server.getServerState() == 2 && (delegate = (ServerDelegate)server.loadAdapter(ServerDelegate.class, null)) instanceof GlassFishServer && !(runingGfServer = (GlassFishServer)delegate).isRemote()) {
                GlassFishServer thisGfServer = (GlassFishServer)((Object)thisServer.loadAdapter(ServerDelegate.class, null));
                if (runingGfServer.getPort() == thisGfServer.getPort() || runingGfServer.getAdminPort() == thisGfServer.getAdminPort()) {
                    this.abort(Messages.canntCommunicate, new RuntimeException(Messages.domainNotMatch), 150);
                    return false;
                }
            }
            ++n2;
        }
        ServerStatus status = serverBehavior.getServerStatus(true);
        switch (status) {
            case RUNNING_CONNECTION_ERROR: {
                this.abort(Messages.canntCommunicate, new RuntimeException(String.valueOf(Messages.abortLaunchMsg) + Messages.domainNotMatch + Messages.checkVpnOrProxy), 150);
                break;
            }
            case RUNNING_CREDENTIAL_PROBLEM: {
                this.abort(Messages.canntCommunicate, new RuntimeException(String.valueOf(Messages.abortLaunchMsg) + Messages.wrongUsernamePassword), 150);
                break;
            }
            case RUNNING_DOMAIN_MATCHING: {
                return true;
            }
            case RUNNING_PROXY_ERROR: {
                this.abort(Messages.canntCommunicate, new RuntimeException(String.valueOf(Messages.abortLaunchMsg) + Messages.badGateway), 150);
                break;
            }
            case STOPPED_DOMAIN_NOT_MATCHING: {
                this.abort(Messages.canntCommunicate, new RuntimeException(Messages.domainNotMatch), 150);
                break;
            }
            case STOPPED_NOT_LISTENING: {
                return false;
            }
        }
        return false;
    }

    private void startLogging(final GlassFishServer serverAdapter, GlassFishServerBehaviour serverBehavior) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    File logFile = new File(String.valueOf(serverAdapter.getDomainPath()) + "/logs/server.log");
                    try {
                        logFile.createNewFile();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    IGlassFishConsole console = GlassfishConsoleManager.getStandardConsole(serverAdapter);
                    GlassfishConsoleManager.showConsole(console);
                    if (!console.isLogging()) {
                        console.startLogging(FetchLogPiped.create(serverAdapter, true));
                    }
                }
            });
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logError("page.showView", e);
        }
    }

    private void checkMonitorAndProgress(IProgressMonitor monitor, int work) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.worked(work);
    }

    private static Integer getDebugPort(String startArgs) {
        Matcher m = debugPortPattern.matcher(startArgs);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        throw new IllegalArgumentException("Debug port not found in process args!");
    }

    static class GlassfishServerDebugListener
    implements IDebugEventSetListener {
        private GlassFishServerBehaviour serverBehavior;
        private String debugTargetIdentifier;

        public GlassfishServerDebugListener(GlassFishServerBehaviour serverBehavior, String debugTargetIdentifier) {
            this.serverBehavior = serverBehavior;
            this.debugTargetIdentifier = debugTargetIdentifier;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (events != null) {
                int size = events.length;
                int i = 0;
                while (i < size) {
                    if (events[i].getSource() instanceof JDIDebugTarget) {
                        JDIDebugTarget dt = (JDIDebugTarget)events[i].getSource();
                        try {
                            GlassfishToolsPlugin.logMessage("JDIDebugTarget=" + dt.getName());
                            if (dt.getName().indexOf(this.debugTargetIdentifier) != -1 && events[i].getKind() == 8) {
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                if (!dt.isTerminated()) {
                                    this.serverBehavior.stop(true);
                                }
                                Server server = (Server)this.serverBehavior.getServer();
                                server.setServerStatus(null);
                            }
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

