/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GlassfishToolsPlugin
extends AbstractUIPlugin {
    public static final String RUNTIME_TYPE = "glassfish";
    public static final String GF_SERVER_IMG = "gf-server.img";
    public static final String SYMBOLIC_NAME = "org.eclipse.glassfish.tools";
    public static final Bundle BUNDLE = Platform.getBundle((String)"org.eclipse.glassfish.tools");
    private static final ILog LOG = Platform.getLog((Bundle)BUNDLE);
    private static GlassfishToolsPlugin singleton;
    private static HashSet<String[]> commandsToExecuteAtExit;

    static {
        commandsToExecuteAtExit = new HashSet();
    }

    public GlassfishToolsPlugin() {
        singleton = this;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(GF_SERVER_IMG, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/obj16/glassfishserver.gif")));
    }

    public void stop(BundleContext v) throws Exception {
        GlassfishToolsPlugin.logMessage("STOP IS CALLED!!!!!!!!!!!!!!!!");
        for (String[] command : commandsToExecuteAtExit) {
            try {
                GlassfishToolsPlugin.logMessage(">>> " + command[0]);
                BufferedReader input = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream(), Charset.defaultCharset()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    GlassfishToolsPlugin.logMessage(">>> " + line);
                }
                input.close();
            }
            catch (Exception ex) {
                GlassfishToolsPlugin.logMessage("Error executing process:\n" + ex);
            }
        }
        super.stop(v);
    }

    public static GlassfishToolsPlugin getInstance() {
        return singleton;
    }

    public void addCommandToExecuteAtExit(String[] command) {
        for (Object[] objectArray : commandsToExecuteAtExit) {
            if (!Arrays.equals(objectArray, command)) continue;
            GlassfishToolsPlugin.logMessage("Command already there");
            return;
        }
        commandsToExecuteAtExit.add(command);
        GlassfishToolsPlugin.logMessage("addCommandToExecuteAtExit size=" + commandsToExecuteAtExit.size());
    }

    public static void logError(String message) {
        GlassfishToolsPlugin.logError(message, null);
    }

    public static void logError(String message, Exception e) {
        GlassfishToolsPlugin.log(GlassfishToolsPlugin.createErrorStatus(message, e));
    }

    public static void log(Exception e) {
        GlassfishToolsPlugin.log(GlassfishToolsPlugin.createErrorStatus(e));
    }

    public static void log(IStatus status) {
        LOG.log(status);
    }

    public static IStatus createErrorStatus(String message) {
        return GlassfishToolsPlugin.createErrorStatus(message, null);
    }

    public static IStatus createErrorStatus(Exception e) {
        return GlassfishToolsPlugin.createErrorStatus(null, e);
    }

    public static IStatus createErrorStatus(String message, Exception e) {
        String msg = message == null ? String.valueOf(e.getMessage()) : message;
        return new Status(4, SYMBOLIC_NAME, 0, msg, (Throwable)e);
    }

    public static void logMessage(String mess) {
        IPreferenceStore store = GlassfishToolsPlugin.getInstance().getPreferenceStore();
        boolean trace = store.getBoolean("EnableLogPreference");
        if (trace) {
            Status status = new Status(1, SYMBOLIC_NAME, 1, "GlassFish: " + mess, null);
            GlassfishToolsPlugin.log((IStatus)status);
        }
    }

    public static boolean is31OrAbove(IRuntime runtime) {
        return runtime.getRuntimeType().getId().equals(RUNTIME_TYPE);
    }
}

