/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import org.eclipse.glassfish.tools.internal.CreateGlassfishDomainOpMethods;
import org.eclipse.glassfish.tools.internal.DomainNameValidationService;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;

public interface ICreateGlassfishDomainOp
extends ExecutableElement {
    public static final ElementType TYPE = new ElementType(ICreateGlassfishDomainOp.class);
    @Label(standard="&Name")
    @Service(impl=DomainNameValidationService.class)
    @Required
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Label(standard="Java location used to run GlassFish asadmin")
    public static final ValueProperty PROP_JAVA_LOCATION = new ValueProperty(TYPE, "JavaLocation");
    @Type(base=Path.class)
    @AbsolutePath
    @MustExist
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @Required
    public static final ValueProperty PROP_LOCATION = new ValueProperty(TYPE, "Location");
    @Label(standard="&Domain directory")
    @Type(base=Path.class)
    @AbsolutePath
    @MustExist
    @DefaultValue(text="${Location}/domains")
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @Required
    public static final ValueProperty PROP_DOMAIN_DIR = new ValueProperty(TYPE, "DomainDir");
    @Label(standard="&Portbase")
    @Type(base=Integer.class)
    @Documentation(content="Determines the number with which port assignmentsshould start. A domain uses a certain number of ports that are statically assigned. The portbase value determines where the assignment should start. The values forthe ports are calculated as follows:\nAdministration port: portbase + 48;\nHTTP listener port: portbase + 80;\nHTTPS listener port: portbase + 81;\nJMS port: portbase + 76;\nIIOP listener port: portbase + 37;\nSecure IIOP listener port: portbase + 38;\nSecure IIOP with mutual authentication port: portbase + 39;\nJMX port: portbase + 86;\nJPDA debugger port: portbase + 9;\nFelix shell service port for OSGi module  management: portbase + 66")
    @Required
    @NumericRange(min="1025", max="65535")
    @DefaultValue(text="8000")
    public static final ValueProperty PROP_PORT_BASE = new ValueProperty(TYPE, "PortBase");

    public Value<String> getName();

    public void setName(String var1);

    public Value<Path> getJavaLocation();

    public void setJavaLocation(String var1);

    public Value<Path> getLocation();

    public void setLocation(String var1);

    public void setLocation(Path var1);

    public Value<Path> getDomainDir();

    public void setDomainDir(String var1);

    public void setDomainDir(Path var1);

    public Value<Integer> getPortBase();

    public void setPortBase(String var1);

    public void setPortBase(int var1);

    @DelegateImplementation(value=CreateGlassfishDomainOpMethods.class)
    public Status execute(ProgressMonitor var1);
}

