/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools;

import org.eclipse.glassfish.tools.GlassfishServerConfigServices;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IGlassfishServerModel
extends Element {
    public static final ElementType TYPE = new ElementType(IGlassfishServerModel.class);
    @Label(standard="na&me")
    @Required
    @Service(impl=GlassfishServerConfigServices.UniqueServerNameValidationService.class)
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Label(standard="&host name")
    @Required
    public static final ValueProperty PROP_HOST_NAME = new ValueProperty(TYPE, "HostName");
    @Type(base=Boolean.class)
    @Derived(text="${ HostName != 'localhost' }")
    public static final ValueProperty PROP_REMOTE = new ValueProperty(TYPE, "Remote");
    @XmlBinding(path="domain-path")
    @Label(standard="domain &path")
    @Required
    @Type(base=Path.class)
    @MustExist
    @AbsolutePath
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @Service(impl=GlassfishServerConfigServices.DomainLocationValidationService.class)
    @Listeners(value={GlassfishServerConfigServices.DomainLocationListener.class})
    @Enablement(expr="${ ! Remote }")
    public static final ValueProperty PROP_DOMAIN_PATH = new ValueProperty(TYPE, "DomainPath");
    @XmlBinding(path="admin-name")
    @Label(standard="admin nam&e")
    @Required
    @DefaultValue(text="admin")
    public static final ValueProperty PROP_ADMIN_NAME = new ValueProperty(TYPE, "AdminName");
    @XmlBinding(path="admin-password")
    @Label(standard="admin pass&word")
    @SensitiveData
    public static final ValueProperty PROP_ADMIN_PASSWORD = new ValueProperty(TYPE, "AdminPassword");
    @Type(base=Integer.class)
    @XmlBinding(path="admin-port")
    @Label(standard="admin p&ort")
    @Required
    @NumericRange(min="1025", max="65535")
    @Enablement(expr="${ Remote }")
    public static final ValueProperty PROP_ADMIN_PORT = new ValueProperty(TYPE, "AdminPort");
    @Type(base=Integer.class)
    @XmlBinding(path="debug-port")
    @Label(standard="deb&ug port")
    @NumericRange(min="1034", max="65535")
    @DefaultValue(text="8009")
    @Documentation(content="For local server you can specify the port on which the server will be debugged. If empty, the current value from domain.xml will be used.\n For remote servers you may want to specify the debug port to be able to debug your applications running on the server.")
    public static final ValueProperty PROP_DEBUG_PORT = new ValueProperty(TYPE, "DebugPort");
    @Type(base=Integer.class)
    @XmlBinding(path="server-port")
    @Label(standard="server port")
    @Enablement(expr="false")
    public static final ValueProperty PROP_SERVER_PORT = new ValueProperty(TYPE, "ServerPort");
    @Type(base=Boolean.class)
    @XmlBinding(path="preserve-sessions")
    @DefaultValue(text="true")
    @Label(standard="preser&ve sessions across redeployment")
    public static final ValueProperty PROP_PRESERVE_SESSIONS = new ValueProperty(TYPE, "PreserveSessions");
    @Type(base=Boolean.class)
    @XmlBinding(path="use-anonymous-connections")
    @DefaultValue(text="true")
    @Label(standard="use anon&ymous connections for admin commands")
    public static final ValueProperty PROP_USE_ANONYMOUS_CONNECTIONS = new ValueProperty(TYPE, "UseAnonymousConnections");
    @Type(base=Boolean.class)
    @XmlBinding(path="use-jar-deployment")
    @DefaultValue(text="false")
    @Label(standard="use &JAR archives for deployment")
    @Enablement(expr="${ ! Remote }")
    public static final ValueProperty PROP_USE_JAR_DEPLOYMENT = new ValueProperty(TYPE, "UseJarDeployment");

    public Value<String> getName();

    public void setName(String var1);

    public Value<String> getHostName();

    public void setHostName(String var1);

    public Value<Boolean> getRemote();

    public Value<Path> getDomainPath();

    public void setDomainPath(Path var1);

    public Value<String> getAdminName();

    public void setAdminName(String var1);

    public Value<String> getAdminPassword();

    public void setAdminPassword(String var1);

    public Value<Integer> getAdminPort();

    public void setAdminPort(Integer var1);

    public Value<Integer> getDebugPort();

    public void setDebugPort(Integer var1);

    public Value<Integer> getServerPort();

    public void setServerPort(Integer var1);

    public Value<Boolean> getPreserveSessions();

    public void setPreserveSessions(Boolean var1);

    public Value<Boolean> getUseAnonymousConnections();

    public void setUseAnonymousConnections(Boolean var1);

    public Value<Boolean> getUseJarDeployment();

    public void setUseJarDeployment(Boolean var1);
}

