/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.facets.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.glassfish.tools.facets.internal.GlassfishRootElementInfo;
import org.eclipse.glassfish.tools.facets.models.IGlassfishDeploymentDescriptorModel;
import org.eclipse.glassfish.tools.facets.models.IGlassfishEjbDescriptorModel;
import org.eclipse.sapphire.ElementType;

enum GlassfishDescriptorType {
    GF_WEB,
    GF_EJB;

    private static final Map<ElementType, GlassfishDescriptorType> ROOT_MODEL_ELEMENT_TYPE_TO_DESCRIPTOR_TYPE;
    private static final GlassfishRootElementInfo WEB_ROOT_INFO_V31;
    private static final GlassfishRootElementInfo EJB_ROOT_INFO_V31;

    static {
        ROOT_MODEL_ELEMENT_TYPE_TO_DESCRIPTOR_TYPE = new HashMap<ElementType, GlassfishDescriptorType>();
        ROOT_MODEL_ELEMENT_TYPE_TO_DESCRIPTOR_TYPE.put(IGlassfishDeploymentDescriptorModel.TYPE, GF_WEB);
        ROOT_MODEL_ELEMENT_TYPE_TO_DESCRIPTOR_TYPE.put(IGlassfishEjbDescriptorModel.TYPE, GF_EJB);
        WEB_ROOT_INFO_V31 = new GlassfishRootElementInfo("-//GlassFish.org//DTD GlassFish Application Server 3.1 Servlet 3.0//EN", "http://glassfish.org/dtds/glassfish-web-app_3_0-1.dtd", "glassfish-web-app");
        EJB_ROOT_INFO_V31 = new GlassfishRootElementInfo("-//GlassFish.org//DTD GlassFish Application Server 3.1 EJB 3.1//EN", "http://glassfish.org/dtds/glassfish-ejb-jar_3_1-1.dtd", "glassfish-ejb-jar");
    }

    public static GlassfishDescriptorType getDescriptorType(ElementType modelType) {
        return ROOT_MODEL_ELEMENT_TYPE_TO_DESCRIPTOR_TYPE.get(modelType);
    }

    public static GlassfishRootElementInfo getGlassfishRootElementInfo(GlassfishDescriptorType type) {
        switch (type) {
            case GF_WEB: {
                return WEB_ROOT_INFO_V31;
            }
            case GF_EJB: {
                return EJB_ROOT_INFO_V31;
            }
        }
        return null;
    }
}

