/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.handlers;

import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.ServerStatus;
import org.eclipse.glassfish.tools.handlers.AbstractGlassfishSelectionHandler;
import org.eclipse.glassfish.tools.log.GlassfishConsoleManager;
import org.eclipse.glassfish.tools.log.IGlassFishConsole;
import org.eclipse.glassfish.tools.sdk.server.FetchLogPiped;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.core.IServer;

public class ViewLogHandler
extends AbstractGlassfishSelectionHandler {
    @Override
    public void processSelection(IStructuredSelection selection) {
        IServer server = (IServer)selection.getFirstElement();
        try {
            GlassFishServer serverAdapter = (GlassFishServer)((Object)server.loadAdapter(GlassFishServer.class, null));
            if (serverAdapter.isRemote()) {
                if (!serverAdapter.getServerBehaviourAdapter().getServerStatus(true).equals((Object)ServerStatus.RUNNING_DOMAIN_MATCHING)) {
                    this.showMessageDialog();
                    return;
                }
                GlassfishConsoleManager.removeServerLogFileConsole(serverAdapter);
            }
            IGlassFishConsole console = GlassfishConsoleManager.getServerLogFileConsole(serverAdapter);
            GlassfishConsoleManager.showConsole(console);
            if (!console.isLogging()) {
                console.startLogging(FetchLogPiped.create(serverAdapter, false));
            }
        }
        catch (Exception e) {
            GlassfishToolsPlugin.logMessage("Error opening log: " + e.getMessage());
        }
    }
}

