/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.internal;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.ICreateGlassfishDomainOp;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;

public class CreateGlassfishDomainOpMethods {
    public static org.eclipse.sapphire.modeling.Status execute(ICreateGlassfishDomainOp op, ProgressMonitor mon) {
        Path root = (Path)op.getLocation().content();
        File asadmin = new File(new File(root.toFile(), "bin"), Platform.getOS().equals("win32") ? "asadmin.bat" : "asadmin");
        if (asadmin.exists()) {
            String javaExecutablePath = asadmin.getAbsolutePath();
            Object[] cmdLine = new String[]{javaExecutablePath, "create-domain", "--nopassword=true", "--portbase", String.valueOf(op.getPortBase().content()), "--domaindir", ((Path)op.getDomainDir().content()).toPortableString(), (String)op.getName().content()};
            Process p = null;
            try {
                final StringBuilder output = new StringBuilder();
                final StringBuilder errOutput = new StringBuilder();
                output.append(String.valueOf(Arrays.toString(cmdLine)) + "\n");
                String[] envp = new String[]{"AS_JAVA=" + op.getJavaLocation().content()};
                p = DebugPlugin.exec((String[])cmdLine, null, (String[])envp);
                IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"GlassFish asadmin");
                process.getStreamsProxy().getOutputStreamMonitor().addListener(new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        output.append(text);
                    }
                });
                process.getStreamsProxy().getErrorStreamMonitor().addListener(new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        errOutput.append(text);
                    }
                });
                int i = 0;
                while (i < 600) {
                    if (process.isTerminated()) {
                        String msg = String.valueOf(output.toString()) + "\n" + errOutput.toString();
                        Status status = new Status(1, "org.eclipse.glassfish.tools", 1, msg, null);
                        GlassfishToolsPlugin.getInstance().getLog().log((IStatus)status);
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                        mon.worked(10);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
                File f = new File(((Path)op.getDomainDir().content()).toFile(), (String)op.getName().content());
                if (!f.exists()) {
                    org.eclipse.sapphire.modeling.Status status = org.eclipse.sapphire.modeling.Status.createErrorStatus((String)errOutput.toString());
                    return status;
                }
            }
            catch (CoreException ioe) {
                LaunchingPlugin.log((Throwable)ioe);
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
        }
        return org.eclipse.sapphire.modeling.Status.createOkStatus();
    }
}

