/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.internal.RuntimeComponentProvidersExtensionPoint;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jst.common.project.facet.core.StandardJreRuntimeComponent;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;

public final class GlassFishRuntimeBridge
implements IRuntimeBridge {
    public Set<String> getExportedRuntimeNames() throws CoreException {
        SetFactory namesSetFactory = SetFactory.start();
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            IRuntimeType type = runtime.getRuntimeType();
            if (type != null && "glassfish".equals(type.getId())) {
                namesSetFactory.add((Object)runtime.getId());
            }
            ++n2;
        }
        return namesSetFactory.result();
    }

    public IRuntimeBridge.IStub bridge(String name) throws CoreException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return new Stub(name);
    }

    private static class Stub
    extends IRuntimeBridge.Stub {
        private String id;

        public Stub(String id) {
            this.id = id;
        }

        public List<IRuntimeComponent> getRuntimeComponents() {
            Version gfVersion;
            ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>(2);
            IRuntime runtime = Stub.findRuntime(this.id);
            if (runtime == null) {
                return components;
            }
            GlassFishRuntime gfRuntime = (GlassFishRuntime)((Object)runtime.loadAdapter(GlassFishRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
            if (gfRuntime != null && (gfVersion = gfRuntime.getVersion()) != null) {
                IRuntimeComponentType gfComponentType = RuntimeManager.getRuntimeComponentType((String)"glassfish");
                String gfComponentVersionStr = gfVersion.matches("[5") ? "5" : (gfVersion.matches("[4") ? "4" : "3.1");
                IRuntimeComponentVersion gfComponentVersion = gfComponentType.getVersion(gfComponentVersionStr);
                HashMap<String, String> properties = new HashMap<String, String>(5);
                if (runtime.getLocation() != null) {
                    properties.put("location", runtime.getLocation().toPortableString());
                } else {
                    properties.put("location", "");
                }
                properties.put("name", runtime.getName());
                properties.put("id", runtime.getId());
                if (runtime.getRuntimeType() != null) {
                    properties.put("type", runtime.getRuntimeType().getName());
                    properties.put("type-id", runtime.getRuntimeType().getId());
                }
                components.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)gfComponentVersion, properties));
                components.add(StandardJreRuntimeComponent.create((IVMInstall)gfRuntime.getVMInstall()));
                components.addAll(RuntimeComponentProvidersExtensionPoint.getRuntimeComponents(runtime));
            }
            return components;
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> props = new HashMap<String, String>();
            IRuntime runtime = Stub.findRuntime(this.id);
            if (runtime != null) {
                props.put("id", runtime.getId());
                props.put("localized-name", runtime.getName());
                String s = ((Runtime)runtime).getAttribute("alternate-names", null);
                if (s != null) {
                    props.put("alternate-names", s);
                }
            }
            return props;
        }

        public IStatus validate(IProgressMonitor monitor) {
            IRuntime runtime = Stub.findRuntime(this.id);
            if (runtime != null) {
                return runtime.validate(monitor);
            }
            return Status.OK_STATUS;
        }

        private static final IRuntime findRuntime(String id) {
            IRuntime[] runtimes = ServerCore.getRuntimes();
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (runtimes[i].getId().equals(id)) {
                    return runtimes[i];
                }
                if (runtimes[i].getName().equals(id)) {
                    return runtimes[i];
                }
                ++i;
            }
            return null;
        }
    }
}

