/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.RuntimeComponentProvider;
import org.eclipse.glassfish.tools.utils.PluginUtil;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;

public final class RuntimeComponentProvidersExtensionPoint {
    public static final String EXTENSION_POINT_ID = "runtimeComponentProviders";
    private static final String EL_RUNTIME_COMPONENT_PROVIDER = "runtime-component-provider";
    private static final String ATTR_CLASS = "class";
    private static List<RuntimeComponentProvider> providers = null;

    public static List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
        ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>();
        for (RuntimeComponentProvider provider : RuntimeComponentProvidersExtensionPoint.getProviders()) {
            try {
                List<IRuntimeComponent> res = provider.getRuntimeComponents(runtime);
                if (res == null) continue;
                components.addAll(res);
            }
            catch (Exception e) {
                GlassfishToolsPlugin.log(e);
            }
        }
        return components;
    }

    private static synchronized List<RuntimeComponentProvider> getProviders() {
        if (providers == null) {
            ArrayList<RuntimeComponentProvider> list = new ArrayList<RuntimeComponentProvider>();
            for (ProviderDef pdef : RuntimeComponentProvidersExtensionPoint.readExtensions()) {
                RuntimeComponentProvider provider = PluginUtil.instantiate(pdef.pluginId, pdef.className, RuntimeComponentProvider.class);
                if (provider == null) continue;
                list.add(provider);
            }
            providers = Collections.unmodifiableList(list);
        }
        return providers;
    }

    private static List<ProviderDef> readExtensions() {
        ArrayList<ProviderDef> providers = new ArrayList<ProviderDef>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.glassfish.tools", EXTENSION_POINT_ID))) {
            String pluginId = element.getContributor().getName();
            if (!element.getName().equals(EL_RUNTIME_COMPONENT_PROVIDER)) continue;
            try {
                String className = PluginUtil.findRequiredAttribute(element, ATTR_CLASS);
                providers.add(new ProviderDef(pluginId, className));
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        return providers;
    }

    private static final class ProviderDef {
        public final String pluginId;
        public final String className;

        public ProviderDef(String pluginId, String className) {
            this.pluginId = pluginId;
            this.className = className;
        }
    }
}

