/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.internal;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.ServerStatus;
import org.eclipse.glassfish.tools.internal.ServerStateListener;
import org.eclipse.glassfish.tools.utils.ServerStatusHelper;

public class ServerStatusMonitor
implements Runnable {
    private static final int DEFAULT_DELAY_IN_SEC = 5;
    private ScheduledExecutorService scheduler;
    private GlassFishServer server;
    private int delay;
    private ScheduledFuture<?> scheduledTask;
    private volatile ServerStatus status = ServerStatus.NOT_DEFINED;
    private CopyOnWriteArrayList<ServerStateListener> listeners = null;

    private ServerStatusMonitor(GlassFishServer server) {
        this(server, 5, new ServerStateListener[0]);
    }

    private ServerStatusMonitor(GlassFishServer server, ServerStateListener ... listeners) {
        this(server, 5, listeners);
    }

    private ServerStatusMonitor(GlassFishServer server, int checkInterval, ServerStateListener ... listeners) {
        this.server = server;
        this.delay = checkInterval;
        this.listeners = new CopyOnWriteArrayList<ServerStateListener>(listeners);
    }

    public static ServerStatusMonitor getInstance(GlassFishServer server) {
        return new ServerStatusMonitor(server);
    }

    public static ServerStatusMonitor getInstance(GlassFishServer server, ServerStateListener ... listeners) {
        return new ServerStatusMonitor(server, listeners);
    }

    public static ServerStatusMonitor getInstance(GlassFishServer server, int checkInterval) {
        return new ServerStatusMonitor(server, checkInterval, new ServerStateListener[0]);
    }

    public void start() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduledTask = this.scheduler.scheduleWithFixedDelay(this, 0L, this.delay, TimeUnit.SECONDS);
    }

    public void stop() {
        this.scheduledTask.cancel(true);
        this.scheduler.shutdown();
    }

    @Override
    public void run() {
        this.status = ServerStatusHelper.checkServerStatus(this.server);
        this.notifyListeners(this.status);
    }

    public ServerStatus getServerStatus(boolean forceUpdate) {
        if (forceUpdate) {
            Future<?> f = this.scheduler.submit(this);
            try {
                f.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
        }
        return this.status;
    }

    public ServerStatus getServerStatus() {
        return this.getServerStatus(false);
    }

    private void notifyListeners(ServerStatus newStatus) {
        for (ServerStateListener listener : this.listeners) {
            listener.serverStatusChanged(newStatus);
        }
    }

    public void registerServerStatusListener(ServerStateListener listener) {
        this.listeners.add(listener);
    }
}

