/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.log;

import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.log.ILogFilter;
import org.eclipse.glassfish.tools.log.LevelResolver;
import org.eclipse.glassfish.tools.log.LogFormatterSimple;
import org.eclipse.glassfish.tools.log.LogRecord;
import org.eclipse.glassfish.tools.log.PatternLogFilterV4;
import org.eclipse.glassfish.tools.log.StateLogFilterV3;

public abstract class AbstractLogFilter
implements ILogFilter {
    private static final String DEFAULT_DELIMETER = "";
    protected StringBuilder buffer = new StringBuilder(1024);
    protected String logRecordDelimeter = "";
    protected ILevelResolver levelResolver;
    protected LogRecord record = new LogRecord();
    protected ILogFormatter formatter;

    protected AbstractLogFilter() {
        this(new LogFormatterSimple(), new LevelResolver(), DEFAULT_DELIMETER);
    }

    protected AbstractLogFilter(ILogFormatter formatter, ILevelResolver resolver) {
        this(formatter, resolver, DEFAULT_DELIMETER);
    }

    protected AbstractLogFilter(ILogFormatter formatter, ILevelResolver resolver, String logRecordDelimeter) {
        this.formatter = formatter;
        this.levelResolver = resolver;
        this.logRecordDelimeter = logRecordDelimeter;
    }

    @Override
    public void reset() {
        this.record.reset();
        this.buffer.setLength(0);
    }

    protected abstract boolean isReadingUserMessage();

    @Override
    public abstract String process(String var1);

    public static AbstractLogFilter createFilter(GlassFishServer server) {
        if (server.getVersion().matches("[4")) {
            return new PatternLogFilterV4();
        }
        return new StateLogFilterV3();
    }

    public static enum GlassfishLogFields {
        DATETIME,
        LEVEL,
        VERSION,
        CLASSINFO,
        THREADINFO,
        MESSAGE;

    }

    public static interface ILevelResolver {
        public String resolve(String var1);
    }

    public static interface ILogFormatter {
        public String formatLogRecord(LogRecord var1);
    }
}

