/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.log;

import java.io.File;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.log.AbstractLogFilter;
import org.eclipse.glassfish.tools.log.GlassfishConsole;
import org.eclipse.glassfish.tools.log.GlassfishStartupConsole;
import org.eclipse.glassfish.tools.log.IGlassFishConsole;
import org.eclipse.glassfish.tools.log.NoOpFilter;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class GlassfishConsoleManager {
    private static IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();

    public static IGlassFishConsole showConsole(IGlassFishConsole console) {
        manager.addConsoles(new IConsole[]{console});
        manager.showConsoleView((IConsole)console);
        return console;
    }

    public static IGlassFishConsole getStandardConsole(GlassFishServer server) {
        String consoleID = GlassfishConsoleManager.createStandardConsoleName(server);
        IGlassFishConsole gfConsole = GlassfishConsoleManager.findConsole(consoleID);
        if (gfConsole == null) {
            gfConsole = new GlassfishConsole(consoleID, AbstractLogFilter.createFilter(server));
        }
        return gfConsole;
    }

    public static IGlassFishConsole getServerLogFileConsole(GlassFishServer server) {
        String consoleID = GlassfishConsoleManager.createServerLogConsoleName(server);
        IGlassFishConsole gfConsole = GlassfishConsoleManager.findConsole(consoleID);
        if (gfConsole == null) {
            gfConsole = new GlassfishConsole(consoleID, AbstractLogFilter.createFilter(server));
        }
        return gfConsole;
    }

    public static IGlassFishConsole getStartupProcessConsole(GlassFishServer server, Process launchProcess) {
        String consoleID = GlassfishConsoleManager.createStartupProcessConsoleName(server);
        IGlassFishConsole gfConsole = GlassfishConsoleManager.findConsole(consoleID);
        if (gfConsole == null) {
            gfConsole = new GlassfishStartupConsole(consoleID, new NoOpFilter());
        }
        return gfConsole;
    }

    public static void removeServerLogFileConsole(GlassFishServer server) {
        String consoleID = GlassfishConsoleManager.createServerLogConsoleName(server);
        IGlassFishConsole gfConsole = GlassfishConsoleManager.findConsole(consoleID);
        if (gfConsole != null) {
            manager.removeConsoles(new IConsole[]{gfConsole});
        }
    }

    private static String createServerLogConsoleName(GlassFishServer server) {
        return server.isRemote() ? server.getServer().getName() : String.valueOf(server.getDomainsFolder()) + File.separator + server.getDomainName() + File.separator + "logs" + File.separator + "server.log";
    }

    private static String createStartupProcessConsoleName(GlassFishServer server) {
        return String.valueOf(server.getServer().getName()) + " startup process";
    }

    private static String createStandardConsoleName(GlassFishServer server) {
        return server.getServer().getName();
    }

    private static IGlassFishConsole findConsole(String name) {
        IConsole[] existing = manager.getConsoles();
        IGlassFishConsole myConsole = null;
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                myConsole = (IGlassFishConsole)existing[i];
                return myConsole;
            }
            ++i;
        }
        return null;
    }
}

